/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.scp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.sshd.ClientSession;
import org.apache.sshd.client.ScpClient;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.FileSystemView;
import org.apache.sshd.common.file.SshFile;
import org.apache.sshd.common.scp.ScpHelper;

public class DefaultScpClient
implements ScpClient {
    private final ClientSession clientSession;

    public DefaultScpClient(ClientSession clientSession) {
        this.clientSession = clientSession;
    }

    @Override
    public void download(String remote, String local, ScpClient.Option ... options) throws IOException {
        local = this.checkNotNullAndNotEmpty(local, "Invalid argument local: {}");
        remote = this.checkNotNullAndNotEmpty(remote, "Invalid argument remote: {}");
        this.download(remote, local, Arrays.asList(options));
    }

    @Override
    public void download(String[] remote, String local, ScpClient.Option ... options) throws IOException {
        local = this.checkNotNullAndNotEmpty(local, "Invalid argument local: {}");
        remote = this.checkNotNullAndNotEmpty(remote, "Invalid argument remote: {}");
        List<ScpClient.Option> opts = this.options(options);
        if (remote.length > 1) {
            opts.add(ScpClient.Option.TargetIsDirectory);
        }
        for (String r : remote) {
            this.download(r, local, opts);
        }
    }

    protected void download(String remote, String local, Collection<ScpClient.Option> options) throws IOException {
        local = this.checkNotNullAndNotEmpty(local, "Invalid argument local: {}");
        remote = this.checkNotNullAndNotEmpty(remote, "Invalid argument remote: {}");
        StringBuilder sb = new StringBuilder("scp");
        if (options.contains((Object)ScpClient.Option.Recursive)) {
            sb.append(" -r");
        }
        if (options.contains((Object)ScpClient.Option.PreserveAttributes)) {
            sb.append(" -p");
        }
        sb.append(" -f");
        sb.append(" --");
        sb.append(" ");
        sb.append(remote);
        FileSystemFactory factory = this.clientSession.getFactoryManager().getFileSystemFactory();
        FileSystemView fs = factory.createFileSystemView(this.clientSession);
        SshFile target = fs.getFile(local);
        if (options.contains((Object)ScpClient.Option.TargetIsDirectory)) {
            if (!target.doesExist()) {
                throw new SshException("Target directory " + target.toString() + " does not exists");
            }
            if (!target.isDirectory()) {
                throw new SshException("Target directory " + target.toString() + " is not a directory");
            }
        }
        ChannelExec channel = this.clientSession.createExecChannel(sb.toString());
        try {
            channel.open().await();
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        ScpHelper helper = new ScpHelper(channel.getInvertedOut(), channel.getInvertedIn(), fs);
        helper.receive(target, options.contains((Object)ScpClient.Option.Recursive), options.contains((Object)ScpClient.Option.TargetIsDirectory), options.contains((Object)ScpClient.Option.PreserveAttributes), 8192);
        channel.close(false);
    }

    @Override
    public void upload(String local, String remote, ScpClient.Option ... options) throws IOException {
        local = this.checkNotNullAndNotEmpty(local, "Invalid argument local: {}");
        remote = this.checkNotNullAndNotEmpty(remote, "Invalid argument remote: {}");
        this.upload(new String[]{local}, remote, this.options(options));
    }

    @Override
    public void upload(String[] local, String remote, ScpClient.Option ... options) throws IOException {
        local = this.checkNotNullAndNotEmpty(local, "Invalid argument local: {}");
        remote = this.checkNotNullAndNotEmpty(remote, "Invalid argument remote: {}");
        List<ScpClient.Option> opts = this.options(options);
        if (local.length > 1) {
            opts.add(ScpClient.Option.TargetIsDirectory);
        }
        this.upload(local, remote, opts);
    }

    protected void upload(String[] local, String remote, Collection<ScpClient.Option> options) throws IOException {
        local = this.checkNotNullAndNotEmpty(local, "Invalid argument local: {}");
        remote = this.checkNotNullAndNotEmpty(remote, "Invalid argument remote: {}");
        StringBuilder sb = new StringBuilder("scp");
        if (options.contains((Object)ScpClient.Option.Recursive)) {
            sb.append(" -r");
        }
        if (options.contains((Object)ScpClient.Option.TargetIsDirectory)) {
            sb.append(" -d");
        }
        if (options.contains((Object)ScpClient.Option.PreserveAttributes)) {
            sb.append(" -p");
        }
        sb.append(" -t");
        sb.append(" --");
        sb.append(" ");
        sb.append(remote);
        ChannelExec channel = this.clientSession.createExecChannel(sb.toString());
        try {
            channel.open().await();
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        FileSystemFactory factory = this.clientSession.getFactoryManager().getFileSystemFactory();
        FileSystemView fs = factory.createFileSystemView(this.clientSession);
        ScpHelper helper = new ScpHelper(channel.getInvertedOut(), channel.getInvertedIn(), fs);
        helper.send(Arrays.asList(local), options.contains((Object)ScpClient.Option.Recursive), options.contains((Object)ScpClient.Option.PreserveAttributes), 8192);
        channel.close(false);
    }

    private List<ScpClient.Option> options(ScpClient.Option ... options) {
        ArrayList<ScpClient.Option> opts = new ArrayList<ScpClient.Option>();
        if (options != null) {
            opts.addAll(Arrays.asList(options));
        }
        return opts;
    }

    private <T> T checkNotNull(T t, String message) {
        if (t == null) {
            throw new IllegalStateException(String.format(message, t));
        }
        return t;
    }

    private String checkNotNullAndNotEmpty(String t, String message) {
        if ((t = this.checkNotNull(t, message).trim()).isEmpty()) {
            throw new IllegalArgumentException(String.format(message, t));
        }
        return t;
    }

    private <T> T[] checkNotNullAndNotEmpty(T[] t, String message) {
        if ((t = this.checkNotNull(t, message)).length == 0) {
            throw new IllegalArgumentException(String.format(message, t));
        }
        return t;
    }
}

