/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.AbstractConnectionService;
import org.apache.sshd.common.util.Buffer;

public class ClientConnectionService
extends AbstractConnectionService {
    public ClientConnectionService(Session s) throws SshException {
        super(s);
        if (!(s instanceof ClientSessionImpl)) {
            throw new IllegalStateException("Client side service used on server side");
        }
    }

    @Override
    public void start() {
        if (!((ClientSessionImpl)this.session).isAuthenticated()) {
            throw new IllegalStateException("Session is not authenticated");
        }
        this.startHeartBeat();
    }

    protected void startHeartBeat() {
        String intervalStr = this.session.getFactoryManager().getProperties().get("hearbeat-interval");
        try {
            int interval;
            int n = interval = intervalStr != null ? Integer.parseInt(intervalStr) : 0;
            if (interval > 0) {
                this.session.getFactoryManager().getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        ClientConnectionService.this.sendHeartBeat();
                    }
                }, interval, interval, TimeUnit.MILLISECONDS);
            }
        }
        catch (NumberFormatException e) {
            this.log.warn("Ignoring bad heartbeat interval: {}", (Object)intervalStr);
        }
    }

    protected void sendHeartBeat() {
        try {
            Buffer buf = this.session.createBuffer((byte)80);
            String request = this.session.getFactoryManager().getProperties().get("heartbeat-request");
            if (request == null) {
                request = "keepalive@sshd.apache.org";
            }
            buf.putString(request);
            buf.putBoolean(false);
            this.session.writePacket(buf);
        }
        catch (IOException e) {
            this.log.info("Error sending keepalive message", (Throwable)e);
        }
    }

    @Override
    public String initAgentForward() throws IOException {
        throw new IllegalStateException("Server side operation");
    }

    @Override
    public String createX11Display(boolean singleConnection, String authenticationProtocol, String authenticationCookie, int screen) throws IOException {
        throw new IllegalStateException("Server side operation");
    }

    public static class Factory
    implements ServiceFactory {
        @Override
        public String getName() {
            return "ssh-connection";
        }

        @Override
        public Service create(Session session) throws IOException {
            return new ClientConnectionService(session);
        }
    }
}

