/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.util.List;
import org.apache.sshd.client.auth.deprecated.UserAuth;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.client.session.ClientUserAuthServiceNew;
import org.apache.sshd.client.session.ClientUserAuthServiceOld;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.CloseableUtils;

public class ClientUserAuthService
extends CloseableUtils.AbstractInnerCloseable
implements Service {
    protected final ClientSessionImpl session;
    protected ClientUserAuthServiceNew delegateNew;
    protected ClientUserAuthServiceOld delegateOld;
    protected boolean started;
    protected DefaultCloseFuture future = new DefaultCloseFuture(null);

    public ClientUserAuthService(Session s) {
        if (!(s instanceof ClientSessionImpl)) {
            throw new IllegalStateException("Client side service used on server side");
        }
        this.session = (ClientSessionImpl)s;
    }

    @Override
    public ClientSessionImpl getSession() {
        return this.session;
    }

    @Override
    public void start() {
        if (this.delegateNew != null) {
            this.delegateNew.start();
        } else if (this.delegateOld != null) {
            this.delegateOld.start();
        }
        this.started = true;
    }

    @Override
    public void process(byte cmd, Buffer buffer) throws Exception {
        if (this.delegateNew != null) {
            this.delegateNew.process(cmd, buffer);
        } else if (this.delegateOld != null) {
            this.delegateOld.process(cmd, buffer);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        if (this.delegateNew != null) {
            return this.delegateNew;
        }
        if (this.delegateOld != null) {
            return this.delegateOld;
        }
        return this.builder().build();
    }

    public AuthFuture auth(UserAuth userAuth) throws IOException {
        if (this.delegateNew != null) {
            throw new IllegalStateException();
        }
        if (this.delegateOld == null) {
            this.delegateOld = new ClientUserAuthServiceOld(this.session);
            if (this.started) {
                this.delegateOld.start();
            }
        }
        return this.delegateOld.auth(userAuth);
    }

    public AuthFuture auth(List<Object> identities, String service) throws IOException {
        if (this.delegateOld != null || this.delegateNew != null) {
            throw new IllegalStateException();
        }
        this.delegateNew = new ClientUserAuthServiceNew(this.session);
        if (this.started) {
            this.delegateNew.start();
        }
        return this.delegateNew.auth(identities, service);
    }

    public static class Factory
    implements ServiceFactory {
        @Override
        public String getName() {
            return "ssh-userauth";
        }

        @Override
        public Service create(Session session) throws IOException {
            return new ClientUserAuthService(session);
        }
    }
}

