/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.io.IoInputStream;
import org.apache.sshd.common.io.IoReadFuture;
import org.apache.sshd.common.io.ReadPendingException;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.Readable;

public class ChannelAsyncInputStream
extends CloseableUtils.AbstractCloseable
implements IoInputStream {
    private final Channel channel;
    private final Buffer buffer = new Buffer();
    private IoReadFutureImpl pending;

    public ChannelAsyncInputStream(Channel channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Readable src) throws IOException {
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            this.buffer.putBuffer(src);
        }
        this.doRead(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoReadFuture read(Buffer buf) {
        IoReadFutureImpl future = new IoReadFutureImpl(buf);
        if (this.isClosing()) {
            future.setValue(new IOException("Closed"));
        } else {
            Buffer buffer = this.buffer;
            synchronized (buffer) {
                if (this.pending != null) {
                    throw new ReadPendingException();
                }
                this.pending = future;
            }
            this.doRead(false);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preClose() {
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            if (this.buffer.available() == 0 && this.pending != null) {
                this.pending.setValue(new SshException("Closed"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CloseFuture doCloseGracefully() {
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            return this.builder().when(this.pending).build().close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRead(boolean resume) {
        IoReadFutureImpl future = null;
        int nbRead = 0;
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            if (this.buffer.available() > 0) {
                if (resume) {
                    // empty if block
                }
                future = this.pending;
                this.pending = null;
                if (future != null) {
                    nbRead = future.buffer.putBuffer(this.buffer, false);
                    this.buffer.compact();
                }
            } else if (!resume) {
                // empty if block
            }
        }
        if (nbRead > 0) {
            try {
                this.channel.getLocalWindow().consumeAndCheck(nbRead);
            }
            catch (IOException e) {
                this.channel.getSession().exceptionCaught(e);
            }
            future.setValue(nbRead);
        }
    }

    public String toString() {
        return "ChannelAsyncInputStream[" + this.channel + "]";
    }

    public static class IoReadFutureImpl
    extends DefaultSshFuture<IoReadFuture>
    implements IoReadFuture {
        final Buffer buffer;

        public IoReadFutureImpl(Buffer buffer) {
            super(null);
            this.buffer = buffer;
        }

        @Override
        public Buffer getBuffer() {
            return this.buffer;
        }

        @Override
        public void verify() throws SshException {
            try {
                this.await();
            }
            catch (InterruptedException e) {
                throw new SshException("Interrupted", (Throwable)e);
            }
            if (this.getValue() instanceof Throwable) {
                throw new SshException("Write failed", this.getException());
            }
        }

        @Override
        public int getRead() {
            Object v = this.getValue();
            if (v instanceof RuntimeException) {
                throw (RuntimeException)v;
            }
            if (v instanceof Error) {
                throw (Error)v;
            }
            if (v instanceof Throwable) {
                throw (RuntimeSshException)new RuntimeSshException("Error reading from channel.").initCause((Throwable)v);
            }
            if (v instanceof Integer) {
                return (Integer)v;
            }
            throw new IllegalStateException();
        }

        @Override
        public Throwable getException() {
            Object v = this.getValue();
            if (v instanceof Throwable) {
                return (Throwable)v;
            }
            return null;
        }
    }
}

