/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.virtualfs;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.FileSystemView;
import org.apache.sshd.common.file.nativefs.NativeFileSystemView;

public class VirtualFileSystemFactory
implements FileSystemFactory {
    private String defaultHomeDir;
    private final Map<String, String> homeDirs = new ConcurrentHashMap<String, String>();

    public VirtualFileSystemFactory() {
    }

    public VirtualFileSystemFactory(String defaultHomeDir) {
        this.defaultHomeDir = defaultHomeDir;
    }

    public void setDefaultHomeDir(String defaultHomeDir) {
        this.defaultHomeDir = defaultHomeDir;
    }

    public String getDefaultHomeDir() {
        return this.defaultHomeDir;
    }

    public void setUserHomeDir(String userName, String userHomeDir) {
        this.homeDirs.put(userName, userHomeDir);
    }

    public String getUserHomeDir(String userName) {
        return this.homeDirs.get(userName);
    }

    protected String computeRootDir(String userName) {
        String homeDir = this.homeDirs.get(userName);
        if (homeDir == null) {
            homeDir = this.defaultHomeDir;
        }
        if (homeDir == null) {
            throw new IllegalStateException("No home directory for user " + userName);
        }
        return homeDir;
    }

    @Override
    public FileSystemView createFileSystemView(Session session) {
        String dir = this.computeRootDir(session.getUsername());
        HashMap<String, String> roots = new HashMap<String, String>();
        roots.put("/", dir);
        return new NativeFileSystemView(session.getUsername(), roots, "/", '/', false);
    }
}

