/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.mina;

import java.net.SocketAddress;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.mina.MinaService;

public class MinaConnector
extends MinaService
implements IoConnector,
org.apache.mina.core.service.IoHandler {
    protected volatile org.apache.mina.core.service.IoConnector connector;

    public MinaConnector(FactoryManager manager, IoHandler handler, IoProcessor<NioSession> ioProcessor) {
        super(manager, handler, ioProcessor);
    }

    protected org.apache.mina.core.service.IoConnector createConnector() {
        NioSocketConnector connector = new NioSocketConnector(this.ioProcessor);
        this.configure(connector.getSessionConfig());
        return connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.apache.mina.core.service.IoConnector getConnector() {
        if (this.connector == null) {
            MinaConnector minaConnector = this;
            synchronized (minaConnector) {
                if (this.connector == null) {
                    this.connector = this.createConnector();
                    this.connector.setHandler((org.apache.mina.core.service.IoHandler)this);
                }
            }
        }
        return this.connector;
    }

    @Override
    protected IoService getIoService() {
        return this.getConnector();
    }

    @Override
    public IoConnectFuture connect(SocketAddress address) {
        class Future
        extends DefaultSshFuture<IoConnectFuture>
        implements IoConnectFuture {
            Future(Object lock) {
                super(lock);
            }

            @Override
            public IoSession getSession() {
                Object v = this.getValue();
                return v instanceof IoSession ? (IoSession)v : null;
            }

            @Override
            public Throwable getException() {
                Object v = this.getValue();
                return v instanceof Throwable ? (Throwable)v : null;
            }

            @Override
            public boolean isConnected() {
                return this.getValue() instanceof IoSession;
            }

            @Override
            public void setSession(IoSession session) {
                this.setValue(session);
            }

            @Override
            public void setException(Throwable exception) {
                this.setValue(exception);
            }
        }
        final Future future = new Future(null);
        this.getConnector().connect(address).addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

            public void operationComplete(ConnectFuture cf) {
                if (cf.getException() != null) {
                    future.setException(cf.getException());
                } else if (cf.isCanceled()) {
                    future.cancel();
                } else {
                    future.setSession(MinaConnector.this.getSession(cf.getSession()));
                }
            }
        });
        return future;
    }
}

