/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketOption;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.NetworkChannel;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.CloseableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Nio2Service
extends CloseableUtils.AbstractInnerCloseable
implements IoService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final FactoryManager manager;
    protected final IoHandler handler;
    protected final Map<Long, IoSession> sessions;
    protected final AtomicBoolean disposing = new AtomicBoolean();
    protected final AsynchronousChannelGroup group;

    protected Nio2Service(FactoryManager manager, IoHandler handler, AsynchronousChannelGroup group) {
        this.logger.debug("Creating {}", (Object)this.getClass().getSimpleName());
        this.manager = manager;
        this.handler = handler;
        this.sessions = new ConcurrentHashMap<Long, IoSession>();
        this.group = group;
    }

    @Override
    public void dispose() {
        try {
            this.close(true).await();
        }
        catch (InterruptedException e) {
            this.logger.debug("Exception caught while closing", (Throwable)e);
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().parallel(this.sessions.values()).build();
    }

    @Override
    public Map<Long, IoSession> getManagedSessions() {
        return Collections.unmodifiableMap(this.sessions);
    }

    public void sessionClosed(Nio2Session session) {
        this.sessions.remove(session.getId());
    }

    protected <T> void setOption(NetworkChannel socket, String property, SocketOption<T> option, T defaultValue) throws IOException {
        String valStr = this.manager.getProperties().get(property);
        T val = defaultValue;
        if (valStr != null) {
            Class<T> type = option.type();
            if (type == Integer.class) {
                val = type.cast(Integer.parseInt(valStr));
            } else if (type == Boolean.class) {
                val = type.cast(Boolean.parseBoolean(valStr));
            } else {
                throw new IllegalStateException("Unsupported socket option type " + type);
            }
        }
        if (val != null) {
            try {
                socket.setOption(option, val);
            }
            catch (IOException e) {
                this.logger.warn("Unable to set socket option " + option + " to " + val, (Throwable)e);
            }
        }
    }
}

