/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.nio2.Nio2Acceptor;
import org.apache.sshd.common.io.nio2.Nio2Connector;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.ThreadUtils;

public class Nio2ServiceFactory
extends CloseableUtils.AbstractCloseable
implements IoServiceFactory {
    private final FactoryManager manager;
    private final AsynchronousChannelGroup group;

    public Nio2ServiceFactory(FactoryManager manager) {
        this.manager = manager;
        try {
            ExecutorService executor = ThreadUtils.newFixedThreadPool(manager.toString() + "-nio2", this.getNioWorkers());
            this.group = AsynchronousChannelGroup.withThreadPool(executor);
        }
        catch (IOException e) {
            throw new RuntimeSshException(e);
        }
    }

    @Override
    public IoConnector createConnector(IoHandler handler) {
        return new Nio2Connector(this.manager, handler, this.group);
    }

    @Override
    public IoAcceptor createAcceptor(IoHandler handler) {
        return new Nio2Acceptor(this.manager, handler, this.group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCloseImmediately() {
        try {
            this.group.shutdownNow();
            this.group.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.log.debug("Exception caught while closing channel group", (Throwable)e);
        }
        finally {
            super.doCloseImmediately();
        }
    }

    public int getNioWorkers() {
        int nb;
        String nioWorkers = this.manager.getProperties().get("nio-workers");
        if (nioWorkers != null && nioWorkers.length() > 0 && (nb = Integer.parseInt(nioWorkers)) > 0) {
            return nb;
        }
        return FactoryManager.DEFAULT_NIO_WORKERS;
    }
}

