/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.security.KeyPair;
import java.util.ArrayList;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.util.KeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKeyPairProvider
implements KeyPairProvider {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public KeyPair loadKey(String type) {
        assert (type != null);
        Iterable<KeyPair> keys = this.loadKeys();
        for (KeyPair key : keys) {
            if (!type.equals(KeyUtils.getKeyType(key))) continue;
            return key;
        }
        return null;
    }

    @Override
    public String getKeyTypes() {
        ArrayList<String> types = new ArrayList<String>();
        Iterable<KeyPair> keys = this.loadKeys();
        for (KeyPair key : keys) {
            String type = KeyUtils.getKeyType(key);
            if (type == null || types.contains(type)) continue;
            types.add(type);
        }
        StringBuilder sb = new StringBuilder();
        for (String type : types) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(type);
        }
        return sb.toString();
    }

    @Override
    public abstract Iterable<KeyPair> loadKeys();
}

