/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.mac;

import javax.crypto.spec.SecretKeySpec;
import org.apache.sshd.common.Mac;
import org.apache.sshd.common.util.SecurityUtils;

public class BaseMac
implements Mac {
    private final String algorithm;
    private final int defbsize;
    private final int bsize;
    private final byte[] tmp;
    private javax.crypto.Mac mac;

    public BaseMac(String algorithm, int bsize, int defbsize) {
        this.algorithm = algorithm;
        this.bsize = bsize;
        this.defbsize = defbsize;
        this.tmp = new byte[defbsize];
    }

    @Override
    public int getBlockSize() {
        return this.bsize;
    }

    @Override
    public void init(byte[] key) throws Exception {
        if (key.length > this.defbsize) {
            byte[] tmp = new byte[this.defbsize];
            System.arraycopy(key, 0, tmp, 0, this.defbsize);
            key = tmp;
        }
        SecretKeySpec skey = new SecretKeySpec(key, this.algorithm);
        this.mac = SecurityUtils.getMac(this.algorithm);
        this.mac.init(skey);
    }

    @Override
    public void updateUInt(long i) {
        this.tmp[0] = (byte)(i >>> 24);
        this.tmp[1] = (byte)(i >>> 16);
        this.tmp[2] = (byte)(i >>> 8);
        this.tmp[3] = (byte)i;
        this.update(this.tmp, 0, 4);
    }

    @Override
    public void update(byte[] foo, int s, int l) {
        this.mac.update(foo, s, l);
    }

    @Override
    public void doFinal(byte[] buf, int offset) throws Exception {
        if (this.bsize != this.defbsize) {
            this.mac.doFinal(this.tmp, 0);
            System.arraycopy(this.tmp, 0, buf, offset, this.bsize);
        } else {
            this.mac.doFinal(buf, offset);
        }
    }
}

