/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.random;

import java.security.SecureRandom;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Random;
import org.bouncycastle.crypto.prng.RandomGenerator;
import org.bouncycastle.crypto.prng.VMPCRandomGenerator;

public class BouncyCastleRandom
implements Random {
    private final RandomGenerator random = new VMPCRandomGenerator();

    public BouncyCastleRandom() {
        byte[] seed = new SecureRandom().generateSeed(8);
        this.random.addSeedMaterial(seed);
    }

    @Override
    public void fill(byte[] bytes, int start, int len) {
        this.random.nextBytes(bytes, start, len);
    }

    @Override
    public int random(int n) {
        if (n > 0) {
            int val;
            int bits;
            if ((n & -n) == n) {
                return (int)((long)n * (long)this.next(31) >> 31);
            }
            while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
            }
            return val;
        }
        throw new IllegalArgumentException();
    }

    protected final int next(int numBits) {
        int bytes = (numBits + 7) / 8;
        byte[] next = new byte[bytes];
        int ret = 0;
        this.random.nextBytes(next);
        for (int i = 0; i < bytes; ++i) {
            ret = next[i] & 0xFF | ret << 8;
        }
        return ret >>> bytes * 8 - numBits;
    }

    public static class Factory
    implements NamedFactory<Random> {
        @Override
        public String getName() {
            return "bouncycastle";
        }

        @Override
        public Random create() {
            return new BouncyCastleRandom();
        }
    }
}

