/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import org.apache.sshd.common.signature.AbstractSignature;
import org.apache.sshd.common.util.BufferUtils;
import org.apache.sshd.common.util.Pair;
import org.apache.sshd.common.util.io.der.DERWriter;

public abstract class AbstractSignatureDSA
extends AbstractSignature {
    public static final int DSA_SIGNATURE_LENGTH = 40;
    public static final int MAX_SIGNATURE_VALUE_LENGTH = 20;
    private static final int BYTES = 4;

    protected AbstractSignatureDSA(String algorithm) {
        super(algorithm);
    }

    @Override
    public byte[] sign() throws Exception {
        byte[] sig = this.signature.sign();
        int len = 0;
        int index = 3;
        len = sig[index++] & 0xFF;
        byte[] r = new byte[len];
        System.arraycopy(sig, index, r, 0, r.length);
        index = index + len + 1;
        len = sig[index++] & 0xFF;
        byte[] s = new byte[len];
        System.arraycopy(sig, index, s, 0, s.length);
        byte[] result = new byte[40];
        System.arraycopy(r, r.length > 20 ? 1 : 0, result, r.length > 20 ? 0 : 20 - r.length, r.length > 20 ? 20 : r.length);
        System.arraycopy(s, s.length > 20 ? 1 : 0, result, s.length > 20 ? 20 : 40 - s.length, s.length > 20 ? 20 : s.length);
        return result;
    }

    @Override
    public boolean verify(byte[] sig) throws Exception {
        byte[] encoded;
        byte[] sEncoding;
        byte[] rEncoding;
        Pair<String, byte[]> encoding;
        int sigLen = sig == null ? 0 : sig.length;
        byte[] data = sig;
        if (sigLen != 40 && (encoding = this.extractEncodedSignature(sig)) != null) {
            String keyType = encoding.getFirst();
            if (!"ssh-dss".equals(keyType)) {
                throw new IllegalArgumentException(String.format("Mismatched key type: %s", keyType));
            }
            data = encoding.getSecond();
            int n = sigLen = data == null ? 0 : data.length;
        }
        if (sigLen != 40) {
            throw new SignatureException("Bad signature length (" + sigLen + " instead of " + 40 + ")" + " for " + BufferUtils.toHex(':', data));
        }
        try (DERWriter w = new DERWriter(24);){
            w.writeBigInteger(data, 0, 20);
            rEncoding = w.toByteArray();
        }
        try (DERWriter w = new DERWriter(24);){
            w.writeBigInteger(data, 20, 20);
            sEncoding = w.toByteArray();
        }
        int length = rEncoding.length + sEncoding.length;
        try (DERWriter w = new DERWriter(1 + length + 4);){
            w.write(48);
            w.writeLength(length);
            w.write(rEncoding);
            w.write(sEncoding);
            encoded = w.toByteArray();
        }
        return this.signature.verify(encoded);
    }

    protected Pair<String, byte[]> extractEncodedSignature(byte[] sig) {
        int dataLen;
        int n = dataLen = sig == null ? 0 : sig.length;
        if (dataLen < 8) {
            return null;
        }
        long keyTypeLen = BufferUtils.getUInt(sig, 0, dataLen);
        if (keyTypeLen >= (long)(dataLen - 4)) {
            return null;
        }
        int keyTypeStartPos = 4;
        int keyTypeEndPos = keyTypeStartPos + (int)keyTypeLen;
        int remainLen = dataLen - keyTypeEndPos;
        if (remainLen < 4) {
            return null;
        }
        long dataBytesLen = BufferUtils.getUInt(sig, keyTypeEndPos, remainLen);
        if (dataBytesLen > (long)(remainLen - 4)) {
            return null;
        }
        String keyType = new String(sig, keyTypeStartPos, (int)keyTypeLen, StandardCharsets.UTF_8);
        byte[] data = new byte[(int)dataBytesLen];
        System.arraycopy(sig, keyTypeEndPos + 4, data, 0, (int)dataBytesLen);
        return new Pair<String, byte[]>(keyType, data);
    }
}

