/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Signature;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.signature.AbstractSignature;
import org.apache.sshd.common.util.Buffer;

public class SignatureECDSA
extends AbstractSignature {
    private static final String SIGNATURE_ALGORITHM_512 = "SHA512withECDSA";
    private static final String SIGNATURE_ALGORITHM_384 = "SHA384withECDSA";
    private static final String SIGNATURE_ALGORITHM_256 = "SHA256withECDSA";

    protected SignatureECDSA(String algo) {
        super(algo);
    }

    public static Signature getByCurveSize(ECParameterSpec params) {
        int curveSize = ECCurves.getCurveSize(params);
        if (curveSize <= 256) {
            return new SignatureECDSA(SIGNATURE_ALGORITHM_256);
        }
        if (curveSize <= 384) {
            return new SignatureECDSA(SIGNATURE_ALGORITHM_384);
        }
        return new SignatureECDSA(SIGNATURE_ALGORITHM_512);
    }

    @Override
    public byte[] sign() throws Exception {
        byte[] sig = this.signature.sign();
        if (sig[0] != 48 || sig[1] != sig.length - 2 || sig[2] != 2) {
            throw new IOException("Invalid signature format");
        }
        byte rLength = sig[3];
        if (rLength + 6 > sig.length || sig[4 + rLength] != 2) {
            throw new IOException("Invalid signature format");
        }
        byte sLength = sig[5 + rLength];
        if (6 + rLength + sLength > sig.length) {
            throw new IOException("Invalid signature format");
        }
        byte[] rArray = new byte[rLength];
        byte[] sArray = new byte[sLength];
        System.arraycopy(sig, 4, rArray, 0, rLength);
        System.arraycopy(sig, 6 + rLength, sArray, 0, sLength);
        BigInteger r = new BigInteger(rArray);
        BigInteger s = new BigInteger(sArray);
        Buffer rsBuf = new Buffer();
        rsBuf.putMPInt(r);
        rsBuf.putMPInt(s);
        return rsBuf.getCompactData();
    }

    @Override
    public boolean verify(byte[] sig) throws Exception {
        sig = this.extractSig(sig);
        Buffer rsBuf = new Buffer(sig);
        byte[] rArray = rsBuf.getMPIntAsBytes();
        byte[] sArray = rsBuf.getMPIntAsBytes();
        if (rsBuf.available() != 0) {
            throw new IOException("Signature had padding");
        }
        int frst = (rArray[0] & 0x80) != 0 ? 1 : 0;
        int scnd = (sArray[0] & 0x80) != 0 ? 1 : 0;
        int length = rArray.length + sArray.length + 6 + frst + scnd;
        byte[] tmp = new byte[length];
        tmp[0] = 48;
        tmp[1] = (byte)(rArray.length + sArray.length + 4);
        tmp[1] = (byte)(tmp[1] + frst);
        tmp[1] = (byte)(tmp[1] + scnd);
        tmp[2] = 2;
        tmp[3] = (byte)rArray.length;
        tmp[3] = (byte)(tmp[3] + frst);
        System.arraycopy(rArray, 0, tmp, 4 + frst, rArray.length);
        tmp[4 + tmp[3]] = 2;
        tmp[5 + tmp[3]] = (byte)sArray.length;
        int n = 5 + tmp[3];
        tmp[n] = (byte)(tmp[n] + scnd);
        System.arraycopy(sArray, 0, tmp, 6 + tmp[3] + scnd, sArray.length);
        sig = tmp;
        return this.signature.verify(sig);
    }

    public static class NISTP521Factory
    implements NamedFactory<Signature> {
        @Override
        public String getName() {
            return "ecdsa-sha2-nistp521";
        }

        @Override
        public Signature create() {
            return new SignatureECDSA(SignatureECDSA.SIGNATURE_ALGORITHM_512);
        }
    }

    public static class NISTP384Factory
    implements NamedFactory<Signature> {
        @Override
        public String getName() {
            return "ecdsa-sha2-nistp384";
        }

        @Override
        public Signature create() {
            return new SignatureECDSA(SignatureECDSA.SIGNATURE_ALGORITHM_384);
        }
    }

    public static class NISTP256Factory
    implements NamedFactory<Signature> {
        @Override
        public String getName() {
            return "ecdsa-sha2-nistp256";
        }

        @Override
        public Signature create() {
            return new SignatureECDSA(SignatureECDSA.SIGNATURE_ALGORITHM_256);
        }
    }
}

