/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.io.IOException;

public class BufferUtils {
    public static final char EMPTY_HEX_SEPARATOR = '\u0000';
    public static final String HEX_DIGITS = "0123456789abcdef";
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String printHex(byte[] array) {
        return BufferUtils.printHex(array, 0, array.length);
    }

    public static String printHex(byte[] array, int offset, int len) {
        return BufferUtils.printHex(array, offset, len, ' ');
    }

    public static String printHex(byte[] array, int offset, int len, char sep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            byte b = array[offset + i];
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(digits[b >> 4 & 0xF]);
            sb.append(digits[b & 0xF]);
        }
        return sb.toString();
    }

    public static boolean equals(byte[] a1, byte[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        return BufferUtils.equals(a1, 0, a2, 0, a1.length);
    }

    public static boolean equals(byte[] a1, int a1Offset, byte[] a2, int a2Offset, int length) {
        if (a1.length < a1Offset + length || a2.length < a2Offset + length) {
            return false;
        }
        while (length-- > 0) {
            if (a1[a1Offset++] == a2[a2Offset++]) continue;
            return false;
        }
        return true;
    }

    public static long getUInt(byte ... buf) {
        return BufferUtils.getUInt(buf, 0, buf == null ? 0 : buf.length);
    }

    public static long getUInt(byte[] buf, int off, int len) {
        if (len < 4) {
            throw new IllegalArgumentException("Not enough data for a UINT: required=4, available=" + len);
        }
        long l = (long)(buf[off] << 24) & 0xFF000000L;
        l |= (long)(buf[off + 1] << 16) & 0xFF0000L;
        l |= (long)(buf[off + 2] << 8) & 0xFF00L;
        return l |= (long)buf[off + 3] & 0xFFL;
    }

    public static int putUInt(long value, byte[] buf) {
        return BufferUtils.putUInt(value, buf, 0, buf == null ? 0 : buf.length);
    }

    public static int putUInt(long value, byte[] buf, int off, int len) {
        if (len < 4) {
            throw new IllegalArgumentException("Not enough data for a UINT: required=4, available=" + len);
        }
        buf[off] = (byte)(value >> 24 & 0xFFL);
        buf[off + 1] = (byte)(value >> 16 & 0xFFL);
        buf[off + 2] = (byte)(value >> 8 & 0xFFL);
        buf[off + 3] = (byte)(value & 0xFFL);
        return 4;
    }

    public static String toHex(char sep, byte ... array) {
        return BufferUtils.toHex(array, 0, array == null ? 0 : array.length, sep);
    }

    public static String toHex(byte[] array, int offset, int len, char sep) {
        if (len <= 0) {
            return "";
        }
        try {
            return BufferUtils.appendHex(new StringBuilder(len * 3), array, offset, len, sep).toString();
        }
        catch (IOException e) {
            return e.getClass().getSimpleName() + ": " + e.getMessage();
        }
    }

    public static <A extends Appendable> A appendHex(A sb, char sep, byte ... array) throws IOException {
        return BufferUtils.appendHex(sb, array, 0, array == null ? 0 : array.length, sep);
    }

    public static <A extends Appendable> A appendHex(A sb, byte[] array, int offset, int len, char sep) throws IOException {
        if (len <= 0) {
            return sb;
        }
        int maxOffset = offset + len;
        for (int curOffset = offset; curOffset < maxOffset; ++curOffset) {
            byte b = array[curOffset];
            if (curOffset > offset && sep != '\u0000') {
                sb.append(sep);
            }
            sb.append(HEX_DIGITS.charAt(b >> 4 & 0xF));
            sb.append(HEX_DIGITS.charAt(b & 0xF));
        }
        return sb;
    }
}

