/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseableUtils {
    public static CloseFuture closed() {
        DefaultCloseFuture future = new DefaultCloseFuture(null);
        future.setClosed();
        return future;
    }

    private CloseableUtils() {
    }

    public static abstract class AbstractInnerCloseable
    extends AbstractCloseable {
        protected abstract Closeable getInnerCloseable();

        @Override
        protected CloseFuture doCloseGracefully() {
            return this.getInnerCloseable().close(false);
        }

        @Override
        protected void doCloseImmediately() {
            this.getInnerCloseable().close(true).addListener(new SshFutureListener<CloseFuture>(){

                @Override
                public void operationComplete(CloseFuture future) {
                    AbstractInnerCloseable.super.doCloseImmediately();
                }
            });
        }
    }

    public static abstract class AbstractCloseable
    implements Closeable {
        protected final Logger log = LoggerFactory.getLogger(this.getClass());
        protected final Object lock = new Object();
        protected final AtomicReference<State> state = new AtomicReference<State>(State.Opened);
        protected final CloseFuture closeFuture = new DefaultCloseFuture(this.lock);

        @Override
        public CloseFuture close(boolean immediately) {
            if (immediately) {
                if (this.state.compareAndSet(State.Opened, State.Immediate) || this.state.compareAndSet(State.Graceful, State.Immediate)) {
                    this.log.debug("Closing {} immediately", (Object)this);
                    this.preClose();
                    this.doCloseImmediately();
                    this.log.debug("{} closed", (Object)this);
                } else {
                    this.log.debug("{} is already {}", (Object)this, (Object)(this.state.get() == State.Closed ? "closed" : "closing"));
                }
            } else if (this.state.compareAndSet(State.Opened, State.Graceful)) {
                this.log.debug("Closing {} gracefully", (Object)this);
                this.preClose();
                CloseFuture grace = this.doCloseGracefully();
                if (grace != null) {
                    grace.addListener(new SshFutureListener<CloseFuture>(){

                        @Override
                        public void operationComplete(CloseFuture future) {
                            if (AbstractCloseable.this.state.compareAndSet(State.Graceful, State.Immediate)) {
                                AbstractCloseable.this.doCloseImmediately();
                                AbstractCloseable.this.log.debug("{} closed", (Object)AbstractCloseable.this);
                            }
                        }
                    });
                } else if (this.state.compareAndSet(State.Graceful, State.Immediate)) {
                    this.doCloseImmediately();
                    this.log.debug("{} closed", (Object)this);
                }
            } else {
                this.log.debug("{} is already {}", (Object)this, (Object)(this.state.get() == State.Closed ? "closed" : "closing"));
            }
            return this.closeFuture;
        }

        @Override
        public boolean isClosed() {
            return this.state.get() == State.Closed;
        }

        @Override
        public boolean isClosing() {
            return this.state.get() != State.Opened;
        }

        protected void preClose() {
        }

        protected CloseFuture doCloseGracefully() {
            return null;
        }

        protected void doCloseImmediately() {
            this.closeFuture.setClosed();
            this.state.set(State.Closed);
        }

        protected Builder builder() {
            return new Builder(this.lock);
        }

        protected static enum State {
            Opened,
            Graceful,
            Immediate,
            Closed;

        }
    }

    private static class FuturesCloseable<T extends SshFuture>
    extends SimpleCloseable {
        private final Iterable<? extends SshFuture<T>> futures;

        public FuturesCloseable(Object lock, Iterable<? extends SshFuture<T>> futures) {
            super(lock);
            this.futures = futures;
        }

        @Override
        protected void doClose(boolean immediately) {
            if (immediately) {
                for (SshFuture<T> f : this.futures) {
                    if (!(f instanceof DefaultSshFuture)) continue;
                    ((DefaultSshFuture)f).setValue(new SshException("Closed"));
                }
                this.future.setClosed();
            } else {
                final AtomicInteger count = new AtomicInteger(1);
                SshFutureListener listener = new SshFutureListener<T>(){

                    @Override
                    public void operationComplete(T f) {
                        if (count.decrementAndGet() == 0) {
                            FuturesCloseable.this.future.setClosed();
                        }
                    }
                };
                for (SshFuture<T> f : this.futures) {
                    if (f == null) continue;
                    count.incrementAndGet();
                    f.addListener(listener);
                }
                listener.operationComplete(null);
            }
        }
    }

    private static class SequentialCloseable
    extends SimpleCloseable {
        private final Iterable<? extends Closeable> closeables;

        public SequentialCloseable(Object lock, Iterable<? extends Closeable> closeables) {
            super(lock);
            this.closeables = closeables;
        }

        @Override
        protected void doClose(final boolean immediately) {
            final Iterator<? extends Closeable> iterator = this.closeables.iterator();
            SshFutureListener<CloseFuture> listener = new SshFutureListener<CloseFuture>(){

                @Override
                public void operationComplete(CloseFuture previousFuture) {
                    while (iterator.hasNext()) {
                        Closeable c = (Closeable)iterator.next();
                        if (c == null) continue;
                        CloseFuture nextFuture = c.close(immediately);
                        nextFuture.addListener(this);
                        return;
                    }
                    if (!iterator.hasNext()) {
                        SequentialCloseable.this.future.setClosed();
                    }
                }
            };
            listener.operationComplete(null);
        }
    }

    private static class ParallelCloseable
    extends SimpleCloseable {
        final Iterable<? extends Closeable> closeables;

        private ParallelCloseable(Object lock, Iterable<? extends Closeable> closeables) {
            super(lock);
            this.closeables = closeables;
        }

        @Override
        protected void doClose(boolean immediately) {
            final AtomicInteger count = new AtomicInteger(1);
            SshFutureListener<CloseFuture> listener = new SshFutureListener<CloseFuture>(){

                @Override
                public void operationComplete(CloseFuture f) {
                    if (count.decrementAndGet() == 0) {
                        ParallelCloseable.this.future.setClosed();
                    }
                }
            };
            for (Closeable closeable : this.closeables) {
                if (closeable == null) continue;
                count.incrementAndGet();
                closeable.close(immediately).addListener(listener);
            }
            listener.operationComplete(null);
        }
    }

    private static class SimpleCloseable
    implements Closeable {
        protected final DefaultCloseFuture future;
        protected final AtomicBoolean closing;

        public SimpleCloseable(Object lock) {
            this.future = new DefaultCloseFuture(lock);
            this.closing = new AtomicBoolean();
        }

        @Override
        public boolean isClosed() {
            return this.future.isClosed();
        }

        @Override
        public boolean isClosing() {
            return this.closing.get();
        }

        @Override
        public CloseFuture close(boolean immediately) {
            if (this.closing.compareAndSet(false, true)) {
                this.doClose(immediately);
            }
            return this.future;
        }

        protected void doClose(boolean immediately) {
            this.future.setClosed();
        }
    }

    public static class Builder {
        private final Object lock;
        private final List<Closeable> closeables = new ArrayList<Closeable>();

        private Builder(Object lock) {
            this.lock = lock;
        }

        public Builder run(final Runnable r) {
            return this.close(new SimpleCloseable(this.lock){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void doClose(boolean immediately) {
                    try {
                        r.run();
                    }
                    finally {
                        super.doClose(immediately);
                    }
                }
            });
        }

        public <T extends SshFuture> Builder when(SshFuture<T> future) {
            if (future != null) {
                this.when(Collections.singleton(future));
            }
            return this;
        }

        public <T extends SshFuture> Builder when(SshFuture<T> ... futures) {
            return this.when(Arrays.asList(futures));
        }

        public <T extends SshFuture> Builder when(Iterable<? extends SshFuture<T>> futures) {
            return this.close(new FuturesCloseable(this.lock, futures));
        }

        public Builder sequential(Closeable ... closeables) {
            for (Closeable closeable : closeables) {
                this.close(closeable);
            }
            return this;
        }

        public Builder sequential(Iterable<Closeable> closeables) {
            return this.close(new SequentialCloseable(this.lock, closeables));
        }

        public Builder parallel(Closeable ... closeables) {
            if (closeables.length == 1) {
                this.close(closeables[0]);
            } else if (closeables.length > 0) {
                this.parallel(Arrays.asList(closeables));
            }
            return this;
        }

        public Builder parallel(Iterable<? extends Closeable> closeables) {
            return this.close(new ParallelCloseable(this.lock, closeables));
        }

        public Builder close(Closeable c) {
            if (c != null) {
                this.closeables.add(c);
            }
            return this;
        }

        public Closeable build() {
            if (this.closeables.isEmpty()) {
                return new SimpleCloseable(this.lock);
            }
            if (this.closeables.size() == 1) {
                return this.closeables.get(0);
            }
            return new SequentialCloseable(this.lock, this.closeables);
        }
    }
}

