/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.sshd.common.util.BufferUtils;
import org.slf4j.Logger;

public class LoggingFilterOutputStream
extends FilterOutputStream {
    private final String msg;
    private final Logger log;

    public LoggingFilterOutputStream(OutputStream out, String msg, Logger log) {
        super(out);
        this.msg = msg;
        this.log = log;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] d = new byte[]{(byte)b};
        this.write(d, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.log != null && this.log.isTraceEnabled()) {
            this.log.trace("{} {}", (Object)this.msg, (Object)BufferUtils.printHex(b, off, len));
        }
        this.out.write(b, off, len);
    }
}

