/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth;

import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SessionListener;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class CachingPublicKeyAuthenticator
implements PublickeyAuthenticator,
SessionListener {
    protected final PublickeyAuthenticator authenticator;
    protected final Map<ServerSession, Map<PublicKey, Boolean>> cache = new ConcurrentHashMap<ServerSession, Map<PublicKey, Boolean>>();

    public CachingPublicKeyAuthenticator(PublickeyAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        Map<PublicKey, Boolean> map = this.cache.get(session);
        if (map == null) {
            map = new HashMap<PublicKey, Boolean>();
            this.cache.put(session, map);
            session.addListener(this);
        }
        if (map.containsKey(key)) {
            return map.get(key);
        }
        boolean result = this.authenticator.authenticate(username, key, session);
        map.put(key, result);
        return result;
    }

    @Override
    public void sessionCreated(Session session) {
    }

    @Override
    public void sessionEvent(Session session, SessionListener.Event event) {
    }

    @Override
    public void sessionClosed(Session session) {
        this.cache.remove(session);
    }
}

