/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth;

import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.UserAuth;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthPassword
extends AbstractUserAuth {
    @Override
    public Boolean doAuth(Buffer buffer, boolean init) throws Exception {
        if (!init) {
            throw new IllegalStateException();
        }
        boolean newPassword = buffer.getBoolean();
        if (newPassword) {
            throw new IllegalStateException("Password changes are not supported");
        }
        String password = buffer.getString();
        return this.checkPassword(this.session, this.username, password);
    }

    private boolean checkPassword(ServerSession session, String username, String password) throws Exception {
        PasswordAuthenticator auth = session.getFactoryManager().getPasswordAuthenticator();
        if (auth != null) {
            return auth.authenticate(username, password, session);
        }
        throw new Exception("No PasswordAuthenticator configured");
    }

    public static class Factory
    implements NamedFactory<UserAuth> {
        @Override
        public String getName() {
            return "password";
        }

        @Override
        public UserAuth create() {
            return new UserAuthPassword();
        }
    }
}

