/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth;

import java.security.PublicKey;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Signature;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.UserAuth;
import org.apache.sshd.server.auth.AbstractUserAuth;

public class UserAuthPublicKey
extends AbstractUserAuth {
    @Override
    public Boolean doAuth(Buffer buffer, boolean init) throws Exception {
        if (!init) {
            throw new IllegalStateException();
        }
        boolean hasSig = buffer.getBoolean();
        String alg = buffer.getString();
        int oldLim = buffer.wpos();
        int oldPos = buffer.rpos();
        int len = buffer.getInt();
        buffer.wpos(buffer.rpos() + len);
        PublicKey key = buffer.getRawPublicKey();
        Signature verif = (Signature)NamedFactory.Utils.create(this.session.getFactoryManager().getSignatureFactories(), alg);
        if (verif == null) {
            throw new Exception("No Signature available for: " + alg);
        }
        verif.init(key, null);
        buffer.wpos(oldLim);
        byte[] sig = hasSig ? buffer.getBytes() : null;
        PublickeyAuthenticator authenticator = this.session.getFactoryManager().getPublickeyAuthenticator();
        if (authenticator == null) {
            throw new Exception("No PublickeyAuthenticator configured");
        }
        if (!authenticator.authenticate(this.username, key, this.session)) {
            return false;
        }
        if (!hasSig) {
            Buffer buf = this.session.createBuffer((byte)60);
            buf.putString(alg);
            buf.putRawBytes(buffer.array(), oldPos, 4 + len);
            this.session.writePacket(buf);
            return null;
        }
        Buffer buf = new Buffer();
        buf.putString(this.session.getKex().getH());
        buf.putByte((byte)50);
        buf.putString(this.username);
        buf.putString(this.service);
        buf.putString("publickey");
        buf.putByte((byte)1);
        buf.putString(alg);
        buffer.rpos(oldPos);
        buffer.wpos(oldPos + 4 + len);
        buf.putBuffer(buffer);
        verif.update(buf.array(), buf.rpos(), buf.available());
        if (!verif.verify(sig)) {
            throw new Exception("Key verification failed");
        }
        return true;
    }

    public static class Factory
    implements NamedFactory<UserAuth> {
        @Override
        public String getName() {
            return "publickey";
        }

        @Override
        public UserAuth create() {
            return new UserAuthPublicKey();
        }
    }
}

