/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.ForwardingFilter;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PtyMode;
import org.apache.sshd.common.RequestHandler;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.IoUtils;
import org.apache.sshd.common.util.LoggingFilterOutputStream;
import org.apache.sshd.server.AsyncCommand;
import org.apache.sshd.server.ChannelSessionAware;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.Signal;
import org.apache.sshd.server.SignalListener;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.sshd.server.channel.AsyncDataReceiver;
import org.apache.sshd.server.channel.ChannelDataReceiver;
import org.apache.sshd.server.channel.PipeDataReceiver;
import org.apache.sshd.server.channel.PuttyRequestHandler;
import org.apache.sshd.server.session.ServerSession;

public class ChannelSession
extends AbstractServerChannel {
    public static final long DEFAULT_COMMAND_EXIT_TIMEOUT = 5000L;
    protected String type;
    protected ChannelAsyncOutputStream asyncOut;
    protected ChannelAsyncOutputStream asyncErr;
    protected OutputStream out;
    protected OutputStream err;
    protected Command command;
    protected ChannelDataReceiver receiver;
    protected StandardEnvironment env = new StandardEnvironment();
    protected Buffer tempBuffer;
    protected final CloseFuture commandExitFuture = new DefaultCloseFuture(this.lock);

    public ChannelSession() {
        this.addRequestHandler(new ChannelSessionRequestHandler());
        this.addRequestHandler(new PuttyRequestHandler());
    }

    @Override
    public void handleWindowAdjust(Buffer buffer) throws IOException {
        super.handleWindowAdjust(buffer);
        if (this.asyncOut != null) {
            this.asyncOut.onWindowExpanded();
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().sequential(new CommandCloseable(), new AbstractChannel.GracefulChannelCloseable()).parallel(this.asyncOut, this.asyncErr).build();
    }

    @Override
    protected void doCloseImmediately() {
        if (this.command != null) {
            this.command.destroy();
            this.command = null;
        }
        this.remoteWindow.notifyClosed();
        IoUtils.closeQuietly(this.out, this.err, this.receiver);
        super.doCloseImmediately();
    }

    @Override
    public void handleEof() throws IOException {
        super.handleEof();
        IoUtils.closeQuietly(this.receiver);
    }

    @Override
    protected void doWriteData(byte[] data, int off, int len) throws IOException {
        if (this.isClosing()) {
            return;
        }
        if (this.receiver != null) {
            int r = this.receiver.data(this, data, off, len);
            if (r > 0) {
                this.localWindow.consumeAndCheck(r);
            }
        } else {
            if (this.tempBuffer == null) {
                this.tempBuffer = new Buffer(len);
            }
            this.tempBuffer.putRawBytes(data, off, len);
        }
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, int len) throws IOException {
        throw new UnsupportedOperationException("Server channel does not support extended data");
    }

    public Boolean handleRequest(String type, Buffer buffer) throws IOException {
        if ("env".equals(type)) {
            return this.handleEnv(buffer);
        }
        if ("pty-req".equals(type)) {
            return this.handlePtyReq(buffer);
        }
        if ("window-change".equals(type)) {
            return this.handleWindowChange(buffer);
        }
        if ("signal".equals(type)) {
            return this.handleSignal(buffer);
        }
        if ("break".equals(type)) {
            return this.handleBreak(buffer);
        }
        if ("shell".equals(type)) {
            if (this.type == null && this.handleShell(buffer)) {
                this.type = type;
                return true;
            }
            return false;
        }
        if ("exec".equals(type)) {
            if (this.type == null && this.handleExec(buffer)) {
                this.type = type;
                return true;
            }
            return false;
        }
        if ("subsystem".equals(type)) {
            if (this.type == null && this.handleSubsystem(buffer)) {
                this.type = type;
                return true;
            }
            return false;
        }
        if ("auth-agent-req@openssh.com".equals(type)) {
            return this.handleAgentForwarding(buffer);
        }
        if ("x11-req".equals(type)) {
            return this.handleX11Forwarding(buffer);
        }
        return null;
    }

    protected boolean handleEnv(Buffer buffer) throws IOException {
        String name = buffer.getString();
        String value = buffer.getString();
        this.addEnvVariable(name, value);
        this.log.debug("env for channel {}: {} = {}", new Object[]{this.id, name, value});
        return true;
    }

    protected boolean handlePtyReq(Buffer buffer) throws IOException {
        String term = buffer.getString();
        int tColumns = buffer.getInt();
        int tRows = buffer.getInt();
        int tWidth = buffer.getInt();
        int tHeight = buffer.getInt();
        byte[] modes = buffer.getBytes();
        StandardEnvironment environment = this.getEnvironment();
        Map<PtyMode, Integer> ptyModes = environment.getPtyModes();
        int i = 0;
        while (i < modes.length && modes[i] != 0) {
            int opcode;
            PtyMode mode;
            if ((mode = PtyMode.fromInt(opcode = modes[i++] & 0xFF)) == null) {
                this.log.warn("Unknown pty opcode value: " + opcode);
                break;
            }
            int val = modes[i++] << 24 & 0xFF000000 | modes[i++] << 16 & 0xFF0000 | modes[i++] << 8 & 0xFF00 | modes[i++] & 0xFF;
            ptyModes.put(mode, val);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("pty for channel {}: term={}, size=({} - {}), pixels=({}, {}), modes=[{}]", new Object[]{this.id, term, tColumns, tRows, tWidth, tHeight, ptyModes});
        }
        this.addEnvVariable("TERM", term);
        this.addEnvVariable("COLUMNS", Integer.toString(tColumns));
        this.addEnvVariable("LINES", Integer.toString(tRows));
        return true;
    }

    protected boolean handleWindowChange(Buffer buffer) throws IOException {
        int tColumns = buffer.getInt();
        int tRows = buffer.getInt();
        int tWidth = buffer.getInt();
        int tHeight = buffer.getInt();
        this.log.debug("window-change for channel {}: ({} - {}), ({}, {})", new Object[]{this.id, tColumns, tRows, tWidth, tHeight});
        StandardEnvironment e = this.getEnvironment();
        e.set("COLUMNS", Integer.toString(tColumns));
        e.set("LINES", Integer.toString(tRows));
        e.signal(Signal.WINCH);
        return true;
    }

    protected boolean handleSignal(Buffer buffer) throws IOException {
        String name = buffer.getString();
        this.log.debug("Signal received on channel {}: {}", (Object)this.id, (Object)name);
        Signal signal = Signal.get(name);
        if (signal != null) {
            this.getEnvironment().signal(signal);
        } else {
            this.log.warn("Unknown signal received: " + name);
        }
        return true;
    }

    protected boolean handleBreak(Buffer buffer) throws IOException {
        String name = buffer.getString();
        this.log.debug("Break received on channel {}: {}", (Object)this.id, (Object)name);
        this.getEnvironment().signal(Signal.INT);
        return true;
    }

    protected boolean handleShell(Buffer buffer) throws IOException {
        if (this.isClosing()) {
            return false;
        }
        if (((ServerSession)this.session).getFactoryManager().getShellFactory() == null) {
            return false;
        }
        this.command = ((ServerSession)this.session).getFactoryManager().getShellFactory().create();
        this.prepareCommand();
        this.command.start(this.getEnvironment());
        return true;
    }

    protected boolean handleExec(Buffer buffer) throws IOException {
        if (this.isClosing()) {
            return false;
        }
        String commandLine = buffer.getString();
        if (((ServerSession)this.session).getFactoryManager().getCommandFactory() == null) {
            this.log.warn("Unsupported command: {}", (Object)commandLine);
            return false;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Executing command: {}", (Object)commandLine);
        }
        try {
            this.command = ((ServerSession)this.session).getFactoryManager().getCommandFactory().createCommand(commandLine);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        this.prepareCommand();
        this.command.start(this.getEnvironment());
        return true;
    }

    protected boolean handleSubsystem(Buffer buffer) throws IOException {
        String subsystem = buffer.getString();
        List factories = ((ServerSession)this.session).getFactoryManager().getSubsystemFactories();
        if (factories == null) {
            this.log.warn("Unsupported subsystem: {}", (Object)subsystem);
            return false;
        }
        this.command = (Command)NamedFactory.Utils.create(factories, subsystem);
        if (this.command == null) {
            this.log.warn("Unsupported subsystem: {}", (Object)subsystem);
            return false;
        }
        this.prepareCommand();
        this.command.start(this.getEnvironment());
        return true;
    }

    public void setDataReceiver(ChannelDataReceiver receiver) {
        this.receiver = receiver;
    }

    protected void prepareCommand() throws IOException {
        this.addEnvVariable("USER", this.session.getUsername());
        if (this.command instanceof SessionAware) {
            ((SessionAware)((Object)this.command)).setSession((ServerSession)this.session);
        }
        if (this.command instanceof ChannelSessionAware) {
            ((ChannelSessionAware)((Object)this.command)).setChannelSession(this);
        }
        if (this.command instanceof FileSystemAware) {
            FileSystemFactory factory = ((ServerSession)this.session).getFactoryManager().getFileSystemFactory();
            ((FileSystemAware)((Object)this.command)).setFileSystemView(factory.createFileSystemView(this.session));
        }
        if (this.command instanceof AsyncCommand) {
            this.asyncOut = new ChannelAsyncOutputStream(this, 94);
            this.asyncErr = new ChannelAsyncOutputStream(this, 95);
            ((AsyncCommand)this.command).setIoOutputStream(this.asyncOut);
            ((AsyncCommand)this.command).setIoErrorStream(this.asyncErr);
        } else {
            this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, 94);
            this.err = new ChannelOutputStream(this, this.remoteWindow, this.log, 95);
            if (this.log.isTraceEnabled()) {
                this.out = new LoggingFilterOutputStream(this.out, "OUT:", this.log);
                this.err = new LoggingFilterOutputStream(this.err, "ERR:", this.log);
            }
            this.command.setOutputStream(this.out);
            this.command.setErrorStream(this.err);
        }
        if (this.receiver == null) {
            ChannelDataReceiver recv;
            if (this.command instanceof AsyncCommand) {
                recv = new AsyncDataReceiver(this);
                this.setDataReceiver(recv);
                ((AsyncCommand)this.command).setIoInputStream(((AsyncDataReceiver)recv).getIn());
            } else {
                recv = new PipeDataReceiver(this.localWindow);
                this.setDataReceiver(recv);
                this.command.setInputStream(((PipeDataReceiver)recv).getIn());
            }
        }
        if (this.tempBuffer != null) {
            Buffer buffer = this.tempBuffer;
            this.tempBuffer = null;
            this.doWriteData(buffer.array(), buffer.rpos(), buffer.available());
        }
        this.command.setExitCallback(new ExitCallback(){

            @Override
            public void onExit(int exitValue) {
                try {
                    ChannelSession.this.closeShell(exitValue);
                }
                catch (IOException e) {
                    ChannelSession.this.log.info("Error closing shell", (Throwable)e);
                }
            }

            @Override
            public void onExit(int exitValue, String exitMessage) {
                this.onExit(exitValue);
            }
        });
    }

    protected int getPtyModeValue(PtyMode mode) {
        Integer v = this.getEnvironment().getPtyModes().get((Object)mode);
        return v != null ? v : 0;
    }

    protected boolean handleAgentForwarding(Buffer buffer) throws IOException {
        ServerSession server = (ServerSession)this.session;
        ForwardingFilter filter = server.getFactoryManager().getTcpipForwardingFilter();
        SshAgentFactory factory = server.getFactoryManager().getAgentFactory();
        if (factory == null || filter != null && !filter.canForwardAgent(server)) {
            return false;
        }
        String authSocket = this.service.initAgentForward();
        this.addEnvVariable("SSH_AUTH_SOCK", authSocket);
        return true;
    }

    protected boolean handleX11Forwarding(Buffer buffer) throws IOException {
        ServerSession server = (ServerSession)this.session;
        ForwardingFilter filter = server.getFactoryManager().getTcpipForwardingFilter();
        if (filter == null || !filter.canForwardX11(server)) {
            return false;
        }
        String display = this.service.createX11Display(buffer.getBoolean(), buffer.getString(), buffer.getString(), buffer.getInt());
        if (display == null) {
            return false;
        }
        this.addEnvVariable("DISPLAY", display);
        return true;
    }

    protected void addEnvVariable(String name, String value) {
        this.getEnvironment().set(name, value);
    }

    protected StandardEnvironment getEnvironment() {
        return this.env;
    }

    protected void closeShell(int exitValue) throws IOException {
        if (!this.isClosing()) {
            this.sendEof();
            this.sendExitStatus(exitValue);
            this.commandExitFuture.setClosed();
            this.close(false);
        } else {
            this.commandExitFuture.setClosed();
        }
    }

    private class ChannelSessionRequestHandler
    implements RequestHandler<Channel> {
        private ChannelSessionRequestHandler() {
        }

        @Override
        public RequestHandler.Result process(Channel channel, String request, boolean wantReply, Buffer buffer) throws Exception {
            Boolean r = ChannelSession.this.handleRequest(request, buffer);
            if (r == null) {
                return RequestHandler.Result.Unsupported;
            }
            return r != false ? RequestHandler.Result.ReplySuccess : RequestHandler.Result.ReplyFailure;
        }
    }

    public class CommandCloseable
    implements Closeable {
        @Override
        public boolean isClosed() {
            return ChannelSession.this.commandExitFuture.isClosed();
        }

        @Override
        public boolean isClosing() {
            return this.isClosed();
        }

        @Override
        public CloseFuture close(boolean immediately) {
            if (immediately || ChannelSession.this.command == null) {
                ChannelSession.this.commandExitFuture.setClosed();
            } else if (!ChannelSession.this.commandExitFuture.isClosed()) {
                IoUtils.closeQuietly(ChannelSession.this.receiver);
                final TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        ChannelSession.this.commandExitFuture.setClosed();
                    }
                };
                long timeout = 5000L;
                String val = ChannelSession.this.getSession().getFactoryManager().getProperties().get("command-exit-timeout");
                if (val != null) {
                    try {
                        timeout = Long.parseLong(val);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ChannelSession.this.log.debug("Wait {} ms for shell to exit cleanly", (Object)timeout);
                ChannelSession.this.getSession().getFactoryManager().getScheduledExecutorService().schedule(task, timeout, TimeUnit.MILLISECONDS);
                ChannelSession.this.commandExitFuture.addListener(new SshFutureListener<CloseFuture>(){

                    @Override
                    public void operationComplete(CloseFuture future) {
                        task.cancel();
                    }
                });
            }
            return ChannelSession.this.commandExitFuture;
        }
    }

    protected static class StandardEnvironment
    implements Environment {
        private final Map<Signal, Set<SignalListener>> listeners = new ConcurrentHashMap<Signal, Set<SignalListener>>(3);
        private final Map<String, String> env = new ConcurrentHashMap<String, String>();
        private final Map<PtyMode, Integer> ptyModes = new ConcurrentHashMap<PtyMode, Integer>();

        @Override
        public void addSignalListener(SignalListener listener, Signal ... signals) {
            if (signals == null) {
                throw new IllegalArgumentException("signals may not be null");
            }
            if (listener == null) {
                throw new IllegalArgumentException("listener may not be null");
            }
            for (Signal s : signals) {
                this.getSignalListeners(s, true).add(listener);
            }
        }

        @Override
        public void addSignalListener(SignalListener listener) {
            this.addSignalListener(listener, EnumSet.allOf(Signal.class));
        }

        @Override
        public void addSignalListener(SignalListener listener, EnumSet<Signal> signals) {
            if (signals == null) {
                throw new IllegalArgumentException("signals may not be null");
            }
            this.addSignalListener(listener, signals.toArray(new Signal[signals.size()]));
        }

        @Override
        public Map<String, String> getEnv() {
            return this.env;
        }

        @Override
        public Map<PtyMode, Integer> getPtyModes() {
            return this.ptyModes;
        }

        @Override
        public void removeSignalListener(SignalListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener may not be null");
            }
            for (Signal s : EnumSet.allOf(Signal.class)) {
                Set<SignalListener> ls = this.getSignalListeners(s, false);
                if (ls == null) continue;
                ls.remove(listener);
            }
        }

        public void signal(Signal signal) {
            Set<SignalListener> ls = this.getSignalListeners(signal, false);
            if (ls != null) {
                for (SignalListener l : ls) {
                    l.signal(signal);
                }
            }
        }

        public void set(String key, String value) {
            this.getEnv().put(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Set<SignalListener> getSignalListeners(Signal signal, boolean create) {
            Set<SignalListener> ls = this.listeners.get((Object)signal);
            if (ls == null && create) {
                Map<Signal, Set<SignalListener>> map = this.listeners;
                synchronized (map) {
                    ls = this.listeners.get((Object)signal);
                    if (ls == null) {
                        ls = new CopyOnWriteArraySet<SignalListener>();
                        this.listeners.put(signal, ls);
                    }
                }
            }
            return ls;
        }
    }

    public static class Factory
    implements NamedFactory<Channel> {
        @Override
        public String getName() {
            return "session";
        }

        @Override
        public Channel create() {
            return new ChannelSession();
        }
    }
}

