/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.command;

import java.util.concurrent.ExecutorService;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.command.ScpCommand;

public class ScpCommandFactory
implements CommandFactory {
    public static final String SCP_COMMAND_PREFIX = "scp";
    private CommandFactory delegate;
    private ExecutorService executors;
    private boolean shutdownExecutor;
    private int sendBufferSize;
    private int receiveBufferSize;

    public ScpCommandFactory() {
        this(null, null);
    }

    public ScpCommandFactory(int bufferSize) {
        this(null, null, true, bufferSize);
    }

    public ScpCommandFactory(ExecutorService executorService) {
        this(null, executorService);
    }

    public ScpCommandFactory(CommandFactory delegateFactory) {
        this(delegateFactory, null);
    }

    public ScpCommandFactory(CommandFactory delegateFactory, ExecutorService executorService) {
        this(delegateFactory, executorService, false);
    }

    public ScpCommandFactory(CommandFactory delegateFactory, ExecutorService executorService, boolean shutdownOnExit) {
        this(delegateFactory, executorService, shutdownOnExit, 8192);
    }

    public ScpCommandFactory(CommandFactory delegateFactory, ExecutorService executorService, boolean shutdownOnExit, int bufferSize) {
        this(delegateFactory, executorService, shutdownOnExit, bufferSize, bufferSize);
    }

    public ScpCommandFactory(CommandFactory delegateFactory, ExecutorService executorService, boolean shutdownOnExit, int sendSize, int receiveSize) {
        this.delegate = delegateFactory;
        this.executors = executorService;
        this.shutdownExecutor = shutdownOnExit;
        this.sendBufferSize = sendSize;
        if (this.sendBufferSize < 127) {
            throw new IllegalArgumentException("<ScpCommandFactory>() send buffer size (" + sendSize + ") below minimum required (" + 127 + ")");
        }
        this.receiveBufferSize = receiveSize;
        if (this.receiveBufferSize < 127) {
            throw new IllegalArgumentException("<ScpCommandFactory>() receive buffer size (" + sendSize + ") below minimum required (" + 127 + ")");
        }
    }

    public CommandFactory getDelegateCommandFactory() {
        return this.delegate;
    }

    public ExecutorService getExecutorService() {
        return this.executors;
    }

    public boolean isShutdownOnExit() {
        return this.shutdownExecutor;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @Override
    public Command createCommand(String command) {
        if (command.startsWith(SCP_COMMAND_PREFIX)) {
            return new ScpCommand(command, this.getExecutorService(), this.isShutdownOnExit(), this.getSendBufferSize(), this.getReceiveBufferSize());
        }
        CommandFactory factory = this.getDelegateCommandFactory();
        if (factory != null) {
            return factory.createCommand(command);
        }
        throw new IllegalArgumentException("Unknown command, does not begin with 'scp': " + command);
    }
}

