/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.UserAuth;
import org.apache.sshd.server.session.ServerSession;

public class ServerUserAuthService
extends CloseableUtils.AbstractCloseable
implements Service {
    private final ServerSession session;
    private List<NamedFactory<UserAuth>> userAuthFactories;
    private List<List<String>> authMethods;
    private String authUserName;
    private String authMethod;
    private String authService;
    private UserAuth currentAuth;
    private int maxAuthRequests = 20;
    private int nbAuthRequests;

    public ServerUserAuthService(Session s) throws SshException {
        if (!(s instanceof ServerSession)) {
            throw new IllegalStateException("Server side service used on client side");
        }
        this.session = (ServerSession)s;
        if (this.session.isAuthenticated()) {
            throw new SshException("Session already authenticated");
        }
        this.maxAuthRequests = this.session.getIntProperty("max-auth-requests", this.maxAuthRequests);
        this.userAuthFactories = new ArrayList<NamedFactory<UserAuth>>(this.getFactoryManager().getUserAuthFactories());
        this.authMethods = new ArrayList<List<String>>();
        String mths = this.getFactoryManager().getProperties().get("auth-methods");
        if (mths == null) {
            for (NamedFactory<UserAuth> namedFactory : this.getFactoryManager().getUserAuthFactories()) {
                this.authMethods.add(new ArrayList<String>(Collections.singletonList(namedFactory.getName())));
            }
        } else {
            for (String mthl : mths.split("\\s")) {
                this.authMethods.add(new ArrayList<String>(Arrays.asList(mthl.split(","))));
            }
        }
        for (List list : this.authMethods) {
            for (String m : list) {
                if (NamedFactory.Utils.get(this.userAuthFactories, m) != null) continue;
                throw new SshException("Configured method is not supported: " + m);
            }
        }
        this.log.debug("Authorized authentication methods: {}", (Object)NamedFactory.Utils.getNames(this.userAuthFactories));
    }

    @Override
    public void start() {
    }

    @Override
    public ServerSession getSession() {
        return this.session;
    }

    @Override
    public void process(byte cmd, Buffer buffer) throws Exception {
        String username;
        Boolean authed = Boolean.FALSE;
        if (cmd == 50) {
            this.log.debug("Received SSH_MSG_USERAUTH_REQUEST");
            if (this.currentAuth != null) {
                this.currentAuth.destroy();
                this.currentAuth = null;
            }
            username = buffer.getString();
            String service = buffer.getString();
            String method = buffer.getString();
            if (this.authUserName == null || this.authService == null) {
                this.authUserName = username;
                this.authService = service;
            } else if (!this.authUserName.equals(username) || !this.authService.equals(service)) {
                this.session.disconnect(2, "Change of username or service is not allowed (" + this.authUserName + ", " + this.authService + ") -> (" + username + ", " + service + ")");
                return;
            }
            this.authMethod = method;
            if (this.nbAuthRequests++ > this.maxAuthRequests) {
                this.session.disconnect(2, "Too many authentication failures");
                return;
            }
            this.log.debug("Authenticating user '{}' with service '{}' and method '{}'", new Object[]{username, service, method});
            NamedFactory factory = NamedFactory.Utils.get(this.userAuthFactories, method);
            if (factory != null) {
                this.currentAuth = (UserAuth)factory.create();
                try {
                    authed = this.currentAuth.auth(this.session, username, service, buffer);
                }
                catch (Exception e) {
                    this.log.debug("Authentication failed: {}", (Object)e.getMessage());
                }
            }
        } else {
            if (this.currentAuth == null) {
                throw new IllegalStateException();
            }
            this.log.debug("Received authentication message {}", (Object)cmd);
            buffer.rpos(buffer.rpos() - 1);
            try {
                authed = this.currentAuth.next(buffer);
            }
            catch (Exception e) {
                this.log.debug("Authentication failed: {}", (Object)e.getMessage());
            }
        }
        if (authed == null) {
            this.log.debug("Authentication not finished");
        } else if (authed.booleanValue()) {
            this.log.debug("Authentication succeeded");
            username = this.currentAuth.getUserName();
            boolean success = false;
            for (List<String> l : this.authMethods) {
                if (l.isEmpty() || !l.get(0).equals(this.authMethod)) continue;
                l.remove(0);
                success |= l.isEmpty();
            }
            if (success) {
                String welcomeBanner;
                String maxSessionCountAsString;
                if (this.getFactoryManager().getProperties() != null && (maxSessionCountAsString = this.getFactoryManager().getProperties().get("max-concurrent-sessions")) != null) {
                    int maxSessionCount = Integer.parseInt(maxSessionCountAsString);
                    int currentSessionCount = this.session.getActiveSessionCountForUser(username);
                    if (currentSessionCount >= maxSessionCount) {
                        this.session.disconnect(7, "Too many concurrent connections");
                        return;
                    }
                }
                if ((welcomeBanner = this.getFactoryManager().getProperties().get("welcome-banner")) != null) {
                    buffer = this.session.createBuffer((byte)53);
                    buffer.putString(welcomeBanner);
                    buffer.putString("en");
                    this.session.writePacket(buffer);
                }
                buffer = this.session.createBuffer((byte)52);
                this.session.writePacket(buffer);
                this.session.setUsername(username);
                this.session.setAuthenticated();
                this.session.startService(this.authService);
                this.session.resetIdleTimeout();
                this.log.info("Session {}@{} authenticated", (Object)username, (Object)this.session.getIoSession().getRemoteAddress());
            } else {
                buffer = this.session.createBuffer((byte)51);
                StringBuilder sb = new StringBuilder();
                for (List<String> l : this.authMethods) {
                    if (l.isEmpty()) continue;
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(l.get(0));
                }
                buffer.putString(sb.toString());
                buffer.putByte((byte)1);
                this.session.writePacket(buffer);
            }
            this.currentAuth.destroy();
            this.currentAuth = null;
        } else {
            this.log.debug("Authentication failed");
            buffer = this.session.createBuffer((byte)51);
            StringBuilder sb = new StringBuilder();
            for (List<String> l : this.authMethods) {
                String m;
                if (l.isEmpty() || "none".equals(m = l.get(0))) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(l.get(0));
            }
            buffer.putString(sb.toString());
            buffer.putByte((byte)0);
            this.session.writePacket(buffer);
            if (this.currentAuth != null) {
                this.currentAuth.destroy();
                this.currentAuth = null;
            }
        }
    }

    private ServerFactoryManager getFactoryManager() {
        return this.session.getFactoryManager();
    }

    public static class Factory
    implements ServiceFactory {
        @Override
        public String getName() {
            return "ssh-userauth";
        }

        @Override
        public Service create(Session session) throws IOException {
            return new ServerUserAuthService(session);
        }
    }
}

