/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.osgi.BundleSelector;
import org.apache.karaf.shell.osgi.Util;
import org.osgi.framework.Bundle;

@Command(scope="osgi", name="id", description="Gets the bundle ID.")
public class Id
extends OsgiCommandSupport {
    @Argument(index=0, name="name", description="The bundle name, name/version, or location", required=true, multiValued=false)
    String name;
    @Option(name="--force", aliases={}, description="Forces the command to execute", required=false, multiValued=false)
    boolean force;

    protected Object doExecute() throws Exception {
        return this.doExecute(true);
    }

    protected Object doExecute(boolean force) throws Exception {
        BundleSelector selector = new BundleSelector(this.bundleContext, this.session);
        Bundle bundle = selector.getBundle(this.name, force);
        if (bundle == null) {
            for (int i = 0; i < this.bundleContext.getBundles().length; ++i) {
                Bundle b = this.bundleContext.getBundles()[i];
                if (!this.name.equals(b.getLocation())) continue;
                bundle = b;
                break;
            }
        }
        if (bundle != null) {
            if (force || !Util.isASystemBundle(this.bundleContext, bundle) || Util.accessToSystemBundleIsAllowed(bundle.getBundleId(), this.session)) {
                return bundle.getBundleId();
            }
            System.err.println("Access to system bundle " + this.name + " is discouraged. You may override with -f");
        } else {
            System.err.println("Bundle " + this.name + " is not found");
        }
        return null;
    }
}

