/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.packages.command;

import java.util.List;
import org.apache.karaf.packages.core.PackageRequirement;
import org.apache.karaf.packages.core.PackageService;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.Row;
import org.apache.karaf.shell.support.table.ShellTable;
import org.osgi.framework.Bundle;

@Command(scope="package", name="imports", description="Lists imported packages and the bundles that import them")
@Service
public class Imports
implements Action {
    @Option(name="--filter", description="Only show package instead of full filter", required=false, multiValued=false)
    boolean showFilter;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;
    @Option(name="-p", description="Only show package starting with given name", required=false, multiValued=false)
    String packageName;
    @Option(name="-b", description="Only show imports of the given bundle id", required=false, multiValued=false)
    Integer bundleId;
    @Reference
    private PackageService packageService;

    public Object execute() throws Exception {
        List<PackageRequirement> imports = this.packageService.getImports();
        ShellTable table = new ShellTable();
        if (this.showFilter) {
            table.column("Filter");
        } else {
            table.column("Package");
            table.column("Version");
        }
        table.column("Optional");
        table.column("ID");
        table.column("Bundle Name");
        for (PackageRequirement req : imports) {
            if (!this.matchesFilter(req)) continue;
            Bundle bundle = req.getBundle();
            Row row = table.addRow();
            if (this.showFilter) {
                row.addContent(new Object[]{req.getFilter()});
            } else {
                row.addContent(new Object[]{req.getPackageName(), req.getVersionRange()});
            }
            row.addContent(new Object[]{this.getOptional(req), bundle.getBundleId(), bundle.getSymbolicName()});
        }
        table.print(System.out, !this.noFormat);
        return null;
    }

    private boolean matchesFilter(PackageRequirement req) {
        return !(this.packageName != null && !req.getPackageName().startsWith(this.packageName) || this.bundleId != null && req.getBundle().getBundleId() != (long)this.bundleId.intValue());
    }

    private String getOptional(PackageRequirement req) {
        if (!req.isOptional()) {
            return "";
        }
        return req.isResolveable() ? "resolved" : "unresolved";
    }
}

