/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.karaf.features.ConfigFileInfo;
import org.apache.karaf.features.ConfigInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.internal.service.FeaturesServiceImpl;
import org.apache.karaf.util.StreamUtils;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureConfigInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesServiceImpl.class);
    private static final String CONFIG_KEY = "org.apache.karaf.features.configKey";
    private final ConfigurationAdmin configAdmin;

    public FeatureConfigInstaller(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    private String[] parsePid(String pid) {
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    private Configuration createConfiguration(ConfigurationAdmin configurationAdmin, String pid, String factoryPid) throws IOException, InvalidSyntaxException {
        if (factoryPid != null) {
            return configurationAdmin.createFactoryConfiguration(pid, null);
        }
        return configurationAdmin.getConfiguration(pid, null);
    }

    private Configuration findExistingConfiguration(ConfigurationAdmin configurationAdmin, String pid, String factoryPid) throws IOException, InvalidSyntaxException {
        String filter;
        if (factoryPid == null) {
            filter = "(service.pid=" + pid + ")";
        } else {
            String key = this.createConfigurationKey(pid, factoryPid);
            filter = "(org.apache.karaf.features.configKey=" + key + ")";
        }
        Configuration[] configurations = configurationAdmin.listConfigurations(filter);
        if (configurations != null && configurations.length > 0) {
            return configurations[0];
        }
        return null;
    }

    public void installFeatureConfigs(Feature feature) throws IOException, InvalidSyntaxException {
        for (ConfigInfo config : feature.getConfigurations()) {
            Properties props = config.getProperties();
            String[] pid = this.parsePid(config.getName());
            Configuration cfg = this.findExistingConfiguration(this.configAdmin, pid[0], pid[1]);
            if (cfg == null) {
                Dictionary<String, String> cfgProps = this.convertToDict(props);
                cfg = this.createConfiguration(this.configAdmin, pid[0], pid[1]);
                String key = this.createConfigurationKey(pid[0], pid[1]);
                cfgProps.put(CONFIG_KEY, key);
                cfg.update(cfgProps);
                continue;
            }
            if (!config.isAppend()) continue;
            boolean update = false;
            Dictionary properties = cfg.getProperties();
            for (String key : props.stringPropertyNames()) {
                if (properties.get(key) != null) continue;
                properties.put(key, props.getProperty(key));
                update = true;
            }
            if (!update) continue;
            cfg.update(properties);
        }
        for (ConfigFileInfo configFile : feature.getConfigurationFiles()) {
            this.installConfigurationFile(configFile.getLocation(), configFile.getFinalname(), configFile.isOverride());
        }
    }

    private Dictionary<String, String> convertToDict(Properties props) {
        Hashtable<String, String> cfgProps = new Hashtable<String, String>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = props.getProperty(key);
            ((Dictionary)cfgProps).put(key, val);
        }
        return cfgProps;
    }

    private String createConfigurationKey(String pid, String factoryPid) {
        return factoryPid == null ? pid : pid + "-" + factoryPid;
    }

    private void installConfigurationFile(String fileLocation, String finalname, boolean override) throws IOException {
        File file;
        String basePath = System.getProperty("karaf.base");
        if (finalname.contains("${")) {
            int marker = finalname.indexOf("}");
            finalname = finalname.substring(marker + 1);
        }
        if ((file = new File(finalname = basePath + File.separator + finalname)).exists()) {
            if (!override) {
                LOGGER.debug("Configuration file {} already exist, don't override it", (Object)finalname);
                return;
            }
            LOGGER.info("Configuration file {} already exist, overriding it", (Object)finalname);
        } else {
            LOGGER.info("Creating configuration file {}", (Object)finalname);
        }
        try (BufferedInputStream is = new BufferedInputStream(new URL(fileLocation).openStream());){
            if (!file.exists()) {
                File parentFile = file.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                file.createNewFile();
            }
            try (FileOutputStream fop = new FileOutputStream(file);){
                StreamUtils.copy(is, fop);
            }
        }
        catch (RuntimeException | MalformedURLException e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
    }
}

