/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.metatype.internal;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.metatype.MetaData;
import org.apache.felix.metatype.MetaDataReader;
import org.apache.felix.metatype.internal.Activator;
import org.apache.felix.metatype.internal.ManagedServiceHolder;
import org.apache.felix.metatype.internal.ManagedServiceTracker;
import org.apache.felix.metatype.internal.MetaTypeInformationImpl;
import org.apache.felix.metatype.internal.MetaTypeProviderHolder;
import org.apache.felix.metatype.internal.MetaTypeProviderTracker;
import org.apache.felix.metatype.internal.ServiceMetaTypeInformation;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;

class MetaTypeServiceImpl
implements MetaTypeService,
SynchronousBundleListener {
    private final Map bundleMetaTypeInformation = new ConcurrentHashMap();
    private final ManagedServiceTracker managedServiceTracker;
    private final MetaTypeProviderTracker providerTracker;

    MetaTypeServiceImpl(BundleContext bundleContext) {
        bundleContext.addBundleListener((BundleListener)this);
        ManagedServiceTracker mst = null;
        try {
            mst = new ManagedServiceTracker(bundleContext, this);
            mst.open();
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        this.managedServiceTracker = mst;
        this.providerTracker = new MetaTypeProviderTracker(bundleContext, this);
        this.providerTracker.open();
    }

    void dispose() {
        this.providerTracker.close();
        this.managedServiceTracker.close();
        this.bundleMetaTypeInformation.clear();
    }

    public void bundleChanged(BundleEvent event) {
        MetaTypeInformationImpl mti;
        SoftReference mtir;
        if (event.getType() == 256 && (mtir = (SoftReference)this.bundleMetaTypeInformation.remove(new Long(event.getBundle().getBundleId()))) != null && (mti = (MetaTypeInformationImpl)mtir.get()) != null) {
            mti.dispose();
        }
    }

    public MetaTypeInformation getMetaTypeInformation(Bundle bundle) {
        if (bundle.getHeaders().get("Fragment-Host") != null) {
            return null;
        }
        MetaTypeInformationImpl mti = this.getMetaTypeInformationInternal(bundle);
        if (mti == null) {
            mti = this.fromDocuments(bundle);
            if (mti == null) {
                mti = new ServiceMetaTypeInformation(bundle);
            }
            MetaTypeInformationImpl impl = null;
            if (bundle.getState() == 32 || bundle.getState() == 8) {
                this.putMetaTypeInformationInternal(bundle, mti);
            } else {
                impl = mti;
                mti = null;
            }
            if (impl != null) {
                impl.dispose();
            }
        }
        return mti;
    }

    private MetaTypeInformationImpl fromDocuments(Bundle bundle) {
        MetaDataReader reader = new MetaDataReader();
        Enumeration docs = bundle.findEntries("OSGI-INF/metatype", "*.xml", false);
        if (docs == null || !docs.hasMoreElements()) {
            return null;
        }
        MetaTypeInformationImpl cmti = new MetaTypeInformationImpl(bundle);
        while (docs.hasMoreElements()) {
            URL doc = (URL)docs.nextElement();
            try {
                MetaData metaData = reader.parse(doc);
                if (metaData == null) continue;
                cmti.addMetaData(metaData);
            }
            catch (IOException ioe) {
                Activator.log(1, "fromDocuments: Error accessing document " + doc, ioe);
            }
        }
        return cmti;
    }

    protected void addService(MetaTypeProviderHolder holder) {
        MetaTypeInformationImpl mti = this.getMetaTypeInformationInternal(holder.getReference().getBundle());
        if (mti != null) {
            if (holder.getPids() != null) {
                mti.addSingletonMetaTypeProvider(holder.getPids(), holder.getProvider());
            }
            if (holder.getFactoryPids() != null) {
                mti.addFactoryMetaTypeProvider(holder.getFactoryPids(), holder.getProvider());
            }
        }
    }

    protected void removeService(MetaTypeProviderHolder holder) {
        MetaTypeInformationImpl mti = this.getMetaTypeInformationInternal(holder.getReference().getBundle());
        if (mti != null) {
            if (holder.getPids() != null) {
                mti.removeSingletonMetaTypeProvider(holder.getPids());
            }
            if (holder.getFactoryPids() != null) {
                mti.removeFactoryMetaTypeProvider(holder.getFactoryPids());
            }
        }
    }

    protected void addService(ManagedServiceHolder holder) {
        MetaTypeInformationImpl mti = this.getMetaTypeInformationInternal(holder.getReference().getBundle());
        if (mti != null) {
            mti.addService(holder.getPids(), holder.isSingleton(), holder.isFactory(), holder.getProvider());
        }
    }

    protected void removeService(ManagedServiceHolder holder) {
        MetaTypeInformationImpl mti = this.getMetaTypeInformationInternal(holder.getReference().getBundle());
        if (mti != null) {
            mti.removeService(holder.getPids(), holder.isSingleton(), holder.isFactory());
        }
    }

    private void putMetaTypeInformationInternal(Bundle bundle, MetaTypeInformationImpl mti) {
        ServiceReference[] refs;
        ServiceReference[] msRefs = this.managedServiceTracker.getServiceReferences();
        if (msRefs != null) {
            for (int i = 0; i < msRefs.length; ++i) {
                ServiceReference ref = msRefs[i];
                if (!bundle.equals(ref.getBundle())) continue;
                ManagedServiceHolder holder = (ManagedServiceHolder)this.managedServiceTracker.getService(ref);
                mti.addService(holder.getPids(), holder.isSingleton(), holder.isFactory(), holder.getProvider());
            }
        }
        if ((refs = this.providerTracker.getServiceReferences()) != null) {
            for (int i = 0; i < refs.length; ++i) {
                ServiceReference ref = refs[i];
                if (!bundle.equals(ref.getBundle())) continue;
                MetaTypeProviderHolder holder = (MetaTypeProviderHolder)this.providerTracker.getService(ref);
                if (holder.getPids() != null) {
                    mti.addSingletonMetaTypeProvider(holder.getPids(), holder.getProvider());
                }
                if (holder.getFactoryPids() == null) continue;
                mti.addFactoryMetaTypeProvider(holder.getFactoryPids(), holder.getProvider());
            }
        }
        this.bundleMetaTypeInformation.put(new Long(bundle.getBundleId()), new SoftReference<MetaTypeInformationImpl>(mti));
    }

    private MetaTypeInformationImpl getMetaTypeInformationInternal(Bundle bundle) {
        SoftReference mtir = (SoftReference)this.bundleMetaTypeInformation.get(new Long(bundle.getBundleId()));
        return mtir == null ? null : mtir.get();
    }
}

