/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.List;
import org.apache.karaf.main.util.ArtifactResolver;
import org.apache.karaf.util.maven.Parser;

public class SimpleMavenResolver
implements ArtifactResolver {
    private final List<File> mavenRepos;

    public SimpleMavenResolver(List<File> mavenRepos) {
        this.mavenRepos = mavenRepos;
    }

    @Override
    public URI resolve(URI artifactUri) {
        for (File bundleDir : this.mavenRepos) {
            File file = SimpleMavenResolver.findFile(bundleDir, artifactUri);
            if (file == null) continue;
            return file.toURI();
        }
        throw new RuntimeException("Could not resolve " + artifactUri);
    }

    private static File findFile(File dir, URI mvnUri) {
        try {
            String path = Parser.pathFromMaven(mvnUri.toString());
            File theFile = new File(dir, path);
            if (theFile.exists() && !theFile.isDirectory()) {
                return theFile;
            }
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

