/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.features.BootFinished;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.internal.service.FeaturesServiceImpl;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootFeaturesInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(BootFeaturesInstaller.class);
    private final FeaturesServiceImpl featuresService;
    private final BundleContext bundleContext;
    private final String repositories;
    private final String features;
    private final boolean asynchronous;

    public BootFeaturesInstaller(BundleContext bundleContext, FeaturesServiceImpl featuresService, String repositories, String features, boolean asynchronous) {
        this.bundleContext = bundleContext;
        this.featuresService = featuresService;
        this.repositories = repositories;
        this.features = features;
        this.asynchronous = asynchronous;
    }

    public void start() {
        if (this.featuresService.isBootDone()) {
            this.publishBootFinished();
            return;
        }
        if (this.asynchronous) {
            new Thread("Initial Features Provisioning"){

                @Override
                public void run() {
                    BootFeaturesInstaller.this.installBootFeatures();
                }
            }.start();
        } else {
            this.installBootFeatures();
        }
    }

    protected void installBootFeatures() {
        try {
            for (String repo : this.repositories.split(",")) {
                if ((repo = repo.trim()).isEmpty()) continue;
                try {
                    this.featuresService.addRepository(URI.create(repo));
                }
                catch (Exception e) {
                    LOGGER.error("Error installing boot feature repository " + repo, (Throwable)e);
                }
            }
            List<Set<String>> stagedFeatures = this.parseBootFeatures(this.features);
            for (Set<String> features : stagedFeatures) {
                this.featuresService.installFeatures(features, EnumSet.of(FeaturesService.Option.NoFailOnFeatureNotFound));
            }
            this.featuresService.bootDone();
            this.publishBootFinished();
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException) {
                try {
                    this.bundleContext.getBundle();
                }
                catch (IllegalStateException ies) {
                    return;
                }
            }
            LOGGER.error("Error installing boot features", (Throwable)e);
        }
    }

    protected List<Set<String>> parseBootFeatures(String bootFeatures) {
        Pattern pattern = Pattern.compile("(\\s*\\(([^)]+))\\s*\\)\\s*,\\s*|.+");
        Matcher matcher = pattern.matcher(bootFeatures);
        ArrayList<Set<String>> result = new ArrayList<Set<String>>();
        while (matcher.find()) {
            String group = matcher.group(2) != null ? matcher.group(2) : matcher.group();
            result.add(this.parseFeatureList(group));
        }
        return result;
    }

    protected Set<String> parseFeatureList(String group) {
        HashSet<String> features = new HashSet<String>();
        for (String feature : Arrays.asList(group.trim().split("\\s*,\\s*"))) {
            if (feature.length() <= 0) continue;
            features.add(feature);
        }
        return features;
    }

    private void publishBootFinished() {
        if (this.bundleContext != null) {
            BootFinished bootFinished = new BootFinished(){};
            this.bundleContext.registerService(BootFinished.class, (Object)bootFinished, new Hashtable());
        }
    }
}

