/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.cmdhelp;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.commands.BlueprintCommand;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.xbean.finder.ClassFinder;
import org.osgi.service.command.CommandSession;

public class CmdHelpMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File targetFolder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (!this.targetFolder.exists()) {
                this.targetFolder.mkdirs();
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            for (Object object : this.project.getCompileClasspathElements()) {
                String path = (String)object;
                urls.add(new File(path).toURI().toURL());
            }
            URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
            ClassFinder finder = new ClassFinder((ClassLoader)loader, urls);
            List classes = finder.findAnnotatedClasses(Command.class);
            if (classes.isEmpty()) {
                throw new MojoFailureException("No command found");
            }
            TreeMap<String, TreeSet<String>> commands = new TreeMap<String, TreeSet<String>>();
            for (Class clazz : classes) {
                try {
                    String help = new HelpPrinter(clazz).printHelp();
                    Command cmd = clazz.getAnnotation(Command.class);
                    File output = new File(this.targetFolder, cmd.scope() + "-" + cmd.name() + ".xml");
                    OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(output));
                    writer.write(help);
                    ((Writer)writer).close();
                    TreeSet<String> cmds = (TreeSet<String>)commands.get(cmd.scope());
                    if (cmds == null) {
                        cmds = new TreeSet<String>();
                        commands.put(cmd.scope(), cmds);
                    }
                    cmds.add(cmd.name());
                    this.getLog().info((CharSequence)("Found command: " + cmd.scope() + ":" + cmd.name()));
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)("Unable to write help for " + clazz.getName()), (Throwable)e);
                }
            }
            PrintStream writer = new PrintStream(new FileOutputStream(new File(this.targetFolder, "commands.xml")));
            writer.println("<chapter id='commands' xmlns:xi=\"http://www.w3.org/2001/XInclude\">");
            writer.println("  <title>Commands</title>");
            writer.println("  <toc></toc>");
            for (String key : commands.keySet()) {
                writer.println("  <section id='commands-" + key + "'>");
                writer.println("    <title>" + key + "</title>");
                for (String cmd : (Set)commands.get(key)) {
                    writer.println("    <xi:include href='" + key + "-" + cmd + ".xml' parse='xml'/>");
                }
                writer.println("  </section>");
            }
            writer.println("</chapter>");
            writer.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error building commands help", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HelpPrinter
    extends BlueprintCommand {
        private final Class<Action> actionClass;

        public HelpPrinter(Class<Action> actionClass) {
            this.actionClass = actionClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String printHelp() throws Exception {
            PrintStream oldout = System.out;
            try {
                Action action = this.actionClass.newInstance();
                DummyCommandSession session = new DummyCommandSession();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream newout = new PrintStream(baos);
                System.setOut(newout);
                new Preparator().prepare(action, session, Collections.singletonList("--help"));
                newout.close();
                baos.close();
                String string = baos.toString();
                return string;
            }
            finally {
                System.setOut(oldout);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class DummyCommandSession
        implements CommandSession {
            protected DummyCommandSession() {
            }

            public Object convert(Class<?> type, Object instance) {
                return null;
            }

            public CharSequence format(Object target, int level) {
                return null;
            }

            public void put(String name, Object value) {
            }

            public Object get(String name) {
                return null;
            }

            public PrintStream getConsole() {
                return null;
            }

            public InputStream getKeyboard() {
                return null;
            }

            public void close() {
            }

            public Object execute(CharSequence commandline) throws Exception {
                return null;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class Preparator
        extends BlueprintCommand.BlueprintActionPreparator {
            protected Preparator() {
                super((BlueprintCommand)HelpPrinter.this);
            }

            protected void printUsage(CommandSession session, Command command, Set<Option> options, Set<Argument> args, PrintStream out) {
                ArrayList<Argument> arguments = new ArrayList<Argument>(args);
                Collections.sort(arguments, new Comparator<Argument>(){

                    @Override
                    public int compare(Argument o1, Argument o2) {
                        return Integer.valueOf(o1.index()).compareTo(o2.index());
                    }
                });
                options = new HashSet<Option>(options);
                options.add(HELP);
                out.println("<section>");
                out.print("  <title>");
                out.print(command.scope());
                out.print(":");
                out.print(command.name());
                out.println("</title>");
                out.println("  <section>");
                out.println("    <title>Description</title>");
                out.println("    <para>");
                out.println(command.description());
                out.println("    </para>");
                out.println("  </section>");
                StringBuffer syntax = new StringBuffer();
                syntax.append(String.format("%s:%s", command.scope(), command.name()));
                if (options.size() > 0) {
                    syntax.append(" [options]");
                }
                if (arguments.size() > 0) {
                    syntax.append(' ');
                    for (Argument argument : arguments) {
                        syntax.append(String.format(argument.required() ? "%s " : "[%s] ", argument.name()));
                    }
                }
                out.println("  <section>");
                out.println("    <title>Syntax</title>");
                out.println("    <para>");
                out.println(syntax.toString());
                out.println("    </para>");
                out.println("  </section>");
                if (arguments.size() > 0) {
                    out.println("  <section>");
                    out.println("    <title>Arguments</title>");
                    out.println("    <informaltable>");
                    for (Argument argument : arguments) {
                        out.println("    <tr>");
                        out.println("      <td>" + argument.name() + "</td>");
                        out.println("      <td>" + argument.description() + "</td>");
                        out.println("    </tr>");
                    }
                    out.println("    </informaltable>");
                    out.println("  </section>");
                }
                if (options.size() > 0) {
                    out.println("  <section>");
                    out.println("    <title>Options</title>");
                    out.println("    <informaltable>");
                    for (Option option : options) {
                        String opt = option.name();
                        for (String alias : option.aliases()) {
                            opt = opt + ", " + alias;
                        }
                        out.println("    <tr>");
                        out.println("      <td>" + opt + "</td>");
                        out.println("      <td>" + option.description() + "</td>");
                        out.println("    </tr>");
                    }
                    out.println("    </informaltable>");
                    out.println("  </section>");
                }
                out.println("</section>");
            }
        }
    }
}

