/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.cmdhelp;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.commands.BlueprintCommand;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.xbean.finder.ClassFinder;

public class CmdHelpMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File targetFolder;
    protected String format;
    protected String classLoader;
    protected boolean includeHelpOption;
    private static final String FORMAT_CONF = "conf";
    private static final String FORMAT_DOCBX = "docbx";

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            PrintStream writer;
            ClassFinder finder;
            if (!FORMAT_DOCBX.equals(this.format) && !FORMAT_CONF.equals(this.format)) {
                throw new MojoFailureException("Unsupported format: " + this.format + ". Supported formats are: docbx or conf.");
            }
            if (!this.targetFolder.exists()) {
                this.targetFolder.mkdirs();
            }
            if ("project".equals(this.classLoader)) {
                ArrayList<URL> urls = new ArrayList<URL>();
                for (Object object : this.project.getCompileClasspathElements()) {
                    String path = (String)object;
                    urls.add(new File(path).toURI().toURL());
                }
                URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
                finder = new ClassFinder((ClassLoader)loader, urls);
            } else if ("plugin".equals(this.classLoader)) {
                finder = new ClassFinder(((Object)((Object)this)).getClass().getClassLoader());
            } else {
                throw new MojoFailureException("classLoader attribute must be 'project' or 'plugin'");
            }
            List classes = finder.findAnnotatedClasses(Command.class);
            if (classes.isEmpty()) {
                throw new MojoFailureException("No command found");
            }
            TreeMap<String, TreeSet<String>> commands = new TreeMap<String, TreeSet<String>>();
            for (Class clazz : classes) {
                try {
                    String help = new HelpPrinter(clazz).printHelp(this.format, this.includeHelpOption);
                    Command cmd = clazz.getAnnotation(Command.class);
                    File output = null;
                    if (cmd.scope().equals("*")) continue;
                    if (FORMAT_DOCBX.equals(this.format)) {
                        output = new File(this.targetFolder, cmd.scope() + "-" + cmd.name() + ".xml");
                    } else if (FORMAT_CONF.equals(this.format)) {
                        output = new File(this.targetFolder, cmd.scope() + "-" + cmd.name() + ".conf");
                    }
                    OutputStreamWriter writer2 = new OutputStreamWriter(new FileOutputStream(output));
                    writer2.write(help);
                    ((Writer)writer2).close();
                    TreeSet<String> cmds = (TreeSet<String>)commands.get(cmd.scope());
                    if (cmds == null) {
                        cmds = new TreeSet<String>();
                        commands.put(cmd.scope(), cmds);
                    }
                    cmds.add(cmd.name());
                    this.getLog().info((CharSequence)("Found command: " + cmd.scope() + ":" + cmd.name()));
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)("Unable to write help for " + clazz.getName()), (Throwable)e);
                }
            }
            if (FORMAT_DOCBX.equals(this.format)) {
                writer = new PrintStream(new FileOutputStream(new File(this.targetFolder, "commands.xml")));
                writer.println("<chapter id='commands' xmlns:xi=\"http://www.w3.org/2001/XInclude\">");
                writer.println("  <title>Commands</title>");
                writer.println("  <toc></toc>");
                for (String key : commands.keySet()) {
                    writer.println("  <section id='commands-" + key + "'>");
                    writer.println("    <title>" + key + "</title>");
                    for (String cmd : (Set)commands.get(key)) {
                        writer.println("    <xi:include href='" + key + "-" + cmd + ".xml' parse='xml'/>");
                    }
                    writer.println("  </section>");
                }
                writer.println("</chapter>");
                writer.close();
            } else if (FORMAT_CONF.equals(this.format)) {
                writer = new PrintStream(new FileOutputStream(new File(this.targetFolder, "commands.conf")));
                writer.println("h1. Commands");
                writer.println();
                for (String key : commands.keySet()) {
                    writer.println("h2. " + key);
                    writer.println();
                    for (String cmd : (Set)commands.get(key)) {
                        writer.println("* [" + key + ":" + cmd + "|" + key + "-" + cmd + "]");
                    }
                    writer.println();
                }
                writer.close();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error building commands help", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HelpPrinter
    extends BlueprintCommand {
        private final Class<Action> actionClass;

        public HelpPrinter(Class<Action> actionClass) {
            this.actionClass = actionClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String printHelp(String format, boolean includeHelpOption) throws Exception {
            PrintStream oldout = System.out;
            try {
                Action action = this.actionClass.newInstance();
                DummyCommandSession session = new DummyCommandSession();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream newout = new PrintStream(baos);
                System.setOut(newout);
                BlueprintCommand.BlueprintActionPreparator preparator = CmdHelpMojo.FORMAT_DOCBX.equals(format) ? new DocbxPreparator(includeHelpOption) : new ConfPreparator(includeHelpOption);
                preparator.prepare(action, (CommandSession)session, Collections.singletonList("--help"));
                newout.close();
                baos.close();
                String string = baos.toString();
                return string;
            }
            finally {
                System.setOut(oldout);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class DummyCommandSession
        implements CommandSession {
            protected DummyCommandSession() {
            }

            public Object convert(Class<?> type, Object instance) {
                return null;
            }

            public CharSequence format(Object target, int level) {
                return null;
            }

            public void put(String name, Object value) {
            }

            public Object get(String name) {
                return null;
            }

            public PrintStream getConsole() {
                return null;
            }

            public InputStream getKeyboard() {
                return null;
            }

            public void close() {
            }

            public Object execute(CharSequence commandline) throws Exception {
                return null;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class ConfPreparator
        extends BlueprintCommand.BlueprintActionPreparator {
            boolean includeHelpOption;

            ConfPreparator(boolean includeHelpOption) {
                super((BlueprintCommand)HelpPrinter.this);
                this.includeHelpOption = includeHelpOption;
            }

            protected void printUsage(CommandSession session, Action action, Map<Option, Field> optionsMap, Map<Argument, Field> argsMap, PrintStream out) {
                Command command = action.getClass().getAnnotation(Command.class);
                ArrayList<Argument> arguments = new ArrayList<Argument>(argsMap.keySet());
                Collections.sort(arguments, new Comparator<Argument>(){

                    @Override
                    public int compare(Argument o1, Argument o2) {
                        return Integer.valueOf(o1.index()).compareTo(o2.index());
                    }
                });
                HashSet<Option> options = new HashSet<Option>(optionsMap.keySet());
                if (this.includeHelpOption) {
                    options.add(HELP);
                }
                out.println("h1. " + command.scope() + ":" + command.name());
                out.println();
                out.println("h2. Description");
                out.println(command.description());
                out.println();
                StringBuffer syntax = new StringBuffer();
                syntax.append(String.format("%s:%s", command.scope(), command.name()));
                if (options.size() > 0) {
                    syntax.append(" \\[options\\]");
                }
                if (arguments.size() > 0) {
                    syntax.append(' ');
                    for (Argument argument : arguments) {
                        syntax.append(String.format(argument.required() ? "%s " : "\\[%s\\] ", argument.name()));
                    }
                }
                out.println("h2. Syntax");
                out.println(syntax.toString());
                out.println();
                if (arguments.size() > 0) {
                    out.println("h2. Arguments");
                    out.println("|| Name || Description ||");
                    for (Argument argument : arguments) {
                        String description = argument.description();
                        if (!argument.required()) {
                            try {
                                argsMap.get(argument).setAccessible(true);
                                Object o = argsMap.get(argument).get(action);
                                if (!(o == null || o instanceof Boolean && !((Boolean)o).booleanValue() || o instanceof Number && ((Number)o).doubleValue() == 0.0)) {
                                    description = description + " (defaults to " + o.toString() + ")";
                                }
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        out.println("| " + argument.name() + " | " + description + " |");
                    }
                    out.println();
                }
                if (options.size() > 0) {
                    out.println("h2. Options");
                    out.println("|| Name || Description ||");
                    for (Option option : options) {
                        String opt = option.name();
                        String desc = option.description();
                        for (String alias : option.aliases()) {
                            opt = opt + ", " + alias;
                        }
                        try {
                            optionsMap.get(option).setAccessible(true);
                            Object o = optionsMap.get(option).get(action);
                            if (!(o == null || o instanceof Boolean && !((Boolean)o).booleanValue() || o instanceof Number && ((Number)o).doubleValue() == 0.0)) {
                                desc = desc + " (defaults to " + o.toString() + ")";
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        out.println("| " + opt + " | " + desc + " |");
                    }
                    out.println();
                }
                if (command.detailedDescription().length() > 0) {
                    out.println("h2. Details");
                    String desc = this.loadDescription(action.getClass(), command.detailedDescription());
                    out.println(desc);
                }
                out.println();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class DocbxPreparator
        extends BlueprintCommand.BlueprintActionPreparator {
            boolean includeHelpOption;

            DocbxPreparator(boolean includeHelpOption) {
                super((BlueprintCommand)HelpPrinter.this);
                this.includeHelpOption = includeHelpOption;
            }

            protected void printUsage(CommandSession session, Action action, Map<Option, Field> optionsMap, Map<Argument, Field> argsMap, PrintStream out) {
                Command command = action.getClass().getAnnotation(Command.class);
                ArrayList<Argument> arguments = new ArrayList<Argument>(argsMap.keySet());
                Collections.sort(arguments, new Comparator<Argument>(){

                    @Override
                    public int compare(Argument o1, Argument o2) {
                        return Integer.valueOf(o1.index()).compareTo(o2.index());
                    }
                });
                HashSet<Option> options = new HashSet<Option>(optionsMap.keySet());
                if (this.includeHelpOption) {
                    options.add(HELP);
                }
                out.println("<section>");
                out.print("  <title>");
                out.print(command.scope());
                out.print(":");
                out.print(command.name());
                out.println("</title>");
                out.println("  <section>");
                out.println("    <title>Description</title>");
                out.println("    <para>");
                out.println(command.description());
                out.println("    </para>");
                out.println("  </section>");
                StringBuffer syntax = new StringBuffer();
                syntax.append(String.format("%s:%s", command.scope(), command.name()));
                if (options.size() > 0) {
                    syntax.append(" [options]");
                }
                if (arguments.size() > 0) {
                    syntax.append(' ');
                    for (Argument argument : arguments) {
                        syntax.append(String.format(argument.required() ? "%s " : "[%s] ", argument.name()));
                    }
                }
                out.println("  <section>");
                out.println("    <title>Syntax</title>");
                out.println("    <para>");
                out.println(syntax.toString());
                out.println("    </para>");
                out.println("  </section>");
                if (arguments.size() > 0) {
                    out.println("  <section>");
                    out.println("    <title>Arguments</title>");
                    out.println("    <informaltable>");
                    for (Argument argument : arguments) {
                        out.println("    <tr>");
                        out.println("      <td>" + argument.name() + "</td>");
                        String description = argument.description();
                        if (!argument.required()) {
                            try {
                                argsMap.get(argument).setAccessible(true);
                                Object o = argsMap.get(argument).get(action);
                                if (!(o == null || o instanceof Boolean && !((Boolean)o).booleanValue() || o instanceof Number && ((Number)o).doubleValue() == 0.0)) {
                                    description = description + " (defaults to " + o.toString() + ")";
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        out.println("     <td>" + description + "</td>");
                        out.println("    </tr>");
                    }
                    out.println("    </informaltable>");
                    out.println("  </section>");
                }
                if (options.size() > 0) {
                    out.println("  <section>");
                    out.println("    <title>Options</title>");
                    out.println("    <informaltable>");
                    for (Option option : options) {
                        String opt = option.name();
                        String description = option.description();
                        for (String alias : option.aliases()) {
                            opt = opt + ", " + alias;
                        }
                        try {
                            optionsMap.get(option).setAccessible(true);
                            Object o = optionsMap.get(option).get(action);
                            if (!(o == null || o instanceof Boolean && !((Boolean)o).booleanValue() || o instanceof Number && ((Number)o).doubleValue() == 0.0)) {
                                description = description + " (defaults to " + o.toString() + ")";
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        out.println("    <tr>");
                        out.println("      <td>" + opt + "</td>");
                        out.println("      <td>" + description + "</td>");
                        out.println("    </tr>");
                    }
                    out.println("    </informaltable>");
                    out.println("  </section>");
                }
                if (command.detailedDescription() != null && command.detailedDescription().trim().length() > 0) {
                    out.println("<section>");
                    out.println("    <title>Details</title>");
                    String description = this.loadDescription(action.getClass(), command.detailedDescription());
                    out.println("    <para>");
                    out.println(description);
                    out.println("    </para>");
                    out.println("</section>");
                }
                out.println("</section>");
            }
        }
    }
}

