/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.version.VersionRange;
import org.apache.karaf.tooling.features.ManifestUtils;
import org.apache.karaf.tooling.features.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateFeaturesXmlMojo
extends MojoSupport {
    protected static final String SEPARATOR = "/";
    private DependencyTreeBuilder dependencyTreeBuilder;
    private ArtifactCollector collector;
    private File outputFile;
    private String attachmentArtifactType = "xml";
    private String attachmentArtifactClassifier = "features";
    private String kernelVersion;
    private Map<String, VersionRange> kernelExports = new HashMap<String, VersionRange>();
    private File bundles;
    private Set<String> knownBundles = new HashSet<String>();
    private Map<String, Map<VersionRange, Artifact>> bundleExports = new HashMap<String, Map<VersionRange, Artifact>>();
    private List<String> systemExports = new LinkedList<String>();
    private Map<Artifact, Feature> features = new HashMap<Artifact, Feature>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        PrintStream out = null;
        try {
            out = new PrintStream(new FileOutputStream(this.outputFile));
            this.readSystemPackages();
            this.readKernelBundles();
            this.readBundles();
            this.discoverBundles();
            this.writeFeatures(out);
            this.projectHelper.attachArtifact(this.project, this.attachmentArtifactType, this.attachmentArtifactClassifier, this.outputFile);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Unable to create features.xml file: " + e, e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void readSystemPackages() throws IOException {
        Properties properties = new Properties();
        properties.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("config.properties"));
        this.readSystemPackages(properties, "jre-1.5");
        this.readSystemPackages(properties, "osgi");
    }

    private void readSystemPackages(Properties properties, String key) {
        String packages = (String)properties.get(key);
        for (String pkg : packages.split(";")) {
            this.systemExports.add(pkg.trim());
        }
    }

    private void readKernelBundles() throws ArtifactResolutionException, ArtifactNotFoundException, MojoExecutionException, ZipException, IOException, DependencyTreeBuilderException {
        Collection<Object> kernelArtifacts;
        if (this.kernelVersion == null) {
            this.getLog().info((CharSequence)"Step 1: Building list of provided bundle exports");
            kernelArtifacts = new HashSet();
            DependencyNode tree = this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepo, this.factory, this.artifactMetadataSource, new ArtifactFilter(){

                public boolean include(Artifact artifact) {
                    return true;
                }
            }, this.collector);
            tree.accept(new DependencyNodeVisitor(){

                public boolean endVisit(DependencyNode node) {
                    return true;
                }

                public boolean visit(DependencyNode node) {
                    Artifact artifact;
                    if (node.getState() != 2 && "provided".equals((artifact = node.getArtifact()).getScope()) && !artifact.getType().equals("pom")) {
                        kernelArtifacts.add(artifact);
                    }
                    return true;
                }
            });
        } else {
            this.getLog().info((CharSequence)"Step 1 : Building list of kernel exports");
            this.getLog().warn((CharSequence)"Use of 'kernelVersion' is deprecated -- use a dependency with scope 'provided' instead");
            Artifact kernel = this.factory.createArtifact("org.apache.karaf", "apache-karaf", this.kernelVersion, "provided", "pom");
            this.resolver.resolve(kernel, this.remoteRepos, this.localRepo);
            kernelArtifacts = this.getDependencies(kernel);
        }
        for (Artifact artifact : kernelArtifacts) {
            this.registerKernelBundle(artifact);
        }
        this.getLog().info((CharSequence)"...done!");
    }

    private void registerKernelBundle(Artifact artifact) throws ArtifactResolutionException, ArtifactNotFoundException, ZipException, IOException {
        Manifest manifest = this.getManifest(artifact);
        for (Clause clause : ManifestUtils.getExports(manifest)) {
            this.kernelExports.put(clause.getName(), ManifestUtils.getVersionRange(clause));
            this.getLog().debug((CharSequence)(" adding kernel export " + clause.getName() + " (" + ManifestUtils.getVersionRange(clause) + ")"));
        }
        this.registerBundle(artifact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBundles() throws IOException, ArtifactResolutionException, ArtifactNotFoundException {
        BufferedReader reader = null;
        try {
            if (this.bundles != null) {
                this.getLog().info((CharSequence)("Step 2 : Building a list of exports for bundles in " + this.bundles.getAbsolutePath()));
                reader = new BufferedReader(new FileReader(this.bundles));
                String line = reader.readLine();
                while (line != null) {
                    if (line.contains(SEPARATOR) && !line.startsWith("#")) {
                        String[] elements = line.split(SEPARATOR);
                        Artifact artifact = this.factory.createArtifact(elements[0], elements[1], elements[2], "provided", elements[3]);
                        this.registerBundle(artifact);
                    }
                    line = reader.readLine();
                }
            } else {
                this.getLog().info((CharSequence)"Step 2 : No Bundle file supplied for building list of exports");
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        this.getLog().info((CharSequence)"...done!");
    }

    private void discoverBundles() throws ArtifactResolutionException, ArtifactNotFoundException, ZipException, IOException {
        this.getLog().info((CharSequence)"Step 3 : Discovering bundles in Maven dependencies");
        for (Artifact dependency : this.project.getArtifacts()) {
            if (this.project.getDependencyArtifacts().contains(dependency) || dependency.getScope().equals("provided") || !this.isDiscoverableBundle(dependency)) continue;
            this.getLog().info((CharSequence)("  Discovered " + dependency));
            this.registerBundle(dependency);
        }
        this.getLog().info((CharSequence)"...done!");
    }

    private void writeFeatures(PrintStream out) throws ArtifactResolutionException, ArtifactNotFoundException, ZipException, IOException {
        this.getLog().info((CharSequence)("Step 4 : Generating " + this.outputFile.getAbsolutePath()));
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<features>");
        Set dependencies = this.project.getDependencyArtifacts();
        for (Artifact artifact : dependencies) {
            if (artifact.getScope().equals("provided") || artifact.getType().equals("pom")) continue;
            this.getLog().info((CharSequence)(" Generating feature " + artifact.getArtifactId() + " from " + artifact));
            Feature feature = this.getFeature(artifact);
            feature.write(out);
            this.registerFeature(artifact, feature);
        }
        out.println("</features>");
        this.getLog().info((CharSequence)"...done!");
    }

    private Feature getFeature(Artifact artifact) throws ArtifactResolutionException, ArtifactNotFoundException, ZipException, IOException {
        Feature feature = new Feature(artifact);
        this.addRequirements(artifact, feature);
        return feature;
    }

    private boolean isDiscoverableBundle(Artifact artifact) {
        if (this.isBundle(artifact) && !this.isFeature(artifact) && !artifact.getScope().equals("provided")) {
            for (String known : this.knownBundles) {
                String[] elements = known.split(SEPARATOR);
                if (!artifact.getGroupId().equals(elements[0]) || !artifact.getArtifactId().equals(elements[1])) continue;
                this.getLog().debug((CharSequence)String.format("  Avoid auto-discovery for %s because of existing bundle %s", GenerateFeaturesXmlMojo.toString(artifact), known));
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isBundle(Artifact artifact) {
        if (this.knownBundles.contains(GenerateFeaturesXmlMojo.toString(artifact)) || artifact.getArtifactHandler().getPackaging().equals("bundle")) {
            return true;
        }
        try {
            Manifest manifest = this.getManifest(artifact);
            if (ManifestUtils.getBsn(manifest) != null) {
                this.getLog().debug((CharSequence)String.format("MANIFEST.MF for '%s' contains Bundle-Name '%s'", artifact, ManifestUtils.getBsn(manifest)));
                return true;
            }
        }
        catch (ZipException e) {
            this.getLog().debug((CharSequence)("Unable to determine if " + artifact + " is a bundle; defaulting to false"), (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)("Unable to determine if " + artifact + " is a bundle; defaulting to false"), (Throwable)e);
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)("Unable to determine if " + artifact + " is a bundle; defaulting to false"), (Throwable)e);
        }
        return false;
    }

    private void addRequirements(Artifact artifact, Feature feature) throws ArtifactResolutionException, ArtifactNotFoundException, ZipException, IOException {
        Manifest manifest = this.getManifest(artifact);
        Collection<Clause> remaining = this.getRemainingImports(manifest);
        Object previous = null;
        for (Clause clause : remaining) {
            Object add = null;
            Map<VersionRange, Artifact> versions = this.bundleExports.get(clause.getName());
            if (versions != null) {
                for (VersionRange range : versions.keySet()) {
                    add = versions.get(range);
                    if (range.intersect(ManifestUtils.getVersionRange(clause)) == null) continue;
                    add = versions.get(range);
                }
            }
            if (add == null) {
                if (ManifestUtils.isOptional(clause)) {
                    this.getLog().debug((CharSequence)String.format("  Unable to find suitable bundle for optional dependency %s (%s)", clause.getName(), ManifestUtils.getVersionRange(clause)));
                } else {
                    this.getLog().warn((CharSequence)String.format("  Unable to find suitable bundle for dependency %s (%s) (required by %s)", clause.getName(), ManifestUtils.getVersionRange(clause), artifact.getArtifactId()));
                }
            } else if (!add.equals(previous) && feature.push((Artifact)add) && !this.isFeature((Artifact)add)) {
                this.getLog().debug((CharSequence)("  Getting requirements for " + add));
                this.addRequirements((Artifact)add, feature);
            }
            previous = add;
        }
    }

    private boolean isFeature(Artifact artifact) {
        return this.features.containsKey(artifact);
    }

    private void registerBundle(Artifact artifact) throws ArtifactResolutionException, ArtifactNotFoundException, ZipException, IOException {
        this.getLog().debug((CharSequence)("Registering bundle " + artifact));
        this.knownBundles.add(GenerateFeaturesXmlMojo.toString(artifact));
        Manifest manifest = this.getManifest(artifact);
        for (Clause clause : this.getManifestEntries(ManifestUtils.getExports(manifest))) {
            Map<VersionRange, Artifact> versions = this.bundleExports.get(clause.getName());
            if (versions == null) {
                versions = new HashMap<VersionRange, Artifact>();
            }
            versions.put(ManifestUtils.getVersionRange(clause), artifact);
            this.getLog().debug((CharSequence)String.format(" %s exported by bundle %s", clause.getName(), artifact));
            this.bundleExports.put(clause.getName(), versions);
        }
    }

    private void registerFeature(Artifact artifact, Feature feature) throws ArtifactResolutionException, ArtifactNotFoundException, ZipException, IOException {
        this.features.put(artifact, feature);
        this.registerBundle(artifact);
    }

    private Collection<Clause> getRemainingImports(Manifest manifest) {
        Collection<Clause> input = this.getManifestEntries(ManifestUtils.getImports(manifest));
        LinkedList<Clause> output = new LinkedList<Clause>(input);
        for (Clause clause : input) {
            for (Clause clause2 : this.getManifestEntries(ManifestUtils.getExports(manifest))) {
                if (!clause.getName().equals(clause2.getName())) continue;
                output.remove(clause);
            }
        }
        for (Clause clause : input) {
            for (String string : this.kernelExports.keySet()) {
                if (!clause.getName().equals(string)) continue;
                output.remove(clause);
            }
        }
        for (Clause clause : input) {
            if (!this.systemExports.contains(clause.getName())) continue;
            output.remove(clause);
        }
        return output;
    }

    private Collection<Clause> getManifestEntries(List imports) {
        if (imports == null) {
            return new LinkedList<Clause>();
        }
        return imports;
    }

    private Manifest getManifest(Artifact artifact) throws ArtifactResolutionException, ArtifactNotFoundException, ZipException, IOException {
        ZipFile file;
        File localFile = new File(this.localRepo.pathOf(artifact));
        if (localFile.exists()) {
            file = new ZipFile(localFile);
        } else {
            this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
            file = new ZipFile(artifact.getFile());
        }
        return new Manifest(file.getInputStream(file.getEntry("META-INF/MANIFEST.MF")));
    }

    private List<Artifact> getDependencies(Artifact artifact) {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        try {
            ResolutionGroup pom = this.artifactMetadataSource.retrieve(artifact, this.localRepo, this.remoteRepos);
            if (pom != null) {
                list.addAll(pom.getArtifacts());
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            this.getLog().warn((CharSequence)("Unable to retrieve metadata for " + artifact + ", not including dependencies for it"));
        }
        catch (InvalidArtifactRTException e) {
            this.getLog().warn((CharSequence)("Unable to retrieve metadata for " + artifact + ", not including dependencies for it"));
        }
        return list;
    }

    public static String toString(Artifact artifact) {
        if (artifact.getType().equals("jar")) {
            return String.format("%s/%s/%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        }
        return String.format("%s/%s/%s/%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Feature {
        private Stack<Artifact> artifacts = new Stack();
        private final Artifact artifact;

        private Feature(Artifact artifact) {
            this.artifact = artifact;
            this.artifacts.push(artifact);
        }

        public boolean push(Artifact item) {
            if (this.artifacts.contains(item)) {
                this.artifacts.remove(item);
                this.artifacts.push(item);
                return false;
            }
            if (!this.artifacts.contains(item)) {
                this.artifacts.push(item);
                return true;
            }
            return false;
        }

        public void write(PrintStream out) {
            out.println("  <feature name='" + this.artifact.getArtifactId() + "' version='" + this.artifact.getBaseVersion() + "'>");
            Stack<Artifact> resulting = new Stack<Artifact>();
            resulting.addAll(this.artifacts);
            for (Artifact next : this.artifacts) {
                if (!GenerateFeaturesXmlMojo.this.isFeature(next)) continue;
                resulting.removeAll(((Feature)GenerateFeaturesXmlMojo.this.features.get(next)).getDependencies());
            }
            while (!resulting.isEmpty()) {
                Artifact next = (Artifact)resulting.pop();
                if (GenerateFeaturesXmlMojo.this.isFeature(next)) {
                    out.println("    <feature version='" + next.getBaseVersion() + "'>" + String.format("%s</feature>", next.getArtifactId()));
                    continue;
                }
                if (next.getType().equals("jar")) {
                    out.println(String.format("    <bundle>mvn:%s/%s/%s</bundle>", next.getGroupId(), next.getArtifactId(), next.getBaseVersion()));
                    continue;
                }
                out.println(String.format("    <bundle>mvn:%s/%s/%s/%s</bundle>", next.getGroupId(), next.getArtifactId(), next.getBaseVersion(), next.getType()));
            }
            out.println("  </feature>");
        }

        public List<Artifact> getDependencies() {
            LinkedList<Artifact> dependencies = new LinkedList<Artifact>(this.artifacts);
            dependencies.remove(this.artifact);
            return dependencies;
        }
    }
}

