/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.karaf.tooling.features.CopyFileBasedDescriptor;
import org.apache.karaf.tooling.features.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddFeaturesToRepoMojo
extends MojoSupport {
    private List<String> descriptors;
    private List<String> features;
    private File repository;
    private boolean includeMvnBasedDescriptors = false;
    private List<CopyFileBasedDescriptor> copyFileBasedDescriptors;
    private boolean skipNonMavenProtocols = true;
    private boolean failOnArtifactResolutionError = true;
    private boolean addTransitiveFeatures = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            HashSet<String> bundles = new HashSet<String>();
            HashMap<String, Feature> featuresMap = new HashMap<String, Feature>();
            for (String uri : this.descriptors) {
                if (this.includeMvnBasedDescriptors) {
                    bundles.add(uri);
                }
                Repository repo = new Repository(URI.create(this.translateFromMaven(uri)));
                for (Feature f : repo.getFeatures()) {
                    featuresMap.put(f.getName(), f);
                }
            }
            if (this.features == null) {
                this.features = new ArrayList(featuresMap.keySet());
            }
            HashSet<String> featuresBundles = new HashSet<String>();
            HashSet<String> transitiveFeatures = new HashSet<String>();
            this.addFeatures(this.features, featuresBundles, transitiveFeatures, featuresMap);
            bundles.addAll(featuresBundles);
            if (this.addTransitiveFeatures) {
                for (String feature : transitiveFeatures) {
                    this.getLog().info((CharSequence)("Adding contents of transitive feature: " + feature));
                    bundles.addAll(((Feature)featuresMap.get(feature)).getBundles());
                    bundles.addAll(((Feature)featuresMap.get(feature)).getConfigFiles());
                }
            }
            ArrayList<Artifact> explicitRepoBundles = new ArrayList<Artifact>();
            this.getLog().info((CharSequence)("Base repo: " + this.localRepo.getUrl()));
            for (String bundle : bundles) {
                Artifact artifact = this.bundleToArtifact(bundle, this.skipNonMavenProtocols);
                if (artifact == null) continue;
                if (artifact.getRepository() != null) {
                    explicitRepoBundles.add(artifact);
                    continue;
                }
                this.resolveBundle(artifact, this.remoteRepos);
            }
            for (Artifact explicitBundle : explicitRepoBundles) {
                this.resolveBundle(explicitBundle, Collections.singletonList(explicitBundle.getRepository()));
            }
            if (this.copyFileBasedDescriptors != null) {
                for (CopyFileBasedDescriptor fileBasedDescritpor : this.copyFileBasedDescriptors) {
                    AddFeaturesToRepoMojo.copy(new FileInputStream(fileBasedDescritpor.getSourceFile()), this.repository, fileBasedDescritpor.getTargetFileName(), fileBasedDescritpor.getTargetDirectory(), new byte[8192]);
                }
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error populating repository", e);
        }
    }

    private void resolveBundle(Artifact bundle, List<ArtifactRepository> remoteRepos) throws IOException, MojoFailureException {
        String dir = bundle.getGroupId().replace('.', '/') + "/" + bundle.getArtifactId() + "/" + bundle.getBaseVersion() + "/";
        String name = bundle.getArtifactId() + "-" + bundle.getBaseVersion() + (bundle.getClassifier() != null ? "-" + bundle.getClassifier() : "") + "." + bundle.getType();
        try {
            this.getLog().info((CharSequence)("Copying bundle: " + bundle));
            this.resolver.resolve(bundle, remoteRepos, this.localRepo);
            AddFeaturesToRepoMojo.copy(new FileInputStream(bundle.getFile()), this.repository, name, dir, new byte[8192]);
        }
        catch (ArtifactResolutionException e) {
            if (this.failOnArtifactResolutionError) {
                throw new MojoFailureException("Can't resolve bundle " + bundle, (Throwable)e);
            }
            this.getLog().error((CharSequence)("Can't resolve bundle " + bundle), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            if (this.failOnArtifactResolutionError) {
                throw new MojoFailureException("Can't resolve bundle " + bundle, (Throwable)e);
            }
            this.getLog().error((CharSequence)("Can't resolve bundle " + bundle), (Throwable)e);
        }
    }

    private void addFeatures(List<String> features, Set<String> featuresBundles, Set<String> transitiveFeatures, Map<String, Feature> featuresMap) {
        for (String feature : features) {
            Feature f = featuresMap.get(feature);
            if (f == null) {
                throw new IllegalArgumentException("Unable to find the feature '" + feature + "'");
            }
            if (!this.features.contains(feature)) {
                transitiveFeatures.add(feature);
            } else {
                this.getLog().info((CharSequence)("Adding contents for feature: " + feature));
                featuresBundles.addAll(featuresMap.get(feature).getBundles());
                featuresBundles.addAll(featuresMap.get(feature).getConfigFiles());
            }
            this.addFeatures(f.getDependencies(), featuresBundles, transitiveFeatures, featuresMap);
        }
    }

    public static void copy(InputStream is, File dir, String destName, String destDir, byte[] buffer) throws IOException {
        File targetDir;
        if (destDir == null) {
            destDir = "";
        }
        if (!(targetDir = new File(dir, destDir)).exists()) {
            if (!targetDir.mkdirs()) {
                throw new IOException("Unable to create target directory: " + targetDir);
            }
        } else if (!targetDir.isDirectory()) {
            throw new IOException("Target is not a directory: " + targetDir);
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(targetDir, destName)));
        int count = 0;
        while ((count = is.read(buffer)) > 0) {
            bos.write(buffer, 0, count);
        }
        bos.close();
    }

    public static class Repository {
        private URI uri;
        private List<Feature> features;

        public Repository(URI uri) {
            this.uri = uri;
        }

        public URI getURI() {
            return this.uri;
        }

        public Feature[] getFeatures() throws Exception {
            if (this.features == null) {
                this.load();
            }
            return this.features.toArray(new Feature[this.features.size()]);
        }

        public void load() throws IOException {
            try {
                this.features = new ArrayList<Feature>();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document doc = factory.newDocumentBuilder().parse(this.uri.toURL().openStream());
                NodeList nodes = doc.getDocumentElement().getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    if (!(node instanceof Element) || !"feature".equals(node.getNodeName())) continue;
                    Element e = (Element)nodes.item(i);
                    String name = e.getAttribute("name");
                    Feature f = new Feature(name);
                    NodeList featureNodes = e.getElementsByTagName("feature");
                    for (int j = 0; j < featureNodes.getLength(); ++j) {
                        Element b = (Element)featureNodes.item(j);
                        f.addDependency(b.getTextContent());
                    }
                    NodeList configNodes = e.getElementsByTagName("config");
                    for (int j = 0; j < configNodes.getLength(); ++j) {
                        Element c = (Element)configNodes.item(j);
                        String cfgName = c.getAttribute("name");
                        String data = c.getTextContent();
                        Properties properties = new Properties();
                        properties.load(new ByteArrayInputStream(data.getBytes()));
                        Hashtable<String, String> hashtable = new Hashtable<String, String>();
                        for (Object key : properties.keySet()) {
                            String n = key.toString();
                            hashtable.put(n, properties.getProperty(n));
                        }
                        f.addConfig(cfgName, hashtable);
                    }
                    NodeList configFileNodes = e.getElementsByTagName("configfile");
                    for (int j = 0; j < configFileNodes.getLength(); ++j) {
                        Element c = (Element)configFileNodes.item(j);
                        f.addConfigFile(c.getTextContent());
                    }
                    NodeList bundleNodes = e.getElementsByTagName("bundle");
                    for (int j = 0; j < bundleNodes.getLength(); ++j) {
                        Element b = (Element)bundleNodes.item(j);
                        f.addBundle(b.getTextContent());
                    }
                    this.features.add(f);
                }
            }
            catch (SAXException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (ParserConfigurationException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Feature {
        private String name;
        private List<String> dependencies = new ArrayList<String>();
        private List<String> bundles = new ArrayList<String>();
        private Map<String, Map<String, String>> configs = new HashMap<String, Map<String, String>>();
        private List<String> configFiles = new ArrayList<String>();

        public Feature(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getDependencies() {
            return this.dependencies;
        }

        public List<String> getBundles() {
            return this.bundles;
        }

        public Map<String, Map<String, String>> getConfigurations() {
            return this.configs;
        }

        public List<String> getConfigFiles() {
            return this.configFiles;
        }

        public void addDependency(String dependency) {
            this.dependencies.add(dependency);
        }

        public void addBundle(String bundle) {
            this.bundles.add(bundle);
        }

        public void addConfig(String name, Map<String, String> properties) {
            this.configs.put(name, properties);
        }

        public void addConfigFile(String configFile) {
            this.configFiles.add(configFile);
        }
    }
}

