/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.felix.utils.manifest.Clause;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.internal.FeatureValidationUtil;
import org.apache.karaf.features.internal.RepositoryImpl;
import org.apache.karaf.tooling.features.CustomBundleURLStreamHandlerFactory;
import org.apache.karaf.tooling.features.ManifestUtils;
import org.apache.karaf.tooling.features.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateFeaturesMojo
extends MojoSupport {
    private static final String MVN_URI_PREFIX = "mvn:";
    private static final String MVN_REPO_SEPARATOR = "!";
    private static final String KARAF_CORE_STANDARD_FEATURE_URL = "mvn:org.apache.karaf.assemblies.features/standard/%s/xml/features";
    private static final String KARAF_CORE_ENTERPRISE_FEATURE_URL = "mvn:org.apache.karaf.assemblies.features/enterprise/%s/xml/features";
    private DependencyTreeBuilder dependencyTreeBuilder;
    private ArtifactCollector collector;
    private File file;
    private String karafConfig;
    private String jreVersion;
    private String karafVersion;
    private List<String> repositories;
    private boolean skipNonMavenProtocols = false;
    private Map<String, Object> bundles = new HashMap<String, Object>();
    private Map<Object, Manifest> manifests = new HashMap<Object, Manifest>();
    private Features features = new Features();
    private Map<String, Set<Clause>> featureExports = new HashMap<String, Set<Clause>>();
    private Set<String> systemExports = new HashSet<String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.prepare();
            URI uri = this.file.toURI();
            RepositoryImpl repository = new RepositoryImpl(uri);
            this.schemaCheck((Repository)repository, uri);
            this.analyze((Repository)repository);
            this.validate((Repository)repository);
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Unable to validate %s: %s", this.file.getAbsolutePath(), e.getMessage()), e);
        }
    }

    private void schemaCheck(Repository repository, URI uri) {
        try {
            this.info(" - validation of %s", uri);
            FeatureValidationUtil.validate((URI)repository.getURI());
        }
        catch (Exception e) {
            this.error("Failed to validate repository %s. Schema validation fails. Fix errors to continue validation", e, uri);
        }
    }

    private void prepare() throws Exception {
        this.info("== Preparing for validation ==", new Object[0]);
        URL.setURLStreamHandlerFactory(new CustomBundleURLStreamHandlerFactory());
        this.info(" - getting list of system bundle exports", new Object[0]);
        this.readSystemPackages();
        this.info(" - getting list of provided bundle exports", new Object[0]);
        this.readProvidedBundles();
        this.info(" - populating repositories with karaf core features descriptors", new Object[0]);
        this.appendKarafCoreFeaturesDescriptors();
    }

    private void appendKarafCoreFeaturesDescriptors() {
        if (this.repositories == null) {
            this.repositories = new ArrayList<String>();
        }
        if (this.karafVersion == null) {
            Package p = Package.getPackage("org.apache.karaf.tooling.features");
            this.karafVersion = p.getImplementationVersion();
        }
        String karafCoreStandardFeaturesUrl = String.format(KARAF_CORE_STANDARD_FEATURE_URL, this.karafVersion);
        String karafCoreEnterpriseFeaturesUrl = String.format(KARAF_CORE_ENTERPRISE_FEATURE_URL, this.karafVersion);
        try {
            this.resolve(karafCoreStandardFeaturesUrl);
            this.repositories.add(karafCoreStandardFeaturesUrl);
        }
        catch (Exception e) {
            this.warn("Can't add " + karafCoreStandardFeaturesUrl + " in the default repositories set", new Object[0]);
        }
        try {
            this.resolve(karafCoreEnterpriseFeaturesUrl);
            this.repositories.add(karafCoreEnterpriseFeaturesUrl);
        }
        catch (Exception e) {
            this.warn("Can't add " + karafCoreStandardFeaturesUrl + " in the default repositories set", new Object[0]);
        }
    }

    private void analyze(Repository repository) throws Exception {
        this.info("== Analyzing feature descriptor ==", new Object[0]);
        this.info(" - read %s", this.file.getAbsolutePath());
        this.features.add(repository.getFeatures());
        if (this.repositories != null) {
            for (String uri : this.repositories) {
                this.getLog().info((CharSequence)String.format(" - adding repository from %s", uri));
                RepositoryImpl dependency = new RepositoryImpl(URI.create(this.translateFromMaven(uri)));
                this.schemaCheck((Repository)dependency, URI.create(uri));
                this.features.add(dependency.getFeatures());
                this.validateBundlesAvailable((Repository)dependency);
                this.analyzeExports((Repository)dependency);
            }
        }
        for (URI uri : repository.getRepositories()) {
            Artifact artifact = (Artifact)this.resolve(uri.toString());
            RepositoryImpl dependency = new RepositoryImpl(new File(this.localRepo.getBasedir(), this.localRepo.pathOf(artifact)).toURI());
            this.schemaCheck((Repository)dependency, uri);
            this.getLog().info((CharSequence)String.format(" - adding %d known features from %s", dependency.getFeatures().length, uri));
            this.features.add(dependency.getFeatures());
            this.validateBundlesAvailable((Repository)dependency);
            this.analyzeExports((Repository)dependency);
        }
    }

    private void validate(Repository repository) throws Exception {
        this.info("== Validating feature descriptor ==", new Object[0]);
        this.info(" - validating %d features", repository.getFeatures().length);
        this.info(" - step 1: Checking if all artifacts exist", new Object[0]);
        this.validateBundlesAvailable(repository);
        this.info("    OK: all %d OSGi bundles have been found", this.bundles.size());
        this.info(" - step 2: Checking if all imports for bundles can be resolved", new Object[0]);
        this.validateImportsExports(repository);
        this.info("== Done! ==========================", new Object[0]);
    }

    private void readProvidedBundles() throws Exception {
        DependencyNode tree = this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepo, this.factory, this.artifactMetadataSource, new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                return true;
            }
        }, this.collector);
        tree.accept(new DependencyNodeVisitor(){

            public boolean endVisit(DependencyNode node) {
                return true;
            }

            public boolean visit(DependencyNode node) {
                if (node.getState() != 2) {
                    Artifact artifact = node.getArtifact();
                    ValidateFeaturesMojo.this.info("    scanning %s for exports", new Object[]{artifact});
                    if ("provided".equals(artifact.getScope()) && !artifact.getType().equals("pom")) {
                        try {
                            for (Clause clause : ManifestUtils.getExports(ValidateFeaturesMojo.this.getManifest("", artifact))) {
                                ValidateFeaturesMojo.this.getLog().debug((CharSequence)(" adding " + clause.getName() + " to list of available packages"));
                                ValidateFeaturesMojo.this.systemExports.add(clause.getName());
                            }
                        }
                        catch (ArtifactResolutionException e) {
                            ValidateFeaturesMojo.this.error("Unable to find bundle exports for %s: %s", (Exception)((Object)e), new Object[]{artifact, e.getMessage()});
                        }
                        catch (ArtifactNotFoundException e) {
                            ValidateFeaturesMojo.this.error("Unable to find bundle exports for %s: %s", (Exception)((Object)e), new Object[]{artifact, e.getMessage()});
                        }
                        catch (IOException e) {
                            ValidateFeaturesMojo.this.error("Unable to find bundle exports for %s: %s", e, new Object[]{artifact, e.getMessage()});
                        }
                    }
                }
                return true;
            }
        });
    }

    private void readSystemPackages() throws IOException {
        Properties properties = new Properties();
        if (this.karafConfig.equals("config.properties")) {
            properties.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("config.properties"));
        } else {
            properties.load(new FileInputStream(new File(this.karafConfig)));
        }
        String packages = (String)properties.get(this.jreVersion);
        for (String pkg : packages.split(";")) {
            this.systemExports.add(pkg.trim());
        }
        for (String pkg : packages.split(",")) {
            this.systemExports.add(pkg.trim());
        }
    }

    private void analyzeExports(Repository repository) throws Exception {
        for (Feature feature : repository.getFeatures()) {
            HashSet<Clause> exports = new HashSet<Clause>();
            for (String bundle : this.getBundleLocations(feature)) {
                exports.addAll(ManifestUtils.getExports(this.getManifest(bundle, this.bundles.get(bundle))));
            }
            this.info("    scanning feature %s for exports", feature.getName());
            this.featureExports.put(feature.getName(), exports);
        }
    }

    private void validateBundlesAvailable(Repository repository) throws Exception {
        for (Feature feature : repository.getFeatures()) {
            for (String bundle : this.getBundleLocations(feature)) {
                if (!this.isMavenProtocol(bundle) && this.skipNonMavenProtocols) continue;
                Object artifact = this.resolve(bundle);
                this.bundles.put(bundle, artifact);
                if (this.isBundle(bundle, artifact)) {
                    this.manifests.put(artifact, this.getManifest(bundle, artifact));
                    continue;
                }
                throw new Exception(String.format("%s is not an OSGi bundle", bundle));
            }
        }
    }

    private List<String> getBundleLocations(Feature feature) {
        LinkedList<String> result = new LinkedList<String>();
        if (feature != null && feature.getBundles() != null) {
            for (BundleInfo bundle : feature.getBundles()) {
                result.add(bundle.getLocation());
            }
        }
        return result;
    }

    private void validateImportsExports(Repository repository) throws ArtifactResolutionException, ArtifactNotFoundException, Exception {
        for (Feature feature : repository.getFeatures()) {
            if (this.featureExports.containsKey(feature.getName())) continue;
            this.validateImportsExports(feature);
        }
    }

    private void validateImportsExports(Feature feature) throws Exception {
        HashMap<Clause, String> imports = new HashMap<Clause, String>();
        HashSet<Clause> exports = new HashSet<Clause>();
        for (Feature dependency : feature.getDependencies()) {
            if (this.featureExports.containsKey(dependency.getName())) {
                exports.addAll((Collection)this.featureExports.get(dependency.getName()));
                continue;
            }
            this.validateImportsExports(this.features.get(dependency.getName(), dependency.getVersion()));
        }
        for (String bundle : this.getBundleLocations(feature)) {
            Manifest meta = this.manifests.get(this.bundles.get(bundle));
            exports.addAll(ManifestUtils.getExports(meta));
            for (Clause clause : ManifestUtils.getMandatoryImports(meta)) {
                imports.put(clause, bundle);
            }
        }
        HashSet requirements = new HashSet();
        requirements.addAll(imports.keySet());
        for (Clause element : imports.keySet()) {
            if (this.systemExports.contains(element.getName())) {
                this.debug("%s is resolved by a system bundle export or provided bundle", element);
                requirements.remove(element);
                continue;
            }
            for (Clause export : exports) {
                if (ManifestUtils.matches(element, export)) {
                    this.debug("%s is resolved by export %s", element, export);
                    requirements.remove(element);
                    continue;
                }
                this.debug("%s is not resolved by export %s", element, export);
            }
        }
        if (!requirements.isEmpty()) {
            this.warn("Failed to validate feature %s", feature.getName());
            for (Clause entry : requirements) {
                this.warn("No export found to match %s (imported by %s)", entry, imports.get(entry));
            }
            throw new Exception(String.format("%d unresolved imports in feature %s", requirements.size(), feature.getName()));
        }
        this.info("    OK: imports resolved for %s", feature.getName());
        this.featureExports.put(feature.getName(), exports);
    }

    private boolean isBundle(String bundle, Object artifact) {
        if (artifact instanceof Artifact && "bundle".equals(((Artifact)artifact).getArtifactHandler().getPackaging())) {
            return true;
        }
        try {
            return ManifestUtils.isBundle(this.getManifest(bundle, artifact));
        }
        catch (ZipException e) {
            this.getLog().debug((CharSequence)("Unable to determine if " + artifact + " is a bundle; defaulting to false"), (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)("Unable to determine if " + artifact + " is a bundle; defaulting to false"), (Throwable)e);
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)("Unable to determine if " + artifact + " is a bundle; defaulting to false"), (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getManifest(String bundle, Object artifact) throws ArtifactResolutionException, ArtifactNotFoundException, ZipException, IOException {
        ZipFile file = null;
        if (!(artifact instanceof Artifact)) {
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new URL(bundle).openStream());
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)"Error while opening artifact", (Throwable)e);
            }
            try {
                ((InputStream)is).mark(262144);
                JarInputStream jar = new JarInputStream(is);
                Manifest m = jar.getManifest();
                if (m == null) {
                    throw new IOException("Manifest not present in the first entry of the zip");
                }
                Manifest manifest = m;
                return manifest;
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        Artifact mvnArtifact = (Artifact)artifact;
        File localFile = new File(this.localRepo.pathOf(mvnArtifact));
        if (localFile.exists()) {
            file = new ZipFile(localFile);
        } else {
            this.resolver.resolve(mvnArtifact, this.remoteRepos, this.localRepo);
            file = new ZipFile(mvnArtifact.getFile());
        }
        PrintStream original = System.err;
        try {
            Manifest manifest;
            System.setErr(new PrintStream(new ByteArrayOutputStream()));
            Manifest manifest2 = manifest = new Manifest(file.getInputStream(file.getEntry("META-INF/MANIFEST.MF")));
            return manifest2;
        }
        finally {
            System.setErr(original);
        }
    }

    private Object resolve(String bundle) throws Exception, ArtifactNotFoundException {
        if (!this.isMavenProtocol(bundle)) {
            return bundle;
        }
        Artifact artifact = this.getArtifact(bundle);
        if (bundle.indexOf(MVN_REPO_SEPARATOR) >= 0) {
            if (bundle.startsWith(MVN_URI_PREFIX)) {
                bundle = bundle.substring(MVN_URI_PREFIX.length());
            }
            String repo = bundle.substring(0, bundle.indexOf(MVN_REPO_SEPARATOR));
            DefaultArtifactRepository repository = new DefaultArtifactRepository(artifact.getArtifactId() + "-repo", repo, (ArtifactRepositoryLayout)new DefaultRepositoryLayout());
            LinkedList<DefaultArtifactRepository> repos = new LinkedList<DefaultArtifactRepository>();
            repos.add(repository);
            this.resolver.resolve(artifact, repos, this.localRepo);
        } else {
            this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
        }
        if (artifact == null) {
            throw new Exception("Unable to resolve artifact for uri " + bundle);
        }
        return artifact;
    }

    private Artifact getArtifact(String uri) {
        if (uri.startsWith(MVN_URI_PREFIX)) {
            uri = uri.substring(MVN_URI_PREFIX.length());
        }
        if (uri.contains(MVN_REPO_SEPARATOR)) {
            uri = uri.split(MVN_REPO_SEPARATOR)[1];
        }
        String[] elements = uri.split("/");
        switch (elements.length) {
            case 5: {
                return this.factory.createArtifactWithClassifier(elements[0], elements[1], elements[2], elements[3], elements[4]);
            }
            case 3: {
                return this.factory.createArtifact(elements[0], elements[1], elements[2], "provided", "jar");
            }
        }
        return null;
    }

    private boolean isMavenProtocol(String bundle) {
        return bundle.startsWith(MVN_URI_PREFIX);
    }

    private void debug(String message, Object ... parms) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format(message, parms));
        }
    }

    private void info(String message, Object ... parms) {
        this.getLog().info((CharSequence)String.format(message, parms));
    }

    private void warn(String message, Object ... parms) {
        this.getLog().warn((CharSequence)String.format(message, parms));
    }

    private void error(String message, Exception error, Object ... parms) {
        this.getLog().error((CharSequence)String.format(message, parms), (Throwable)error);
    }

    private class Features {
        private List<Feature> features = new LinkedList<Feature>();

        private Features() {
        }

        public void add(Feature feature) {
            this.features.add(feature);
        }

        public Feature get(String name, String version) throws Exception {
            for (Feature feature : this.features) {
                if (!name.equals(feature.getName()) || !version.equals(feature.getVersion())) continue;
                return feature;
            }
            throw new Exception(String.format("Unable to find definition for feature %s (version %s)", name, version));
        }

        public void add(Feature[] array) {
            for (Feature feature : array) {
                this.add(feature);
            }
        }
    }
}

