/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.tooling.features.CopyFileBasedDescriptor;
import org.apache.karaf.tooling.features.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddFeaturesToRepoMojo
extends MojoSupport {
    private static final String KARAF_CORE_STANDARD_FEATURE_URL = "mvn:org.apache.karaf.assemblies.features/standard/%s/xml/features";
    private static final String KARAF_CORE_ENTERPRISE_FEATURE_URL = "mvn:org.apache.karaf.assemblies.features/enterprise/%s/xml/features";
    private List<String> descriptors;
    private List<String> features;
    private String blackList;
    private File repository;
    private String karafVersion;
    private boolean includeMvnBasedDescriptors = false;
    private List<CopyFileBasedDescriptor> copyFileBasedDescriptors;
    private boolean skipNonMavenProtocols = true;
    private boolean failOnArtifactResolutionError = true;
    private boolean resolveDefinedRepositoriesRecursively = true;
    private boolean addTransitiveFeatures = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String karafCoreEnterpriseFeatureUrl;
        Artifact enterpriseFeatureDescriptor;
        String karafCoreStandardFeatureUrl;
        Artifact standardFeatureDescriptor;
        if (this.karafVersion == null) {
            Package p = Package.getPackage("org.apache.karaf.tooling.features");
            this.karafVersion = p.getImplementationVersion();
        }
        if ((standardFeatureDescriptor = this.resourceToArtifact(karafCoreStandardFeatureUrl = String.format(KARAF_CORE_STANDARD_FEATURE_URL, this.karafVersion), true)) != null) {
            try {
                this.resolveBundle(standardFeatureDescriptor, this.remoteRepos);
                this.descriptors.add(0, karafCoreStandardFeatureUrl);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Can't add " + karafCoreStandardFeatureUrl + " in the descriptors set"));
                this.getLog().debug((Throwable)e);
            }
        }
        if ((enterpriseFeatureDescriptor = this.resourceToArtifact(karafCoreEnterpriseFeatureUrl = String.format(KARAF_CORE_ENTERPRISE_FEATURE_URL, this.karafVersion), true)) != null) {
            try {
                this.resolveBundle(enterpriseFeatureDescriptor, this.remoteRepos);
                this.descriptors.add(0, karafCoreEnterpriseFeatureUrl);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Can't add " + karafCoreEnterpriseFeatureUrl + " in the descriptors set"));
                this.getLog().debug((Throwable)e);
            }
        }
        try {
            HashSet<String> bundles = new HashSet<String>();
            HashMap<String, Feature> featuresMap = new HashMap<String, Feature>();
            for (String uri : this.descriptors) {
                this.retrieveDescriptorsRecursively(uri, bundles, featuresMap);
            }
            if (this.features == null) {
                this.features = new ArrayList(featuresMap.keySet());
            }
            HashSet<String> featuresBundles = new HashSet<String>();
            HashSet<String> transitiveFeatures = new HashSet<String>();
            this.addFeatures(this.features, featuresBundles, transitiveFeatures, featuresMap);
            bundles.addAll(featuresBundles);
            if (this.addTransitiveFeatures) {
                for (String feature : transitiveFeatures) {
                    Feature f = (Feature)featuresMap.get(feature);
                    this.getLog().info((CharSequence)("Adding contents of transitive feature: " + feature));
                    bundles.addAll(f.getBundles());
                    bundles.addAll(f.getConfigFiles());
                }
            }
            ArrayList<Artifact> explicitRepoBundles = new ArrayList<Artifact>();
            this.getLog().info((CharSequence)("Base repo: " + this.localRepo.getUrl()));
            int currentBundle = 0;
            for (String bundle : bundles) {
                Artifact artifact = this.resourceToArtifact(bundle, this.skipNonMavenProtocols);
                if (currentBundle++ % 100 == 0) {
                    System.gc();
                    System.runFinalization();
                }
                if (artifact == null) continue;
                if (artifact.getRepository() != null) {
                    explicitRepoBundles.add(artifact);
                    continue;
                }
                this.resolveBundle(artifact, this.remoteRepos);
            }
            for (Artifact explicitBundle : explicitRepoBundles) {
                this.resolveBundle(explicitBundle, Collections.singletonList(explicitBundle.getRepository()));
            }
            if (this.copyFileBasedDescriptors != null) {
                for (CopyFileBasedDescriptor fileBasedDescriptor : this.copyFileBasedDescriptors) {
                    AddFeaturesToRepoMojo.copy(new FileInputStream(fileBasedDescriptor.getSourceFile()), this.repository, fileBasedDescriptor.getTargetFileName(), fileBasedDescriptor.getTargetDirectory(), new byte[8192]);
                }
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error populating repository", e);
        }
    }

    private void retrieveDescriptorsRecursively(String uri, Set<String> bundles, Map<String, Feature> featuresMap) throws Exception {
        Artifact descriptor = this.resourceToArtifact(uri, true);
        if (descriptor != null) {
            this.resolveBundle(descriptor, this.remoteRepos);
        }
        if (this.includeMvnBasedDescriptors) {
            bundles.add(uri);
        }
        Repository repo = new Repository(URI.create(this.translateFromMaven(uri.replaceAll(" ", "%20"))));
        for (Feature f : repo.getFeatures()) {
            if (this.isBlackListed(f)) continue;
            featuresMap.put(f.getName() + "/" + f.getVersion(), f);
        }
        if (this.resolveDefinedRepositoriesRecursively) {
            for (String r : repo.getDefinedRepositories()) {
                this.retrieveDescriptorsRecursively(r, bundles, featuresMap);
            }
        }
    }

    private boolean isBlackListed(Feature feature) {
        if (this.blackList != null) {
            for (String blf : Parser.parseDelimitedString((String)this.blackList, (String)",")) {
                if (blf.contains("/")) {
                    String[] s = blf.split("/");
                    VersionRange range = new VersionRange(s[1], true);
                    Version version = VersionTable.getVersion((String)feature.getVersion());
                    if (!s[0].equals(feature.getName()) || !range.contains(version)) continue;
                    return true;
                }
                if (!blf.equals(feature.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void resolveBundle(Artifact bundle, List<ArtifactRepository> remoteRepos) throws IOException, MojoFailureException {
        String dir = bundle.getGroupId().replace('.', '/') + "/" + bundle.getArtifactId() + "/" + bundle.getBaseVersion() + "/";
        String name = bundle.getArtifactId() + "-" + bundle.getBaseVersion() + (bundle.getClassifier() != null ? "-" + bundle.getClassifier() : "") + "." + bundle.getType();
        try {
            this.getLog().info((CharSequence)("Copying bundle: " + bundle));
            this.resolver.resolve(bundle, remoteRepos, this.localRepo);
            AddFeaturesToRepoMojo.copy(new FileInputStream(bundle.getFile()), this.repository, name, dir, new byte[8192]);
        }
        catch (ArtifactResolutionException e) {
            if (this.failOnArtifactResolutionError) {
                throw new MojoFailureException("Can't resolve bundle " + bundle, (Throwable)e);
            }
            this.getLog().error((CharSequence)("Can't resolve bundle " + bundle), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            if (this.failOnArtifactResolutionError) {
                throw new MojoFailureException("Can't resolve bundle " + bundle, (Throwable)e);
            }
            this.getLog().error((CharSequence)("Can't resolve bundle " + bundle), (Throwable)e);
        }
    }

    private void addFeatures(List<String> features, Set<String> featuresBundles, Set<String> transitiveFeatures, Map<String, Feature> featuresMap) {
        for (String feature : features) {
            int delimIndex = feature.indexOf(47);
            String version = null;
            if (delimIndex > 0) {
                version = feature.substring(delimIndex + 1);
                feature = feature.substring(0, delimIndex);
            }
            Feature f = null;
            if (version != null) {
                f = featuresMap.get(feature + "/" + version);
                if (f == null) {
                    VersionRange versionRange = new VersionRange(version);
                    for (String key : featuresMap.keySet()) {
                        String verStr;
                        Version ver;
                        String[] nameVersion = key.split("/");
                        if (!feature.equals(nameVersion[0]) || !versionRange.contains(ver = VersionTable.getVersion((String)(verStr = featuresMap.get(key).getVersion()))) || f != null && VersionTable.getVersion((String)f.getVersion()).compareTo(VersionTable.getVersion((String)featuresMap.get(key).getVersion())) >= 0) continue;
                        f = featuresMap.get(key);
                    }
                }
            } else {
                for (String key : featuresMap.keySet()) {
                    String[] nameVersion = key.split("/");
                    if (!feature.equals(nameVersion[0]) || f != null && VersionTable.getVersion((String)f.getVersion()).compareTo(VersionTable.getVersion((String)featuresMap.get(key).getVersion())) >= 0) continue;
                    f = featuresMap.get(key);
                }
            }
            if (f == null) {
                throw new IllegalArgumentException("Unable to find the feature '" + feature + (version != null ? "/" + version : "") + "'");
            }
            if (!this.features.contains(f.getName() + "/" + f.getVersion())) {
                transitiveFeatures.add(f.getName() + "/" + f.getVersion());
            } else {
                this.getLog().info((CharSequence)("Adding contents for feature: " + f.getName() + "/" + f.getVersion()));
                featuresBundles.addAll(f.getBundles());
                featuresBundles.addAll(f.getConfigFiles());
            }
            this.addFeatures(f.getDependencies(), featuresBundles, transitiveFeatures, featuresMap);
        }
    }

    public static void copy(InputStream is, File dir, String destName, String destDir, byte[] buffer) throws IOException {
        File targetDir;
        if (destDir == null) {
            destDir = "";
        }
        if (!(targetDir = new File(dir, destDir)).exists()) {
            if (!targetDir.mkdirs()) {
                throw new IOException("Unable to create target directory: " + targetDir);
            }
        } else if (!targetDir.isDirectory()) {
            throw new IOException("Target is not a directory: " + targetDir);
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(targetDir, destName)));
        int count = 0;
        while ((count = is.read(buffer)) > 0) {
            bos.write(buffer, 0, count);
        }
        bos.close();
    }

    public static class Repository {
        private URI uri;
        private List<Feature> features;
        private List<String> repositories;

        public Repository(URI uri) {
            this.uri = uri;
        }

        public URI getURI() {
            return this.uri;
        }

        public Feature[] getFeatures() throws Exception {
            if (this.features == null) {
                this.loadFeatures();
            }
            return this.features.toArray(new Feature[this.features.size()]);
        }

        public String[] getDefinedRepositories() throws Exception {
            if (this.repositories == null) {
                this.loadRepositories();
            }
            return this.repositories.toArray(new String[this.repositories.size()]);
        }

        private void loadRepositories() throws IOException {
            try {
                this.repositories = new ArrayList<String>();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document doc = factory.newDocumentBuilder().parse(this.uri.toURL().openStream());
                NodeList nodes = doc.getDocumentElement().getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    if (!(node instanceof Element) || !"repository".equals(node.getNodeName())) continue;
                    Element e = (Element)nodes.item(i);
                    this.repositories.add(e.getTextContent().trim());
                }
            }
            catch (SAXException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (ParserConfigurationException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }

        private void loadFeatures() throws IOException {
            try {
                this.features = new ArrayList<Feature>();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document doc = factory.newDocumentBuilder().parse(this.uri.toURL().openStream());
                NodeList nodes = doc.getDocumentElement().getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    if (!(node instanceof Element) || !"feature".equals(node.getNodeName())) continue;
                    Element e = (Element)nodes.item(i);
                    String name = e.getAttribute("name");
                    String version = e.getAttribute("version");
                    Feature f = new Feature(name);
                    f.setVersion(version);
                    NodeList featureNodes = e.getElementsByTagName("feature");
                    for (int j = 0; j < featureNodes.getLength(); ++j) {
                        Element b = (Element)featureNodes.item(j);
                        if (b.getAttribute("version") != null && b.getAttribute("version").length() > 0) {
                            f.addDependency(b.getTextContent() + "/" + b.getAttribute("version"));
                            continue;
                        }
                        f.addDependency(b.getTextContent());
                    }
                    NodeList configNodes = e.getElementsByTagName("config");
                    for (int j = 0; j < configNodes.getLength(); ++j) {
                        Element c = (Element)configNodes.item(j);
                        String cfgName = c.getAttribute("name");
                        String data = c.getTextContent();
                        Properties properties = new Properties();
                        properties.load(new ByteArrayInputStream(data.getBytes()));
                        Hashtable<String, String> hashtable = new Hashtable<String, String>();
                        for (Object key : properties.keySet()) {
                            String n = key.toString();
                            hashtable.put(n, properties.getProperty(n));
                        }
                        f.addConfig(cfgName, hashtable);
                    }
                    NodeList configFileNodes = e.getElementsByTagName("configfile");
                    for (int j = 0; j < configFileNodes.getLength(); ++j) {
                        Element c = (Element)configFileNodes.item(j);
                        f.addConfigFile(c.getTextContent());
                    }
                    NodeList bundleNodes = e.getElementsByTagName("bundle");
                    for (int j = 0; j < bundleNodes.getLength(); ++j) {
                        Element b = (Element)bundleNodes.item(j);
                        f.addBundle(b.getTextContent());
                    }
                    this.features.add(f);
                }
            }
            catch (SAXException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (ParserConfigurationException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Feature {
        private String name;
        private String version;
        private List<String> dependencies = new ArrayList<String>();
        private List<String> bundles = new ArrayList<String>();
        private Map<String, Map<String, String>> configs = new HashMap<String, Map<String, String>>();
        private List<String> configFiles = new ArrayList<String>();

        public Feature(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public List<String> getDependencies() {
            return this.dependencies;
        }

        public List<String> getBundles() {
            return this.bundles;
        }

        public Map<String, Map<String, String>> getConfigurations() {
            return this.configs;
        }

        public List<String> getConfigFiles() {
            return this.configFiles;
        }

        public void addDependency(String dependency) {
            this.dependencies.add(dependency);
        }

        public void addBundle(String bundle) {
            this.bundles.add(bundle);
        }

        public void addConfig(String name, Map<String, String> properties) {
            this.configs.put(name, properties);
        }

        public void addConfigFile(String configFile) {
            this.configFiles.add(configFile);
        }
    }
}

