/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.ConfigFileInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.internal.RepositoryImpl;
import org.apache.karaf.tooling.features.MojoSupport;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class CreateKarMojo
extends MojoSupport {
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private JarArchiver jarArchiver = null;
    private File outputDirectory = null;
    private String finalName = null;
    private boolean ignoreDependencyFlag;
    private File resourcesDir;
    private File featuresFile;
    private String repositoryPath = "repository/";

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<Artifact> resources = this.readResources();
        File archive = this.createArchive(resources);
        this.projectHelper.attachArtifact(this.project, "kar", null, archive);
    }

    private List<Artifact> readResources() throws MojoExecutionException {
        ArrayList<Artifact> resources = new ArrayList<Artifact>();
        try {
            Feature[] features;
            RepositoryImpl featuresRepo = new RepositoryImpl(this.featuresFile.toURI());
            for (Feature feature : features = featuresRepo.getFeatures()) {
                for (BundleInfo bundle : feature.getBundles()) {
                    if (!this.ignoreDependencyFlag && (this.ignoreDependencyFlag || bundle.isDependency())) continue;
                    resources.add(this.resourceToArtifact(bundle.getLocation(), false));
                }
                for (ConfigFileInfo configFile : feature.getConfigurationFiles()) {
                    resources.add(this.resourceToArtifact(configFile.getLocation(), false));
                }
            }
            return resources;
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not interpret features XML file", e);
        }
    }

    private File createArchive(List<Artifact> bundles) throws MojoExecutionException {
        DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
        File archiveFile = CreateKarMojo.getArchiveFile(this.outputDirectory, this.finalName, null);
        MavenArchiver archiver = new MavenArchiver();
        MavenArchiveConfiguration configuration = new MavenArchiveConfiguration();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(archiveFile);
        try {
            Artifact featureArtifact = this.factory.createArtifactWithClassifier(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "xml", "features");
            this.jarArchiver.addFile(this.featuresFile, this.repositoryPath + layout.pathOf(featureArtifact));
            for (Artifact artifact : bundles) {
                this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
                File localFile = artifact.getFile();
                artifact.setVersion(artifact.getBaseVersion());
                String targetFileName = this.repositoryPath + layout.pathOf(artifact);
                this.jarArchiver.addFile(localFile, targetFileName);
            }
            if (this.resourcesDir.isDirectory()) {
                archiver.getArchiver().addDirectory(this.resourcesDir);
            }
            archiver.createArchive(this.project, configuration);
            return archiveFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create kar archive", e);
        }
    }

    protected static File getArchiveFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".kar");
    }
}

