/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.karaf.tooling.features.ManifestUtils;
import org.apache.karaf.tooling.features.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class GenerateFeaturesFileMojo
extends MojoSupport {
    protected static final String SEPARATOR = "/";
    private File outputFile;
    private String featureName;
    private String attachmentArtifactType = "xml";
    private String attachmentArtifactClassifier = "features";
    private boolean includeProject = false;
    private boolean includeDependencies = true;
    private String karafVersion;
    private File translation;
    private Map<String, Map<VersionRange, String>> translations = new HashMap<String, Map<VersionRange, String>>(){

        @Override
        public Map<VersionRange, String> get(Object key) {
            if (super.get(key) == null) {
                super.put(key.toString(), new HashMap());
            }
            return (Map)super.get(key);
        }
    };
    private Set<Artifact> features = new HashSet<Artifact>();
    private Set<Artifact> provided = new HashSet<Artifact>();
    private Set<Artifact> currentFeature = new HashSet<Artifact>();
    private Set<Artifact> missingBundles = new TreeSet<Artifact>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        OutputStream out = null;
        try {
            this.prepare();
            this.getLog().info((CharSequence)String.format("-- Start generating %s --", this.outputFile.getAbsolutePath()));
            this.outputFile.getParentFile().mkdirs();
            out = new FileOutputStream(this.outputFile);
            PrintStream printer = new PrintStream(out);
            this.populateProperties(printer);
            this.getLog().info((CharSequence)String.format("-- Done generating %s --", this.outputFile.getAbsolutePath()));
            this.projectHelper.attachArtifact(this.project, this.attachmentArtifactType, this.attachmentArtifactClassifier, this.outputFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to create dependencies file: " + e, e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.getLog().info((CharSequence)("Failed to close: " + this.outputFile + ". Reason: " + e), (Throwable)e);
                }
            }
        }
    }

    protected void populateProperties(PrintStream out) throws ArtifactResolutionException, ArtifactNotFoundException, IOException {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<features>");
        if (this.includeProject) {
            this.writeCurrentProjectFeature(out);
        }
        if (this.includeDependencies) {
            this.writeProjectDependencyFeatures(out);
        }
        out.println("</features>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare() throws ArtifactResolutionException, ArtifactNotFoundException, IOException, InvalidVersionSpecificationException {
        if (this.translation != null) {
            try (InputStream stream = null;){
                stream = new BufferedInputStream(new FileInputStream(this.translation));
                Properties file = new Properties();
                file.load(stream);
                ArrayList<String> stringNames = this.getStringNames(file);
                for (String key : stringNames) {
                    String[] elements = key.split(SEPARATOR);
                    this.translations.get(String.format("%s/%s", elements[0], elements[1])).put(VersionRange.createFromVersionSpec((String)elements[2]), file.getProperty(key));
                }
                this.getLog().info((CharSequence)("Loaded " + this.translations.size() + " bundle name translation rules from " + this.translation.getAbsolutePath()));
            }
        }
        Artifact kernel = this.factory.createArtifact("org.apache.karaf", "apache-karaf", this.karafVersion, "provided", "pom");
        this.resolver.resolve(kernel, this.remoteRepos, this.localRepo);
        this.getLog().info((CharSequence)("-- List of bundles provided by Karaf " + this.karafVersion + " --"));
        for (Artifact artifact : this.getDependencies(kernel)) {
            this.getLog().info((CharSequence)(" " + artifact));
            this.provided.add(artifact);
        }
        this.getLog().info((CharSequence)"-- <end of list>  --");
    }

    private ArrayList<String> getStringNames(Properties file) {
        ArrayList<String> ret = new ArrayList<String>();
        Enumeration<?> name = file.propertyNames();
        while (name.hasMoreElements()) {
            Object ele = name.nextElement();
            if (!(ele instanceof String) || !(file.get(ele) instanceof String)) continue;
            ret.add((String)ele);
        }
        return ret;
    }

    private void writeProjectDependencyFeatures(PrintStream out) {
        Set dependencies = this.project.getDependencyArtifacts();
        dependencies.removeAll(this.provided);
        for (Artifact artifact : dependencies) {
            if (artifact.getScope().equalsIgnoreCase("test")) continue;
            this.getLog().info((CharSequence)(" Generating feature " + artifact.getArtifactId() + " from " + artifact));
            out.println("  <feature name='" + artifact.getArtifactId() + "'>");
            this.currentFeature.clear();
            this.writeBundle(out, artifact);
            this.features.add(artifact);
            out.println("  </feature>");
        }
        if (this.missingBundles.size() > 0) {
            this.getLog().info((CharSequence)"-- Some bundles were missing  --");
            for (Artifact artifact : this.missingBundles) {
                this.getLog().info((CharSequence)String.format(" %s", artifact));
            }
        }
    }

    private void writeBundle(PrintStream out, Artifact artifact) {
        Artifact replacement = this.getReplacement(artifact);
        if (replacement != null) {
            this.writeBundle(out, replacement);
            return;
        }
        if (this.isProvided(artifact)) {
            this.getLog().debug((CharSequence)String.format("Skipping '%s' -- bundle will be provided at runtime", artifact));
            return;
        }
        if (this.features.contains(artifact)) {
            out.println(String.format("    <feature>%s</feature>", artifact.getArtifactId()));
            return;
        }
        for (Artifact dependency : this.getDependencies(artifact)) {
            if (dependency.isOptional() || "test".equals(dependency.getScope())) {
                this.getLog().debug((CharSequence)String.format("Omitting optional and/or test scoped dependency '%s' for '%s'", dependency, artifact));
                continue;
            }
            this.getLog().debug((CharSequence)String.format("Adding '%s' as a dependency for '%s'", dependency, artifact));
            this.writeBundle(out, dependency);
        }
        if (!this.currentFeature.add(artifact)) {
            this.getLog().debug((CharSequence)String.format("Artifact '%s' was already added to the current feature", artifact));
            return;
        }
        if (this.isBundle(artifact)) {
            this.getLog().info((CharSequence)String.format("  adding bundle %s", artifact));
            this.writeBundle(out, artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion());
        } else {
            Artifact wrapper = this.findServicemixBundle(artifact);
            if (wrapper != null) {
                this.getLog().info((CharSequence)String.format("  adding bundle %s (for %s)", wrapper, artifact));
                this.writeBundle(out, wrapper.getGroupId(), wrapper.getArtifactId(), wrapper.getBaseVersion());
            } else {
                this.getLog().error((CharSequence)String.format(" unable to find suitable bundle for artifact '%s'", artifact));
                this.missingBundles.add(artifact);
            }
        }
    }

    private Artifact getReplacement(Artifact artifact) {
        String key = String.format("%s/%s", artifact.getGroupId(), artifact.getArtifactId());
        String bundle = null;
        for (VersionRange range : this.translations.get(key).keySet()) {
            try {
                if (!range.containsVersion(artifact.getSelectedVersion())) continue;
                bundle = this.translations.get(key).get(range);
                break;
            }
            catch (OverConstrainedVersionException e) {
                bundle = null;
            }
        }
        if (bundle != null) {
            String[] split = bundle.split(SEPARATOR);
            return this.factory.createArtifact(split[0], split[1], split[2], "provided", artifact.getArtifactHandler().getPackaging());
        }
        return null;
    }

    private Artifact findServicemixBundle(Artifact artifact) {
        Artifact noVersionWrapper = this.factory.createArtifact("org.apache.servicemix.bundles", "org.apache.servicemix.bundles." + artifact.getArtifactId(), "", artifact.getScope(), artifact.getType());
        try {
            List versions = this.artifactMetadataSource.retrieveAvailableVersions(noVersionWrapper, this.localRepo, this.remoteRepos);
            Artifact wrapper = this.factory.createArtifact("org.apache.servicemix.bundles", "org.apache.servicemix.bundles." + artifact.getArtifactId(), this.getBestVersionForArtifact(artifact, versions), artifact.getScope(), artifact.getType());
            this.resolver.resolve(wrapper, this.remoteRepos, this.localRepo);
            for (Artifact dependency : this.getDependencies(wrapper)) {
                this.getLog().debug((CharSequence)String.format("'%s' also provides '%s'", wrapper, dependency));
                this.currentFeature.add(dependency);
            }
            return wrapper;
        }
        catch (ArtifactResolutionException e) {
            this.getLog().debug((CharSequence)("Couldn't find a ServiceMix bundle for " + artifact), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().debug((CharSequence)("Couldn't find a ServiceMix bundle for " + artifact), (Throwable)e);
        }
        catch (ArtifactMetadataRetrievalException e) {
            this.getLog().debug((CharSequence)("Couldn't find a ServiceMix bundle for " + artifact), (Throwable)e);
        }
        if (artifact.getArtifactId().contains("-")) {
            return this.findServicemixBundle(this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId().split("-")[0], artifact.getVersion(), artifact.getScope(), artifact.getType()));
        }
        return null;
    }

    protected String getBestVersionForArtifact(Artifact artifact, List<ArtifactVersion> versions) throws ArtifactMetadataRetrievalException {
        if (versions.size() == 0) {
            throw new ArtifactMetadataRetrievalException("No wrapper bundle available for " + artifact);
        }
        Collections.sort(versions, Collections.reverseOrder());
        for (ArtifactVersion version : versions) {
            if (!version.toString().startsWith(artifact.getVersion())) continue;
            return version.toString();
        }
        for (ArtifactVersion version : versions) {
            String[] elements = version.toString().split("\\.");
            if (elements.length < 2 || !artifact.getVersion().startsWith(elements[0] + "." + elements[1])) continue;
            return version.toString();
        }
        throw new ArtifactMetadataRetrievalException("No suitable version found for " + artifact + " wrapper bundle");
    }

    private boolean isProvided(Artifact bundle) {
        for (Artifact artifact : this.provided) {
            if (!bundle.getArtifactId().equals(artifact.getArtifactId()) || !bundle.getGroupId().equals(artifact.getGroupId())) continue;
            return true;
        }
        return false;
    }

    private boolean isBundle(Artifact artifact) {
        if (artifact.getArtifactHandler().getPackaging().equals("bundle")) {
            return true;
        }
        try {
            this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
            ZipFile file = new ZipFile(artifact.getFile());
            ZipEntry entry = file.getEntry("META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(file.getInputStream(entry));
            if (ManifestUtils.isBundle(manifest)) {
                this.getLog().debug((CharSequence)String.format("MANIFEST.MF for '%s' contains Bundle-Name '%s'", artifact, ManifestUtils.getBsn(manifest)));
                return true;
            }
        }
        catch (ZipException e) {
            this.getLog().warn((CharSequence)("Unable to determine if " + artifact + " is a bundle; defaulting to false"), (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to determine if " + artifact + " is a bundle; defaulting to false"), (Throwable)e);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Unable to determine if " + artifact + " is a bundle; defaulting to false"), (Throwable)e);
        }
        return false;
    }

    private List<Artifact> getDependencies(Artifact artifact) {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        try {
            ResolutionGroup pom = this.artifactMetadataSource.retrieve(artifact, this.localRepo, this.remoteRepos);
            if (pom != null) {
                list.addAll(pom.getArtifacts());
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            this.getLog().warn((CharSequence)("Unable to retrieve metadata for " + artifact + ", not including dependencies for it"));
        }
        catch (InvalidArtifactRTException e) {
            this.getLog().warn((CharSequence)("Unable to retrieve metadata for " + artifact + ", not including dependencies for it"));
        }
        return list;
    }

    private void writeCurrentProjectFeature(PrintStream out) {
        out.println("  <feature name='" + this.featureName + "'>");
        this.writeBundle(out, this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
        out.println();
        for (Dependency dependency : this.project.getDependencies()) {
            if (!this.isValidDependency(dependency)) continue;
            out.print("  ");
            this.writeBundle(out, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        }
        out.println("  </feature>");
    }

    protected boolean isValidDependency(Dependency dependency) {
        return true;
    }

    protected void writeBundle(PrintStream out, String groupId, String artifactId, String version) {
        out.print("    <bundle>mvn:");
        out.print(groupId);
        out.print(SEPARATOR);
        out.print(artifactId);
        out.print(SEPARATOR);
        out.print(version);
        out.print("</bundle>");
        out.println();
    }
}

