/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import org.apache.karaf.deployer.kar.KarArtifactInstaller;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.tooling.features.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class InstallKarsMojo
extends MojoSupport {
    protected String workDirectory;
    protected File featuresCfgFile;
    protected String systemRepoDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        KarArtifactInstaller installer = new KarArtifactInstaller();
        installer.setBasePath(this.workDirectory);
        installer.setLocalRepoPath(this.systemRepoDirectory);
        OfflineFeaturesService featuresService = new OfflineFeaturesService();
        installer.setFeaturesService((FeaturesService)featuresService);
        installer.init();
        Set dependencies = this.project.getDependencyArtifacts();
        StringBuilder buf = new StringBuilder();
        for (Artifact artifact : dependencies) {
            if (!"kar".equals(artifact.getType()) || !"compile".equals(artifact.getScope())) continue;
            File file = artifact.getFile();
            try {
                installer.install(file);
            }
            catch (Exception e) {
                buf.append("Could not install kar: ").append(artifact.toString()).append("\n");
                buf.append(e.getMessage()).append("\n\n");
            }
        }
        if (buf.length() > 0) {
            throw new MojoExecutionException("Could not unpack all dependencies:\n" + buf.toString());
        }
    }

    private class OfflineFeaturesService
    implements FeaturesService {
        private static final String FEATURES_REPOSITORIES = "featuresRepositories";

        private OfflineFeaturesService() {
        }

        public void validateRepository(URI uri) throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRepository(URI url) throws Exception {
            if (InstallKarsMojo.this.featuresCfgFile.exists()) {
                Properties properties = new Properties();
                try (FileInputStream in = new FileInputStream(InstallKarsMojo.this.featuresCfgFile);){
                    properties.load(in);
                }
                String existingFeatureRepos = properties.containsKey(FEATURES_REPOSITORIES) ? properties.getProperty(FEATURES_REPOSITORIES) + "," : "";
                existingFeatureRepos = existingFeatureRepos + url.toString();
                properties.setProperty(FEATURES_REPOSITORIES, existingFeatureRepos);
                try (FileOutputStream out = new FileOutputStream(InstallKarsMojo.this.featuresCfgFile);){
                    properties.store(out, "Features Service config");
                }
            }
        }

        public void addRepository(URI url, boolean install) throws Exception {
            this.addRepository(url);
        }

        public void removeRepository(URI url) {
        }

        public void removeRepository(URI url, boolean uninstall) {
        }

        public void restoreRepository(URI url) throws Exception {
        }

        public Repository[] listRepositories() {
            return new Repository[0];
        }

        public void installFeature(String name) throws Exception {
        }

        public void installFeature(String name, EnumSet<FeaturesService.Option> options) throws Exception {
        }

        public void installFeature(String name, String version) throws Exception {
        }

        public void installFeature(String name, String version, EnumSet<FeaturesService.Option> options) throws Exception {
        }

        public void installFeature(Feature f, EnumSet<FeaturesService.Option> options) throws Exception {
        }

        public void installFeatures(Set<Feature> features, EnumSet<FeaturesService.Option> options) throws Exception {
        }

        public void uninstallFeature(String name) throws Exception {
        }

        public void uninstallFeature(String name, EnumSet<FeaturesService.Option> options) {
        }

        public void uninstallFeature(String name, String version) throws Exception {
        }

        public void uninstallFeature(String name, String version, EnumSet<FeaturesService.Option> options) {
        }

        public Feature[] listFeatures() throws Exception {
            return new Feature[0];
        }

        public Feature[] listInstalledFeatures() {
            return new Feature[0];
        }

        public boolean isInstalled(Feature f) {
            return false;
        }

        public Feature getFeature(String name, String version) throws Exception {
            return null;
        }

        public Feature getFeature(String name) throws Exception {
            return null;
        }
    }
}

