/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.karaf.deployer.spring.SpringTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringURLHandler
extends URLStreamHandler {
    private final Logger logger = LoggerFactory.getLogger(SpringURLHandler.class);
    private static String SYNTAX = "spring: spring-xml-uri";
    private URL springXmlURL;

    @Override
    public URLConnection openConnection(URL url) throws IOException {
        if (url.getPath() == null || url.getPath().trim().length() == 0) {
            throw new MalformedURLException("Path can not be null or empty. Syntax: " + SYNTAX);
        }
        this.springXmlURL = new URL(url.getPath());
        this.logger.debug("Spring xml URL is: [" + this.springXmlURL + "]");
        return new Connection(url);
    }

    public URL getSpringXmlURL() {
        return this.springXmlURL;
    }

    public class Connection
    extends URLConnection {
        public Connection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                SpringTransformer.transform((URL)SpringURLHandler.this.springXmlURL, (OutputStream)os);
                os.close();
                return new ByteArrayInputStream(os.toByteArray());
            }
            catch (Exception e) {
                SpringURLHandler.this.logger.error("Error opening spring xml url", (Throwable)e);
                throw (IOException)new IOException("Error opening spring xml url").initCause(e);
            }
        }
    }
}

