/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi;

import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.jbi.JbiMessageExchangeProcessor;
import org.apache.ode.jbi.MessageExchangePattern;

public abstract class BaseMessageExchangeProcessor
implements JbiMessageExchangeProcessor {
    final Log LOG = LogFactory.getLog(this.getClass());
    DeliveryChannel _channel;

    public BaseMessageExchangeProcessor(DeliveryChannel channel) {
        this._channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onJbiMessageExchange(MessageExchange jbiMex) throws MessagingException {
        block27: {
            block28: {
                block29: {
                    block25: {
                        if (jbiMex.getStatus() == ExchangeStatus.DONE) {
                            return;
                        }
                        if (jbiMex.getStatus() == ExchangeStatus.ERROR) {
                            this.LOG.error((Object)("Error reported for JBI mex " + jbiMex), (Throwable)jbiMex.getError());
                            return;
                        }
                        if (!jbiMex.getPattern().equals(MessageExchangePattern.IN_ONLY)) break block28;
                        boolean success = false;
                        Exception err = null;
                        try {
                            this.invoke((InOnly)jbiMex);
                            success = true;
                            if (success) break block25;
                        }
                        catch (Exception ex) {
                            block30: {
                                block26: {
                                    try {
                                        this.LOG.error((Object)("Error invoking " + this.getClass()), (Throwable)ex);
                                        err = ex;
                                        if (success) break block26;
                                    }
                                    catch (Throwable throwable) {
                                        if (!success) {
                                            jbiMex.setStatus(ExchangeStatus.ERROR);
                                            if (err != null && jbiMex.getError() == null) {
                                                jbiMex.setError(err);
                                            }
                                        } else if (jbiMex.getStatus() == ExchangeStatus.ACTIVE) {
                                            jbiMex.setStatus(ExchangeStatus.DONE);
                                        }
                                        this._channel.send(jbiMex);
                                        throw throwable;
                                    }
                                    jbiMex.setStatus(ExchangeStatus.ERROR);
                                    if (err != null && jbiMex.getError() == null) {
                                        jbiMex.setError(err);
                                    }
                                    break block30;
                                }
                                if (jbiMex.getStatus() == ExchangeStatus.ACTIVE) {
                                    jbiMex.setStatus(ExchangeStatus.DONE);
                                }
                            }
                            this._channel.send(jbiMex);
                            break block27;
                        }
                        jbiMex.setStatus(ExchangeStatus.ERROR);
                        if (err != null && jbiMex.getError() == null) {
                            jbiMex.setError(err);
                        }
                        break block29;
                    }
                    if (jbiMex.getStatus() == ExchangeStatus.ACTIVE) {
                        jbiMex.setStatus(ExchangeStatus.DONE);
                    }
                }
                this._channel.send(jbiMex);
                break block27;
            }
            if (jbiMex.getPattern().equals(MessageExchangePattern.IN_OUT)) {
                InOut mex = (InOut)jbiMex;
                boolean success = false;
                Exception err = null;
                try {
                    NormalizedMessage response = this.invoke(mex);
                    mex.setOutMessage(response);
                    this._channel.send(jbiMex);
                    success = true;
                }
                catch (Exception ex) {
                    this.LOG.error((Object)("Error invoking " + this.getClass()), (Throwable)ex);
                    err = ex;
                }
                catch (Throwable t) {
                    this.LOG.error((Object)"Unexpected error invoking ODE.", t);
                    err = new RuntimeException(t);
                }
                finally {
                    if (jbiMex.getStatus() == ExchangeStatus.ACTIVE && !success) {
                        if (err != null && jbiMex.getError() == null) {
                            jbiMex.setError(err);
                        }
                        jbiMex.setStatus(ExchangeStatus.ERROR);
                        this._channel.send(jbiMex);
                    }
                }
            } else {
                this.LOG.error((Object)("JBI MessageExchange " + jbiMex.getExchangeId() + " is of an unsupported pattern " + jbiMex.getPattern()));
                jbiMex.setStatus(ExchangeStatus.ERROR);
                jbiMex.setError(new Exception("Unknown message exchange pattern: " + jbiMex.getPattern()));
            }
        }
    }

    public abstract NormalizedMessage invoke(InOut var1) throws MessagingException;

    public abstract void invoke(InOnly var1) throws MessagingException;
}

