/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi;

import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.jbi.JbiMessageExchangeProcessor;
import org.apache.ode.jbi.OdeContext;
import org.apache.ode.jbi.OdeService;

class JbiMessageExchangeEventRouter
implements JbiMessageExchangeProcessor {
    private static final Log __log = LogFactory.getLog(JbiMessageExchangeEventRouter.class);
    private OdeContext _ode;

    JbiMessageExchangeEventRouter(OdeContext ode) {
        this._ode = ode;
    }

    public void onJbiMessageExchange(MessageExchange mex) throws MessagingException {
        if (mex.getRole().equals(MessageExchange.Role.CONSUMER)) {
            this._ode._consumer.onJbiMessageExchange(mex);
        } else if (mex.getRole().equals(MessageExchange.Role.PROVIDER)) {
            if (OdeContext.PM_SERVICE_NAME.equals(mex.getEndpoint().getServiceName())) {
                if (this._ode._processManagementProcessor == null) {
                    throw new IllegalStateException("Process Management API not initialized");
                }
                this._ode._processManagementProcessor.onJbiMessageExchange(mex);
                return;
            }
            if (OdeContext.IM_SERVICE_NAME.equals(mex.getEndpoint().getServiceName())) {
                if (this._ode._instanceManagementProcessor == null) {
                    throw new IllegalStateException("Instance Management API not initialized");
                }
                this._ode._instanceManagementProcessor.onJbiMessageExchange(mex);
                return;
            }
            Endpoint endpoint = new Endpoint(mex.getEndpoint().getServiceName(), mex.getEndpoint().getEndpointName());
            OdeService svc = this._ode.getService(endpoint);
            if (svc == null) {
                __log.error((Object)("Received message exchange for unknown service: " + mex.getEndpoint().getServiceName()));
                return;
            }
            svc.onJbiMessageExchange(mex);
        } else {
            __log.debug((Object)("unexpected role: " + mex.getRole()));
        }
    }
}

