/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi;

import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.jbi.OdeService;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

class MyEndpointReference
implements EndpointReference {
    private OdeService _service;

    MyEndpointReference(OdeService service) {
        this._service = service;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MyEndpointReference) {
            return this._service.getInternalServiceEndpoint().getServiceName().equals(((MyEndpointReference)obj)._service.getInternalServiceEndpoint().getServiceName());
        }
        return false;
    }

    public int hashCode() {
        return this._service.getInternalServiceEndpoint().getServiceName().hashCode();
    }

    public Document toXML() {
        Document xml = DOMUtils.newDocument();
        ServiceEndpoint se = this._service.getExternalServiceEndpoint();
        if (se == null) {
            se = this._service.getInternalServiceEndpoint();
        }
        Element root = xml.createElementNS(EndpointReference.SERVICE_REF_QNAME.getNamespaceURI(), EndpointReference.SERVICE_REF_QNAME.getLocalPart());
        xml.appendChild(root);
        DocumentFragment fragment = se.getAsReference(null);
        root.appendChild(xml.importNode(fragment, true));
        return xml;
    }

    OdeService getService() {
        return this._service;
    }
}

