/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.jbi.JbiEndpointReference;
import org.apache.ode.jbi.JbiMessageExchangeProcessor;
import org.apache.ode.jbi.MessageExchangePattern;
import org.apache.ode.jbi.OdeContext;
import org.apache.ode.jbi.ServiceBridge;
import org.apache.ode.jbi.msgmap.Mapper;
import org.apache.ode.jbi.msgmap.MessageTranslationException;

abstract class OdeConsumer
extends ServiceBridge
implements JbiMessageExchangeProcessor {
    private static final Log __log = LogFactory.getLog(OdeConsumer.class);
    private static final long DEFAULT_RESPONSE_TIMEOUT = Long.getLong("org.apache.ode.jbi.timeout", 120000L);
    protected OdeContext _ode;
    protected long _responseTimeout = DEFAULT_RESPONSE_TIMEOUT;
    protected Map<String, PartnerRoleMessageExchange> _outstandingExchanges = new ConcurrentHashMap<String, PartnerRoleMessageExchange>();

    OdeConsumer(OdeContext ode) {
        this._ode = ode;
    }

    public void invokePartner(final PartnerRoleMessageExchange odeMex) throws ContextException {
        MessageExchange jbiMex;
        JbiEndpointReference targetEndpoint = (JbiEndpointReference)odeMex.getEndpointReference();
        if (targetEndpoint == null) {
            String errmsg = "No endpoint for mex: " + odeMex;
            __log.error((Object)errmsg);
            odeMex.replyWithFailure(MessageExchange.FailureType.INVALID_ENDPOINT, errmsg, null);
            return;
        }
        ServiceEndpoint se = targetEndpoint.getServiceEndpoint();
        boolean isTwoWay = odeMex.getMessageExchangePattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
        QName opname = new QName(se.getServiceName().getNamespaceURI(), odeMex.getOperation().getName());
        MessageExchangeFactory mexf = this._ode.getChannel().createExchangeFactory(se);
        try {
            jbiMex = mexf.createExchange(isTwoWay ? MessageExchangePattern.IN_OUT : MessageExchangePattern.IN_ONLY);
            jbiMex.setEndpoint(se);
            jbiMex.setService(se.getServiceName());
            jbiMex.setOperation(opname);
        }
        catch (MessagingException e) {
            String errmsg = "Unable to create JBI message exchange for ODE message exchange " + odeMex;
            __log.error((Object)errmsg, (Throwable)e);
            odeMex.replyWithFailure(MessageExchange.FailureType.COMMUNICATION_ERROR, errmsg, null);
            return;
        }
        Mapper mapper = this._ode.getDefaultMapper();
        odeMex.setProperty(Mapper.class.getName(), mapper.getClass().getName());
        try {
            if (!isTwoWay) {
                final InOnly inonly = (InOnly)jbiMex;
                NormalizedMessage nmsg = inonly.createMessage();
                mapper.toNMS(nmsg, odeMex.getRequest(), odeMex.getOperation().getInput().getMessage(), null);
                inonly.setInMessage(nmsg);
                this.copyMexProperties(jbiMex, odeMex);
                this._ode._scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

                    public void afterCompletion(boolean success) {
                        if (success) {
                            OdeConsumer.this.doSendOneWay(odeMex, inonly);
                        }
                    }

                    public void beforeCompletion() {
                    }
                });
                odeMex.replyOneWayOk();
            } else {
                final InOut inout = (InOut)jbiMex;
                NormalizedMessage nmsg = inout.createMessage();
                mapper.toNMS(nmsg, odeMex.getRequest(), odeMex.getOperation().getInput().getMessage(), null);
                inout.setInMessage(nmsg);
                this.copyMexProperties(jbiMex, odeMex);
                this._ode._scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

                    public void afterCompletion(boolean success) {
                        if (success) {
                            OdeConsumer.this.doSendTwoWay(odeMex, inout);
                        }
                    }

                    public void beforeCompletion() {
                    }
                });
                odeMex.replyAsync();
            }
        }
        catch (MessagingException me) {
            String errmsg = "JBI messaging error for ODE MEX " + odeMex;
            __log.error((Object)errmsg, (Throwable)me);
            odeMex.replyWithFailure(MessageExchange.FailureType.COMMUNICATION_ERROR, errmsg, null);
        }
        catch (MessageTranslationException e) {
            String errmsg = "Error converting ODE message to JBI format for mex " + odeMex;
            __log.error((Object)errmsg, (Throwable)e);
            odeMex.replyWithFailure(MessageExchange.FailureType.FORMAT_ERROR, errmsg, null);
        }
    }

    protected abstract void doSendOneWay(PartnerRoleMessageExchange var1, InOnly var2);

    protected abstract void doSendTwoWay(PartnerRoleMessageExchange var1, InOut var2);

    protected abstract void inOutDone(InOut var1);

    public void onJbiMessageExchange(MessageExchange jbiMex) throws MessagingException {
        if (!jbiMex.getPattern().equals(MessageExchangePattern.IN_ONLY) && !jbiMex.getPattern().equals(MessageExchangePattern.IN_OUT)) {
            __log.error((Object)("JBI MessageExchange " + jbiMex.getExchangeId() + " is of an unsupported pattern " + jbiMex.getPattern()));
            return;
        }
        if (jbiMex.getStatus() == ExchangeStatus.ACTIVE) {
            if (jbiMex.getPattern().equals(MessageExchangePattern.IN_OUT)) {
                this.inOutDone((InOut)jbiMex);
                this.outResponse((InOut)jbiMex);
            }
            jbiMex.setStatus(ExchangeStatus.DONE);
            this._ode.getChannel().send(jbiMex);
        } else if (jbiMex.getStatus() == ExchangeStatus.ERROR) {
            this.inOutDone((InOut)jbiMex);
            this.outFailure((InOut)jbiMex);
        } else if (jbiMex.getStatus() == ExchangeStatus.DONE) {
            this._outstandingExchanges.remove(jbiMex.getExchangeId());
        } else {
            __log.error((Object)("Unexpected status " + jbiMex.getStatus() + " for JBI message exchange: " + jbiMex.getExchangeId()));
        }
    }

    private void outFailure(final InOut jbiMex) {
        final PartnerRoleMessageExchange pmex = this._outstandingExchanges.remove(jbiMex.getExchangeId());
        if (pmex == null) {
            __log.warn((Object)("Received a response for unknown JBI message exchange " + jbiMex.getExchangeId()));
            return;
        }
        try {
            this._ode._scheduler.execTransaction((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    pmex.replyWithFailure(MessageExchange.FailureType.OTHER, "Error: " + jbiMex.getError(), null);
                    return null;
                }
            });
        }
        catch (Exception ex) {
            __log.error((Object)"error delivering failure: ", (Throwable)ex);
        }
    }

    private void outResponse(final InOut jbiMex) {
        final PartnerRoleMessageExchange outstanding = this._outstandingExchanges.remove(jbiMex.getExchangeId());
        if (outstanding == null) {
            __log.warn((Object)("Received a response for unknown JBI message exchange " + jbiMex.getExchangeId()));
            return;
        }
        try {
            this._ode._scheduler.execTransaction((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    Mapper mapper;
                    PartnerRoleMessageExchange pmex = (PartnerRoleMessageExchange)OdeConsumer.this._ode._server.getEngine().getMessageExchange(outstanding.getMessageExchangeId());
                    if (pmex == null) {
                        __log.warn((Object)("Received a response for unknown partner role message exchange " + outstanding.getMessageExchangeId()));
                        return Boolean.FALSE;
                    }
                    String mapperName = pmex.getProperty(Mapper.class.getName());
                    Mapper mapper2 = mapper = mapperName == null ? OdeConsumer.this._ode.getDefaultMapper() : OdeConsumer.this._ode.getMapper(mapperName);
                    if (mapper == null) {
                        String errmsg = "Mapper not found.";
                        __log.error((Object)errmsg);
                        pmex.replyWithFailure(MessageExchange.FailureType.FORMAT_ERROR, errmsg, null);
                    } else {
                        try {
                            Fault jbiFlt = jbiMex.getFault();
                            if (jbiFlt != null) {
                                javax.wsdl.Fault wsdlFlt = mapper.toFaultType(jbiFlt, pmex.getOperation().getFaults().values());
                                if (wsdlFlt == null) {
                                    pmex.replyWithFailure(MessageExchange.FailureType.FORMAT_ERROR, "Unrecognized fault message.", null);
                                } else if (wsdlFlt.getMessage() != null) {
                                    Message faultResponse = pmex.createMessage(wsdlFlt.getMessage().getQName());
                                    mapper.toODE(faultResponse, (NormalizedMessage)jbiFlt, wsdlFlt.getMessage());
                                    pmex.replyWithFault(new QName(pmex.getPortType().getQName().getNamespaceURI(), wsdlFlt.getName()), faultResponse);
                                } else {
                                    __log.fatal((Object)("Internal Error: fault found without a message type: " + wsdlFlt));
                                    pmex.replyWithFailure(MessageExchange.FailureType.FORMAT_ERROR, "Fault has no message: " + wsdlFlt.getName(), null);
                                }
                            } else {
                                Message response = pmex.createMessage(pmex.getOperation().getOutput().getMessage().getQName());
                                mapper.toODE(response, jbiMex.getOutMessage(), pmex.getOperation().getOutput().getMessage());
                                pmex.reply(response);
                            }
                        }
                        catch (MessageTranslationException mte) {
                            __log.error((Object)"Error translating message.", (Throwable)mte);
                            pmex.replyWithFailure(MessageExchange.FailureType.FORMAT_ERROR, mte.getMessage(), null);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception ex) {
            __log.error((Object)"error delivering RESPONSE: ", (Throwable)ex);
        }
    }

    public void setResponseTimeout(long timeout) {
        this._responseTimeout = timeout;
    }

    public long getResponseTimeout() {
        return this._responseTimeout;
    }
}

