/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.jbi.OdeConsumer;
import org.apache.ode.jbi.OdeContext;

class OdeConsumerAsync
extends OdeConsumer {
    private static final Log __log = LogFactory.getLog(OdeConsumerAsync.class);
    private ScheduledExecutorService _executor;
    private Map<String, Long> _mexTimeouts = new ConcurrentHashMap<String, Long>();

    OdeConsumerAsync(OdeContext ode) {
        super(ode);
        this._executor = Executors.newSingleThreadScheduledExecutor();
        this._executor.scheduleWithFixedDelay(new MEXReaper(), this._responseTimeout, this._responseTimeout / 10L, TimeUnit.MILLISECONDS);
    }

    protected void doSendOneWay(final PartnerRoleMessageExchange odeMex, final InOnly inonly) {
        this._executor.submit(new Runnable(){

            public void run() {
                try {
                    OdeConsumerAsync.this._outstandingExchanges.put(inonly.getExchangeId(), odeMex);
                    OdeConsumerAsync.this._ode.getChannel().send((MessageExchange)inonly);
                }
                catch (MessagingException e) {
                    String errmsg = "Error sending request-only message to JBI for ODE mex " + odeMex;
                    __log.error((Object)errmsg, (Throwable)e);
                }
            }
        });
    }

    protected void doSendTwoWay(final PartnerRoleMessageExchange odeMex, final InOut inout) {
        this._executor.submit(new Runnable(){

            public void run() {
                try {
                    OdeConsumerAsync.this._outstandingExchanges.put(inout.getExchangeId(), odeMex);
                    OdeConsumerAsync.this._mexTimeouts.put(inout.getExchangeId(), System.currentTimeMillis() + OdeConsumerAsync.this._responseTimeout);
                    OdeConsumerAsync.this._ode.getChannel().send((MessageExchange)inout);
                }
                catch (MessagingException e) {
                    String errmsg = "Error sending request-only message to JBI for ODE mex " + odeMex;
                    __log.error((Object)errmsg, (Throwable)e);
                }
            }
        });
    }

    protected void inOutDone(InOut inout) {
        this._mexTimeouts.remove(inout.getExchangeId());
    }

    private class MEXReaper
    implements Runnable {
        private MEXReaper() {
        }

        public void run() {
            long now = System.currentTimeMillis();
            Object[] inouts = OdeConsumerAsync.this._mexTimeouts.keySet().toArray();
            for (int i = 0; i < inouts.length; ++i) {
                long timeout = (Long)OdeConsumerAsync.this._mexTimeouts.get(inouts[i]);
                if (now < timeout) continue;
                OdeConsumerAsync.this._mexTimeouts.remove(inouts[i]);
                final PartnerRoleMessageExchange pmex = (PartnerRoleMessageExchange)OdeConsumerAsync.this._outstandingExchanges.remove(inouts[i]);
                if (pmex == null) continue;
                __log.warn((Object)("Timeout on JBI message exchange " + inouts[i]));
                try {
                    OdeConsumerAsync.this._ode._scheduler.execIsolatedTransaction((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            pmex.replyWithFailure(MessageExchange.FailureType.NO_RESPONSE, "Response not received after " + OdeConsumerAsync.this._responseTimeout + "ms.", null);
                            return null;
                        }
                    });
                    continue;
                }
                catch (Exception ex) {
                    __log.error((Object)"Error executing transaction:  ", (Throwable)ex);
                }
            }
        }
    }
}

