/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.agents.memory.SizingAgent;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactory;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.engine.ProcessAndInstanceManagementImpl;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.Serializer;
import org.apache.ode.bpel.pmapi.InstanceManagement;
import org.apache.ode.bpel.pmapi.ProcessManagement;
import org.apache.ode.jbi.DynamicMessageExchangeProcessor;
import org.apache.ode.jbi.EndpointReferenceContextImpl;
import org.apache.ode.jbi.JbiMessageExchangeEventRouter;
import org.apache.ode.jbi.JbiMessageExchangeProcessor;
import org.apache.ode.jbi.MessageExchangeContextImpl;
import org.apache.ode.jbi.MyEndpointReference;
import org.apache.ode.jbi.OdeConfigProperties;
import org.apache.ode.jbi.OdeConsumer;
import org.apache.ode.jbi.OdeService;
import org.apache.ode.jbi.msgmap.Mapper;
import org.apache.ode.jbi.util.WSDLFlattener;
import org.apache.ode.scheduler.simple.SimpleScheduler;
import org.apache.ode.store.ProcessStoreImpl;
import org.w3c.dom.Document;

public final class OdeContext {
    private static final Log __log = LogFactory.getLog(OdeContext.class);
    public static final QName PM_SERVICE_NAME = new QName("http://www.apache.org/ode/pmapi", "ProcessManagementService");
    public static final String PM_PORT_NAME = "ProcessManagementPort";
    public static final QName IM_SERVICE_NAME = new QName("http://www.apache.org/ode/pmapi", "InstanceManagementService");
    public static final String IM_PORT_NAME = "InstanceManagementPort";
    private static OdeContext __self;
    private ComponentContext _context;
    private Map<QName, Document> _descriptorCache = new ConcurrentHashMap<QName, Document>();
    private ArrayList<Mapper> _mappers = new ArrayList();
    private Map<String, Mapper> _mappersByClassName = new HashMap<String, Mapper>();
    OdeConsumer _consumer;
    JbiMessageExchangeProcessor _jbiMessageExchangeProcessor = new JbiMessageExchangeEventRouter(this);
    BpelServerImpl _server;
    EndpointReferenceContextImpl _eprContext;
    MessageExchangeContextImpl _mexContext;
    SimpleScheduler _scheduler;
    ExecutorService _executorService;
    BpelDAOConnectionFactory _daocf;
    OdeConfigProperties _config;
    DataSource _dataSource;
    ProcessStoreImpl _store;
    ServiceEndpoint _processManagementEndpoint;
    ServiceEndpoint _instanceManagementEndpoint;
    JbiMessageExchangeProcessor _processManagementProcessor;
    JbiMessageExchangeProcessor _instanceManagementProcessor;
    ProcessManagement _processManagement;
    InstanceManagement _instanceManagement;
    private Map<Endpoint, OdeService> _activeOdeServices = new ConcurrentHashMap<Endpoint, OdeService>();
    private Map<OdeService, EndpointReference> _serviceEprMap = new HashMap<OdeService, EndpointReference>();

    public DeliveryChannel getChannel() {
        DeliveryChannel chnl = null;
        if (this._context != null) {
            try {
                chnl = this._context.getDeliveryChannel();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return chnl;
    }

    public void setContext(ComponentContext ctx) {
        this._context = ctx;
    }

    public ComponentContext getContext() {
        return this._context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OdeContext getInstance() {
        Class<OdeContext> clazz = OdeContext.class;
        synchronized (OdeContext.class) {
            if (__self == null) {
                __self = new OdeContext();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return __self;
        }
    }

    public void addEndpointDoc(QName svcname, Document df) {
        this._descriptorCache.put(svcname, df);
    }

    public Document getServiceDescription(QName svcName) {
        return this._descriptorCache.get(svcName);
    }

    public TransactionManager getTransactionManager() {
        return (TransactionManager)this.getContext().getTransactionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MyEndpointReference activateEndpoint(QName pid, Endpoint endpoint) throws Exception {
        OdeService service;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Activate endpoint: " + endpoint));
        }
        if ((service = this._activeOdeServices.get(endpoint)) == null) {
            service = new OdeService(this, endpoint);
        }
        try {
            ProcessConf pc = this._store.getProcessConfiguration(pid);
            InputStream is = pc.getCBPInputStream();
            OProcess compiledProcess = null;
            try {
                Serializer ofh = new Serializer(is);
                compiledProcess = ofh.readOProcess();
            }
            finally {
                is.close();
            }
            QName portType = null;
            for (Map.Entry provide : pc.getProvideEndpoints().entrySet()) {
                if (!((Endpoint)provide.getValue()).equals((Object)endpoint)) continue;
                OPartnerLink plink = compiledProcess.getPartnerLink((String)provide.getKey());
                portType = plink.myRolePortType.getQName();
                break;
            }
            if (portType == null) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)"Could not find PortType for endpoint");
                }
            } else {
                Definition def = pc.getDefinitionForService(endpoint.serviceName);
                if (def == null) {
                    __log.debug((Object)("Could not find definition for service: " + endpoint.serviceName));
                } else {
                    def = new WSDLFlattener(def).getDefinition(portType);
                    Document doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(def);
                    this.addEndpointDoc(endpoint.serviceName, doc);
                }
            }
        }
        catch (Exception e) {
            __log.warn((Object)"Exception during endpoint activation", (Throwable)e);
        }
        MyEndpointReference myepr = new MyEndpointReference(service);
        service.activate();
        this._activeOdeServices.put(endpoint, service);
        this._serviceEprMap.put(service, myepr);
        return myepr;
    }

    public synchronized void deactivateEndpoint(Endpoint endpoint) throws Exception {
        OdeService svc = this._activeOdeServices.get(endpoint);
        if (svc != null) {
            this._serviceEprMap.remove(svc);
            svc.deactivate();
            if (svc.getCount() < 1) {
                this._activeOdeServices.remove(endpoint);
            }
        }
    }

    public OdeService getService(Endpoint endpoint) {
        return this._activeOdeServices.get(endpoint);
    }

    public OdeService getService(QName serviceName) {
        for (Map.Entry<Endpoint, OdeService> e : this._activeOdeServices.entrySet()) {
            if (!e.getKey().serviceName.equals(serviceName)) continue;
            return e.getValue();
        }
        return null;
    }

    public Mapper findMapper(NormalizedMessage nmsMsg, Operation op) {
        ArrayList<Mapper> maybe = new ArrayList<Mapper>();
        for (Mapper m : this._mappers) {
            Mapper.Recognized result = m.isRecognized(nmsMsg, op);
            switch (result) {
                case TRUE: {
                    return m;
                }
                case FALSE: {
                    break;
                }
                case UNSURE: {
                    maybe.add(m);
                }
            }
        }
        if (maybe.size() == 0) {
            return null;
        }
        if (maybe.size() == 1) {
            return (Mapper)maybe.get(0);
        }
        __log.warn((Object)("Multiple mappers may match input message for operation " + op.getName()));
        return (Mapper)maybe.get(0);
    }

    public Mapper getMapper(String name) {
        return this._mappersByClassName.get(name);
    }

    public void registerMapper(Mapper mapper) {
        this._mappers.add(mapper);
        this._mappersByClassName.put(mapper.getClass().getName(), mapper);
    }

    public Mapper getDefaultMapper() {
        return this._mappers.get(0);
    }

    void activatePMAPIs() throws JBIException {
        ProcessAndInstanceManagementImpl pm = new ProcessAndInstanceManagementImpl((BpelServer)this._server, (ProcessStore)this._store);
        this._processManagement = pm;
        this._instanceManagement = pm;
        this._processManagementEndpoint = this.getContext().activateEndpoint(PM_SERVICE_NAME, PM_PORT_NAME);
        this._instanceManagementEndpoint = this.getContext().activateEndpoint(IM_SERVICE_NAME, IM_PORT_NAME);
        this._processManagementProcessor = new DynamicMessageExchangeProcessor<ProcessAndInstanceManagementImpl>(pm, this.getChannel());
        this._instanceManagementProcessor = new DynamicMessageExchangeProcessor<ProcessAndInstanceManagementImpl>(pm, this.getChannel());
    }

    void deactivatePMAPIs() throws JBIException {
        if (this._processManagementEndpoint != null) {
            try {
                this.getContext().deactivateEndpoint(this._processManagementEndpoint);
            }
            catch (Exception e) {
                __log.error((Object)"Error deactivating ProcessManagement service", (Throwable)e);
            }
        }
        if (this._instanceManagementEndpoint != null) {
            try {
                this.getContext().deactivateEndpoint(this._instanceManagementEndpoint);
            }
            catch (Exception e) {
                __log.error((Object)"Error deactivating InstanceManagement service", (Throwable)e);
            }
        }
    }

    public long calculateSizeOfService(EndpointReference epr) {
        if (epr != null) {
            for (OdeService odeService : this._serviceEprMap.keySet()) {
                EndpointReference serviceEpr = this._serviceEprMap.get(odeService);
                if (serviceEpr == null || !epr.equals(serviceEpr)) continue;
                return SizingAgent.deepSizeOf((Object)odeService);
            }
        }
        return 0L;
    }
}

