/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi;

import java.util.HashMap;
import java.util.Map;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.jbi.Messages;
import org.apache.ode.jbi.OdeContext;
import org.apache.ode.jbi.OdeServiceUnit;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OdeSUManager
implements ServiceUnitManager {
    private static final Log __log = LogFactory.getLog(OdeSUManager.class);
    private static final Messages __msgs = (Messages)Messages.getMessages(Messages.class);
    private static final String XMLNS_JBI_MGMT = "http://java.sun.com/xml/ns/jbi/management-message";
    private OdeContext _ode;
    private Map<String, OdeServiceUnit> _serviceUnits = new HashMap<String, OdeServiceUnit>();

    public OdeSUManager(OdeContext odeContext) {
        this._ode = odeContext;
    }

    public synchronized String deploy(String serviceUnitID, String serviceUnitRootPath) throws DeploymentException {
        __log.trace((Object)("deploy: id=" + serviceUnitID + ", path=" + serviceUnitRootPath));
        OdeServiceUnit su = new OdeServiceUnit(this._ode, serviceUnitID, serviceUnitRootPath);
        try {
            su.deploy();
        }
        catch (Exception ex) {
            __log.error((Object)__msgs.msgServiceUnitDeployFailed(serviceUnitID));
            return this.makeStatusMessage("deploy", "FAILED");
        }
        return this.makeStatusMessage("deploy", "SUCCESS");
    }

    public synchronized void init(String serviceUnitID, String serviceUnitRootPath) throws DeploymentException {
        __log.trace((Object)("init called for " + serviceUnitID));
        if (this._serviceUnits.containsKey(serviceUnitID)) {
            __log.debug((Object)("odd, init() called for su " + serviceUnitID + ", but it is already init()ed"));
            return;
        }
        try {
            OdeServiceUnit su = new OdeServiceUnit(this._ode, serviceUnitID, serviceUnitRootPath);
            su.init();
            this._serviceUnits.put(serviceUnitID, su);
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgServiceUnitInitFailed(serviceUnitID);
            __log.error((Object)errmsg, (Throwable)ex);
            throw new DeploymentException(errmsg, (Throwable)ex);
        }
    }

    public synchronized void shutDown(String serviceUnitID) throws DeploymentException {
        __log.trace((Object)("shutDown called for " + serviceUnitID));
        OdeServiceUnit su = this._serviceUnits.remove(serviceUnitID);
        if (su == null) {
            return;
        }
        try {
            su.shutdown();
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgServiceUnitShutdownFailed(serviceUnitID);
            __log.error((Object)errmsg, (Throwable)ex);
            throw new DeploymentException(errmsg, (Throwable)ex);
        }
    }

    public synchronized void start(String serviceUnitID) throws DeploymentException {
        __log.trace((Object)("start called for " + serviceUnitID));
        OdeServiceUnit su = this._serviceUnits.get(serviceUnitID);
        if (su == null) {
            String errmsg = "Unexpected state; start() called before init()";
            IllegalStateException ex = new IllegalStateException(errmsg);
            __log.error((Object)errmsg, (Throwable)ex);
            throw new DeploymentException(errmsg, (Throwable)ex);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(su.getConfigurationClassLoader());
            su.start();
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgServiceUnitStartFailed(serviceUnitID);
            __log.error((Object)errmsg, (Throwable)ex);
            throw new DeploymentException(errmsg, (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public synchronized void stop(String serviceUnitID) throws DeploymentException {
        __log.trace((Object)("stop called for " + serviceUnitID));
        OdeServiceUnit su = this._serviceUnits.get(serviceUnitID);
        if (su == null) {
            String errmsg = "Unexpected state; stop() called before init()";
            IllegalStateException ex = new IllegalStateException(errmsg);
            __log.error((Object)errmsg, (Throwable)ex);
            throw new DeploymentException(errmsg, (Throwable)ex);
        }
        try {
            su.stop();
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgServiceUnitStopFailed(serviceUnitID);
            __log.error((Object)errmsg, (Throwable)ex);
            throw new DeploymentException(errmsg, (Throwable)ex);
        }
    }

    public synchronized String undeploy(String serviceUnitID, String serviceUnitRootPath) throws DeploymentException {
        __log.trace((Object)("undeploy: id=" + serviceUnitID + ", path=" + serviceUnitRootPath));
        OdeServiceUnit su = new OdeServiceUnit(this._ode, serviceUnitID, serviceUnitRootPath);
        try {
            su.undeploy();
        }
        catch (Exception ex) {
            __log.error((Object)__msgs.msgServiceUnitDeployFailed(serviceUnitID));
            return this.makeStatusMessage("undeploy", "FAILED");
        }
        return this.makeStatusMessage("undeploy", "SUCCESS");
    }

    private String makeStatusMessage(String task, String status) {
        Document doc;
        try {
            DocumentBuilderFactory dbf = XMLParserUtils.getDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.newDocument();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        Element elem = doc.createElementNS(XMLNS_JBI_MGMT, "component-task-result");
        doc.appendChild(elem);
        Element compNameElem = doc.createElementNS(XMLNS_JBI_MGMT, "component-name");
        elem.appendChild(compNameElem);
        Element compTaskRsltDtlsElem = doc.createElementNS(XMLNS_JBI_MGMT, "component-task-result-details");
        elem.appendChild(compTaskRsltDtlsElem);
        Element taskRsltDtlsElem = doc.createElementNS(XMLNS_JBI_MGMT, "task-result-details");
        compTaskRsltDtlsElem.appendChild(taskRsltDtlsElem);
        Element taskId = doc.createElementNS(XMLNS_JBI_MGMT, "task-id");
        taskRsltDtlsElem.appendChild(taskId);
        Element taskResult = doc.createElementNS(XMLNS_JBI_MGMT, "task-result");
        taskRsltDtlsElem.appendChild(taskResult);
        compNameElem.appendChild(doc.createTextNode(this._ode.getContext().getComponentName()));
        taskId.appendChild(doc.createTextNode(task));
        taskResult.appendChild(doc.createTextNode(status));
        return DOMUtils.domToString((Node)elem);
    }
}

