/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.jbi.OdeContext;

public class Receiver
implements Runnable {
    private static final Log __log = LogFactory.getLog(Receiver.class);
    private static final long ACCEPT_TIMEOUT = 1L;
    private static final long THREADPOOL_SHUTDOWN_TIMEOUT = 10L;
    private static final int THREADPOOL_SIZE = 8;
    private OdeContext _odeContext = null;
    private DeliveryChannel _channel = null;
    private AtomicBoolean _isRunning = new AtomicBoolean(false);
    private AtomicBoolean _isStarted = new AtomicBoolean(false);
    private Thread _thread;
    private ExecutorService _executorService;

    public Receiver(OdeContext context) {
        this._odeContext = context;
        this._thread = new Thread(this);
        this._executorService = Executors.newFixedThreadPool(8);
    }

    public void start() {
        if (!this._isStarted.compareAndSet(false, true)) {
            throw new IllegalStateException("Receiver cannot be restarted.");
        }
        this._isRunning.set(true);
        this._thread.start();
    }

    public void cease() {
        if (!this._isStarted.get()) {
            return;
        }
        __log.info((Object)"Receiver is ceasing.");
        if (this._isRunning.compareAndSet(true, false)) {
            try {
                this._thread.join(3L * TimeUnit.SECONDS.toMillis(1L));
                if (this._thread.isAlive()) {
                    __log.warn((Object)"Receiver thread is not dying gracefully; interrupting.");
                    this._thread.interrupt();
                }
                this._thread.join(3L * TimeUnit.SECONDS.toMillis(1L));
                if (this._thread.isAlive()) {
                    __log.fatal((Object)"Receiver thread is not dying gracefully despite our insistence!.");
                }
                this._executorService.shutdown();
                if (!this._executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                    __log.warn((Object)"Problem shutting down ExecutorService - trying harder.");
                    List<Runnable> outstanding = this._executorService.shutdownNow();
                    if (outstanding != null && !outstanding.isEmpty()) {
                        __log.warn((Object)("Cancelled " + outstanding.size() + " in-flight threads."));
                    }
                }
            }
            catch (InterruptedException ie) {
                __log.warn((Object)"Interrupted during cease(): ", (Throwable)ie);
            }
            this._executorService.shutdown();
            __log.info((Object)"Receiver ceased.");
            this._executorService = null;
            this._thread = null;
            this._odeContext = null;
            this._channel = null;
        }
    }

    public void run() {
        __log.info((Object)"Receiver is executing.");
        try {
            this._channel = this._odeContext.getContext().getDeliveryChannel();
            if (this._channel == null) {
                __log.fatal((Object)"No Channel!");
                return;
            }
        }
        catch (MessagingException ex) {
            __log.fatal((Object)"Error getting channel! ", (Throwable)ex);
            return;
        }
        while (this._isRunning.get()) {
            try {
                final MessageExchange messageExchange = this._channel.accept(TimeUnit.SECONDS.toMillis(1L));
                if (messageExchange == null) continue;
                if (__log.isTraceEnabled()) {
                    __log.trace((Object)("Got JBI message for endpoint: " + messageExchange.getEndpoint().getEndpointName()));
                }
                if (this._isRunning.get()) {
                    if (__log.isTraceEnabled()) {
                        __log.trace((Object)("Scheduling execution of " + messageExchange.getExchangeId()));
                    }
                    this._executorService.submit(new Runnable(){

                        public void run() {
                            try {
                                ((Receiver)Receiver.this)._odeContext._jbiMessageExchangeProcessor.onJbiMessageExchange(messageExchange);
                            }
                            catch (Throwable t) {
                                __log.error((Object)"Error processing JBI message.", t);
                            }
                        }
                    });
                    continue;
                }
                __log.warn((Object)("Skipping processing of message exchange " + messageExchange.getExchangeId() + "; component no longer active."));
            }
            catch (MessagingException mex) {
                if (this._isRunning.get()) {
                    __log.warn((Object)"Receiver exiting due to MessagingException:", (Throwable)mex);
                    break;
                }
                __log.info((Object)"Receiver finished.");
                break;
            }
            catch (Exception ex) {
                if (!this._isRunning.get()) {
                    __log.info((Object)"Receiver finished.");
                    break;
                }
                __log.warn((Object)"Caught unexpected Exception: ", (Throwable)ex);
                return;
            }
        }
        __log.info((Object)"Receiver finished.");
    }
}

