/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi.msgmap;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.ode.jbi.msgmap.BaseXmlMapper;
import org.apache.ode.jbi.msgmap.Mapper;
import org.apache.ode.jbi.msgmap.MessageTranslationException;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiWsdl11WrapperMapper
extends BaseXmlMapper
implements Mapper {
    public static final String URI_WSDL11_WRAPPER = "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper";
    public static final QName WSDL11_W_MESSAGE = new QName("http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper", "message");

    @Override
    public Mapper.Recognized isRecognized(NormalizedMessage nmsMsg, Operation op) {
        Element srcel;
        try {
            srcel = this.parse(nmsMsg.getContent());
        }
        catch (MessageTranslationException e) {
            if (this.__log.isDebugEnabled()) {
                this.__log.debug((Object)"Exception parsing NMS message.", (Throwable)e);
            }
            return Mapper.Recognized.FALSE;
        }
        QName srcName = new QName(srcel.getNamespaceURI(), srcel.getLocalName());
        return WSDL11_W_MESSAGE.equals(srcName) ? Mapper.Recognized.TRUE : Mapper.Recognized.FALSE;
    }

    @Override
    public void toNMS(NormalizedMessage nmsMsg, org.apache.ode.bpel.iapi.Message odeMsg, Message msgdef, QName fault) throws MessagingException {
        if (msgdef == null) {
            throw new NullPointerException("Null MessageDef");
        }
        if (odeMsg == null) {
            throw new NullPointerException("Null src.");
        }
        if (this.__log.isTraceEnabled()) {
            this.__log.trace((Object)("toNMS(odeMsg=" + odeMsg + ")"));
        }
        Element srcMsgEl = odeMsg.getMessage();
        Document doc = this.newDocument();
        Element dstMsgEl = doc.createElementNS(URI_WSDL11_WRAPPER, "message");
        doc.appendChild(dstMsgEl);
        dstMsgEl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:msgns", odeMsg.getType().getNamespaceURI());
        dstMsgEl.setAttribute("version", "1.0");
        dstMsgEl.setAttribute("type", "msgns:" + odeMsg.getType().getLocalPart());
        Element srcPartEl = DOMUtils.getFirstChildElement((Element)srcMsgEl);
        while (srcPartEl != null) {
            Element dstPartEl = doc.createElementNS(URI_WSDL11_WRAPPER, "part");
            dstMsgEl.appendChild(dstPartEl);
            for (Node srccontent = srcPartEl.getFirstChild(); srccontent != null; srccontent = srccontent.getNextSibling()) {
                dstPartEl.appendChild(doc.importNode(srccontent, true));
            }
            srcPartEl = DOMUtils.getNextSiblingElement((Element)srcPartEl);
        }
        nmsMsg.setContent((Source)new DOMSource(doc));
    }

    @Override
    public void toODE(org.apache.ode.bpel.iapi.Message dest, NormalizedMessage src, Message msgdef) throws MessageTranslationException {
        if (msgdef == null) {
            throw new NullPointerException("Null MessageDef");
        }
        if (dest == null) {
            throw new NullPointerException("Null dest.");
        }
        if (src == null) {
            throw new NullPointerException("Null src.");
        }
        if (this.__log.isTraceEnabled()) {
            this.__log.trace((Object)("convertMessage<toODE>(dest=" + dest + ",src=" + src));
        }
        Element srcel = this.parse(src.getContent());
        Document odemsgdoc = this.newDocument();
        Element odemsg = odemsgdoc.createElement("message");
        odemsgdoc.appendChild(odemsg);
        List expectedParts = msgdef.getOrderedParts(null);
        Element srcpart = DOMUtils.getFirstChildElement((Element)srcel);
        for (int i = 0; i < expectedParts.size(); ++i) {
            Part pdef = (Part)expectedParts.get(i);
            Element p = odemsgdoc.createElement(pdef.getName());
            odemsg.appendChild(p);
            if (srcpart != null) {
                NodeList nl = srcpart.getChildNodes();
                for (int j = 0; j < nl.getLength(); ++j) {
                    p.appendChild(odemsgdoc.importNode(nl.item(j), true));
                }
                srcpart = DOMUtils.getNextSiblingElement((Element)srcpart);
                continue;
            }
            this.__log.error((Object)("Improperly formatted message, missing part: " + pdef.getName()));
        }
        dest.setMessage(odemsg);
    }

    @Override
    public javax.wsdl.Fault toFaultType(Fault jbiFlt, Collection<javax.wsdl.Fault> faults) throws MessageTranslationException {
        if (jbiFlt == null) {
            throw new NullPointerException("Null jbiFlt.");
        }
        if (faults == null) {
            throw new NullPointerException("Null faults.");
        }
        if (this.__log.isTraceEnabled()) {
            this.__log.trace((Object)("toFaultType(jbiFlt=" + jbiFlt + ")"));
        }
        QName partElName = new QName(URI_WSDL11_WRAPPER, "part");
        LinkedList<QName> eltypes = new LinkedList<QName>();
        Element srcel = this.parse(jbiFlt.getContent());
        for (Node n = srcel.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            QName elName = new QName(n.getNamespaceURI(), n.getLocalName());
            if (!elName.equals(partElName)) {
                String err = "Invalid NMS message format, expected " + partElName + " but found " + elName;
                this.__log.error((Object)err);
                throw new MessageTranslationException(err);
            }
            Element pdata = DOMUtils.getFirstChildElement((Element)((Element)n));
            if (pdata == null) {
                eltypes.add(null);
                continue;
            }
            eltypes.add(new QName(pdata.getNamespaceURI(), pdata.getLocalName()));
        }
        block1: for (javax.wsdl.Fault f : faults) {
            if (f.getMessage() == null && eltypes.isEmpty()) {
                return f;
            }
            if (f.getMessage().getParts().size() != eltypes.size()) continue;
            List expectedParts = f.getMessage().getOrderedParts(null);
            int i = 0;
            for (Part p : expectedParts) {
                if (eltypes.size() <= i) continue block1;
                QName etype = (QName)eltypes.get(i++);
                if (p.getElementName() == null ^ etype == null) continue block1;
                if ((etype != null || p.getElementName() != null) && !etype.equals(p.getElementName())) continue;
            }
            return f;
        }
        return null;
    }
}

