/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.wsdl.OperationType;
import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.InvokeGeneratorMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.Correlation;
import org.apache.ode.bpel.compiler.bom.InvokeActivity;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OInvoke;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InvokeGenerator
extends DefaultActivityGenerator {
    private static final CommonCompilationMessages __cmsgsGeneral = (CommonCompilationMessages)MessageBundle.getMessages(CommonCompilationMessages.class);
    private static final InvokeGeneratorMessages __imsgs = (InvokeGeneratorMessages)MessageBundle.getMessages(InvokeGeneratorMessages.class);

    InvokeGenerator() {
    }

    @Override
    public OActivity newInstance(Activity src) {
        return new OInvoke(this._context.getOProcess(), this._context.getCurrent());
    }

    @Override
    public void compile(OActivity output, Activity srcx) {
        InvokeActivity src = (InvokeActivity)srcx;
        final OInvoke oinvoke = (OInvoke)output;
        oinvoke.partnerLink = this._context.resolvePartnerLink(src.getPartnerLink());
        oinvoke.operation = this._context.resolvePartnerRoleOperation(oinvoke.partnerLink, src.getOperation());
        assert (oinvoke.operation.getInput() != null);
        assert (oinvoke.operation.getInput().getMessage() != null);
        if (oinvoke.operation.getInput() != null && oinvoke.operation.getInput().getMessage() != null && oinvoke.operation.getInput().getMessage().getParts().size() > 0) {
            if (src.getInputVar() == null) {
                throw new CompilationException(__imsgs.errInvokeNoInputMessageForInputOp(oinvoke.operation.getName()));
            }
            oinvoke.inputVar = this._context.resolveMessageVariable(src.getInputVar(), oinvoke.operation.getInput().getMessage().getQName());
        }
        if (oinvoke.operation.getOutput() != null && oinvoke.operation.getOutput().getMessage() != null) {
            if (src.getOutputVar() == null) {
                throw new CompilationException(__imsgs.errInvokeNoOutputMessageForOutputOp(oinvoke.operation.getName()));
            }
            oinvoke.outputVar = this._context.resolveMessageVariable(src.getOutputVar(), oinvoke.operation.getOutput().getMessage().getQName());
        }
        List<Correlation> correlations = src.getCorrelations();
        List incorrelations = (List)CollectionsX.filter(new ArrayList(), correlations, (MemberOfFunction)new MemberOfFunction<Correlation>(){

            public boolean isMember(Correlation o) {
                return o.getPattern() == Correlation.CorrelationPattern.IN;
            }
        });
        List outcorrelations = (List)CollectionsX.filter(new ArrayList(), correlations, (MemberOfFunction)new MemberOfFunction<Correlation>(){

            public boolean isMember(Correlation o) {
                return o.getPattern() == Correlation.CorrelationPattern.OUT || o.getPattern() == Correlation.CorrelationPattern.UNSET && oinvoke.operation.getStyle() == OperationType.ONE_WAY;
            }
        });
        List inoutcorrelations = (List)CollectionsX.filter(new ArrayList(), correlations, (MemberOfFunction)new MemberOfFunction<Correlation>(){

            public boolean isMember(Correlation o) {
                return o.getPattern() == Correlation.CorrelationPattern.INOUT;
            }
        });
        if (oinvoke.inputVar != null) {
            this.doCorrelations(outcorrelations, oinvoke.inputVar, oinvoke.assertCorrelationsInput, oinvoke.initCorrelationsInput, oinvoke.joinCorrelationsInput);
            this.doCorrelations(inoutcorrelations, oinvoke.inputVar, oinvoke.assertCorrelationsInput, oinvoke.initCorrelationsInput, oinvoke.joinCorrelationsInput);
        }
        if (oinvoke.outputVar != null) {
            this.doCorrelations(incorrelations, oinvoke.outputVar, oinvoke.assertCorrelationsOutput, oinvoke.initCorrelationsOutput, oinvoke.joinCorrelationsOutput);
            this.doCorrelations(inoutcorrelations, oinvoke.outputVar, oinvoke.assertCorrelationsOutput, oinvoke.initCorrelationsOutput, oinvoke.joinCorrelationsOutput);
        }
    }

    private void doCorrelations(List<Correlation> correlations, OScope.Variable var, Collection<OScope.CorrelationSet> assertCorrelations, Collection<OScope.CorrelationSet> initCorrelations, Collection<OScope.CorrelationSet> joinCorrelations) {
        HashSet<String> csetNames = new HashSet<String>();
        for (Correlation correlation : correlations) {
            if (csetNames.contains(correlation.getCorrelationSet())) {
                throw new CompilationException(__cmsgsGeneral.errDuplicateUseCorrelationSet(correlation.getCorrelationSet()));
            }
            OScope.CorrelationSet cset = this._context.resolveCorrelationSet(correlation.getCorrelationSet());
            switch (correlation.getInitiate()) {
                case NO: {
                    assertCorrelations.add(cset);
                    break;
                }
                case YES: {
                    initCorrelations.add(cset);
                    break;
                }
                case JOIN: {
                    cset.hasJoinUseCases = true;
                    joinCorrelations.add(cset);
                }
            }
            for (OProcess.OProperty property : cset.properties) {
                try {
                    this._context.resolvePropertyAlias(var, property.name);
                }
                catch (CompilationException ce) {
                    if (ce.getCompilationMessage().source == null) {
                        ce.getCompilationMessage().source = correlation;
                    }
                    throw ce;
                }
            }
            csetNames.add(correlation.getCorrelationSet());
        }
    }
}

