/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.iapi;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.utils.CronExpression;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ProcessConf {
    public QName getProcessId();

    public QName getType();

    public long getVersion();

    public boolean isTransient();

    public InputStream getCBPInputStream();

    public long getCBPFileSize();

    public String getBpelDocument();

    public URI getBaseURI();

    public Date getDeployDate();

    public String getDeployer();

    public ProcessState getState();

    public List<File> getFiles();

    public Map<QName, Node> getProcessProperties();

    public String getPackage();

    public Definition getDefinitionForService(QName var1);

    public Definition getDefinitionForPortType(QName var1);

    public Map<String, Endpoint> getProvideEndpoints();

    public Map<String, Endpoint> getInvokeEndpoints();

    public boolean isSharedService(QName var1);

    public List<Element> getExtensionElement(QName var1);

    public boolean isEventEnabled(List<String> var1, BpelEvent.TYPE var2);

    public Map<String, String> getEndpointProperties(EndpointReference var1);

    public boolean isCleanupCategoryEnabled(boolean var1, CLEANUP_CATEGORY var2);

    public Set<CLEANUP_CATEGORY> getCleanupCategories(boolean var1);

    public List<CronJob> getCronJobs();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CleanupInfo {
        private List<String> _filters = new ArrayList<String>();
        private final Set<CLEANUP_CATEGORY> _categories = EnumSet.noneOf(CLEANUP_CATEGORY.class);

        public void setFilters(List<String> filters) {
            this._filters = filters;
        }

        public List<String> getFilters() {
            return this._filters;
        }

        public Set<CLEANUP_CATEGORY> getCategories() {
            return this._categories;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("CleanupInfo: filters=");
            buf.append(this._filters);
            buf.append(", categories=");
            buf.append(this._categories);
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CronJob {
        private CronExpression _cronExpression;
        private final List<Map<String, Object>> runnableDetailList = new ArrayList<Map<String, Object>>();

        public void setCronExpression(CronExpression _cronExpression) {
            this._cronExpression = _cronExpression;
        }

        public CronExpression getCronExpression() {
            return this._cronExpression;
        }

        public List<Map<String, Object>> getRunnableDetailList() {
            return this.runnableDetailList;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Cron[");
            buf.append(this._cronExpression);
            buf.append("] ");
            buf.append(this.runnableDetailList);
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CLEANUP_CATEGORY {
        INSTANCE,
        VARIABLES,
        MESSAGES,
        CORRELATIONS,
        EVENTS;


        public static CLEANUP_CATEGORY fromString(String lowerCase) {
            return CLEANUP_CATEGORY.valueOf(CLEANUP_CATEGORY.class, lowerCase.toUpperCase());
        }
    }
}

