/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.om.Name11Checker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.XMLParserUtils;
import org.apache.ode.utils.sax.LoggingErrorHandler;
import org.apache.xerces.dom.DOMOutputImpl;
import org.apache.xml.serialize.DOMSerializerImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.ls.LSOutput;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMUtils {
    private static Log __log = LogFactory.getLog(DOMUtils.class);
    public static final String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static ThreadLocal<Transformer> __txers = new ThreadLocal();
    private static ThreadLocal<DocumentBuilder> __builders = new ThreadLocal();
    private static TransformerFactory _transformerFactory = TransformerFactory.newInstance();
    private static DocumentBuilderFactory __documentBuilderFactory;
    public static final String WSDL_NS = "http://schemas.xmlsoap.org/wsdl/";
    public static final String WSDL_ROOT_ELEMENT = "definitions";
    public static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    public static final String XSD_ROOT_ELEMENT = "schema";

    private static void initDocumentBuilderFactory() {
        DocumentBuilderFactory f = XMLParserUtils.getDocumentBuilderFactory();
        f.setNamespaceAware(true);
        __documentBuilderFactory = f;
    }

    public static String getAttribute(Element el, String attrName) {
        String sRet = null;
        Attr attr = el.getAttributeNode(attrName);
        if (attr != null) {
            sRet = attr.getValue();
        }
        return sRet;
    }

    public static String prettyPrint(Element e) throws IOException {
        OutputFormat format = new OutputFormat(e.getOwnerDocument());
        format.setLineWidth(65);
        format.setIndenting(true);
        format.setIndent(2);
        StringWriter out = new StringWriter();
        XMLSerializer serializer = new XMLSerializer((Writer)out, format);
        serializer.serialize(e);
        return out.toString();
    }

    public static String getAttributeNS(Element el, String namespaceURI, String localPart) {
        String sRet = null;
        Attr attr = el.getAttributeNodeNS(namespaceURI, localPart);
        if (attr != null) {
            sRet = attr.getValue();
        }
        return sRet;
    }

    public static String getChildCharacterData(Element parentEl) {
        if (parentEl == null) {
            return null;
        }
        StringBuffer strBuf = new StringBuffer();
        for (Node tempNode = parentEl.getFirstChild(); tempNode != null; tempNode = tempNode.getNextSibling()) {
            switch (tempNode.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData charData = (CharacterData)tempNode;
                    strBuf.append(charData.getData());
                }
            }
        }
        return strBuf.toString();
    }

    public static Element getElementByID(Element el, String id) {
        if (el == null) {
            return null;
        }
        String thisId = el.getAttribute("id");
        if (id.equals(thisId)) {
            return el;
        }
        NodeList list = el.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element ret;
            Node node = list.item(i);
            if (!(node instanceof Element) || (ret = DOMUtils.getElementByID((Element)node, id)) == null) continue;
            return ret;
        }
        return null;
    }

    public static Element getFirstChildElement(Element elem) {
        return (Element)DOMUtils.findChildByType(elem, 1);
    }

    public static String getNamespaceURIFromPrefix(Node context, String prefix) {
        short nodeType = context.getNodeType();
        Node tempNode = null;
        switch (nodeType) {
            case 2: {
                tempNode = ((Attr)context).getOwnerElement();
                break;
            }
            case 1: {
                tempNode = context;
                break;
            }
            default: {
                tempNode = context.getParentNode();
            }
        }
        while (tempNode != null && tempNode.getNodeType() == 1) {
            String namespaceURI;
            Element tempEl = (Element)tempNode;
            String string = namespaceURI = prefix == null ? DOMUtils.getAttribute(tempEl, "xmlns") : DOMUtils.getAttributeNS(tempEl, NS_URI_XMLNS, prefix);
            if (namespaceURI != null) {
                return namespaceURI;
            }
            tempNode = tempEl.getParentNode();
        }
        return null;
    }

    public static Element getNextSiblingElement(Element elem) {
        for (Node n = elem.getNextSibling(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public static QName getQualifiedAttributeValue(Element el, String attrName) throws IllegalArgumentException {
        String attrValue = DOMUtils.getAttribute(el, attrName);
        if (attrValue != null) {
            int index = attrValue.indexOf(58);
            String attrValuePrefix = index != -1 ? attrValue.substring(0, index) : null;
            String attrValueLocalPart = attrValue.substring(index + 1);
            String attrValueNamespaceURI = DOMUtils.getNamespaceURIFromPrefix(el, attrValuePrefix);
            if (attrValueNamespaceURI != null) {
                return new QName(attrValueNamespaceURI, attrValueLocalPart);
            }
            throw new IllegalArgumentException("Unable to determine namespace of '" + (attrValuePrefix != null ? attrValuePrefix + ":" : "") + attrValueLocalPart + "'.");
        }
        return null;
    }

    public static int countKids(Element elem, short nodeType) {
        int nkids = 0;
        for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != nodeType) continue;
            ++nkids;
        }
        return nkids;
    }

    public static Map<String, String> getParentNamespaces(Element el) {
        HashMap<String, String> pref = new HashMap<String, String>();
        Map<String, String> mine = DOMUtils.getMyNamespaces(el);
        for (Node n = el.getParentNode(); n != null && n.getNodeType() != 9; n = n.getParentNode()) {
            if (!(n instanceof Element)) continue;
            Element l = (Element)n;
            NamedNodeMap nnm = l.getAttributes();
            int len = nnm.getLength();
            for (int i = 0; i < len; ++i) {
                Attr a = (Attr)nnm.item(i);
                if (!DOMUtils.isNSAttribute(a)) continue;
                String key = DOMUtils.getNSPrefixFromNSAttr(a);
                String uri = a.getValue();
                if (pref.containsKey(key) || mine.containsKey(key)) continue;
                pref.put(key, uri);
            }
        }
        return pref;
    }

    public static NSContext getMyNSContext(Element el) {
        NSContext ns = new NSContext();
        ns.register(DOMUtils.getParentNamespaces(el));
        ns.register(DOMUtils.getMyNamespaces(el));
        return ns;
    }

    public static Map<String, String> getMyNamespaces(Element el) {
        HashMap<String, String> mine = new HashMap<String, String>();
        NamedNodeMap nnm = el.getAttributes();
        int len = nnm.getLength();
        for (int i = 0; i < len; ++i) {
            Attr a = (Attr)nnm.item(i);
            if (!DOMUtils.isNSAttribute(a)) continue;
            mine.put(DOMUtils.getNSPrefixFromNSAttr(a), a.getValue());
        }
        return mine;
    }

    public static boolean isNSAttribute(Attr a) {
        assert (a != null);
        String s = a.getNamespaceURI();
        return s != null && s.equals(NS_URI_XMLNS);
    }

    public static String getNSPrefixFromNSAttr(Attr a) {
        assert (a != null);
        assert (DOMUtils.isNSAttribute(a));
        if (a.getPrefix() == null) {
            return "";
        }
        return a.getName().substring(a.getPrefix().length() + 1);
    }

    public static String domToString(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Cannot stringify null Node!");
        }
        String value = null;
        short nodeType = node.getNodeType();
        if (nodeType == 1 || nodeType == 9) {
            String parentEncoding;
            DOMSerializerImpl ser = new DOMSerializerImpl();
            ser.setParameter("namespaces", (Object)Boolean.TRUE);
            ser.setParameter("well-formed", (Object)Boolean.FALSE);
            ser.setParameter("validate", (Object)Boolean.FALSE);
            String usedEncoding = "UTF-8";
            Document parent = node.getOwnerDocument();
            if (parent != null && (parentEncoding = parent.getXmlEncoding()) != null) {
                usedEncoding = parentEncoding;
            }
            DOMOutputImpl out = new DOMOutputImpl();
            out.setEncoding(usedEncoding);
            StringWriter writer = new StringWriter(4096);
            out.setCharacterStream((Writer)writer);
            ser.write(node, (LSOutput)out);
            writer.flush();
            value = writer.toString();
        } else {
            value = node.getNodeValue();
        }
        return value;
    }

    public static void serialize(Element elmt, OutputStream ostr) {
        String parentEncoding;
        String usedEncoding = "UTF-8";
        Document parent = elmt.getOwnerDocument();
        if (parent != null && (parentEncoding = parent.getXmlEncoding()) != null) {
            usedEncoding = parentEncoding;
        }
        DOMOutputImpl out = new DOMOutputImpl();
        out.setEncoding(usedEncoding);
        DOMSerializerImpl ser = new DOMSerializerImpl();
        out.setByteStream(ostr);
        ser.write((Node)elmt, (LSOutput)out);
    }

    public static String domToStringLevel2(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Cannot stringify null Node!");
        }
        String value = null;
        short nodeType = node.getNodeType();
        if (nodeType == 1 || nodeType == 9) {
            DOMSerializerImpl ser = new DOMSerializerImpl();
            ser.setParameter("namespaces", (Object)Boolean.TRUE);
            ser.setParameter("well-formed", (Object)Boolean.FALSE);
            ser.setParameter("validate", (Object)Boolean.FALSE);
            DOMOutputImpl out = new DOMOutputImpl();
            out.setEncoding("UTF-8");
            StringWriter writer = new StringWriter(4096);
            out.setCharacterStream((Writer)writer);
            ser.write(node, (LSOutput)out);
            writer.flush();
            value = writer.toString();
        } else {
            value = node.getNodeValue();
        }
        return value;
    }

    public static Element findChildElementWithAttribute(Element elem, String attrName, String attrValue) {
        for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !attrValue.equals(DOMUtils.getAttribute((Element)n, attrName))) continue;
            return (Element)n;
        }
        return null;
    }

    public static Element stringToDOM(String s) throws SAXException, IOException {
        return DOMUtils.parse(new InputSource(new StringReader(s))).getDocumentElement();
    }

    public static boolean isWsdlDocument(Document d) {
        Element e = d.getDocumentElement();
        String uri = e.getNamespaceURI();
        String localName = e.getLocalName();
        if (uri == null || localName == null) {
            return false;
        }
        return uri.equals(WSDL_NS) && localName.equals(WSDL_ROOT_ELEMENT);
    }

    public static boolean isXmlSchemaDocument(Document d) {
        Element e = d.getDocumentElement();
        String uri = e.getNamespaceURI();
        String localName = e.getLocalName();
        if (uri == null || localName == null) {
            return false;
        }
        return uri.equals(XSD_NS) && localName.equals(XSD_ROOT_ELEMENT);
    }

    public static void pancakeNamespaces(Element el) {
        Map<String, String> ns = DOMUtils.getParentNamespaces(el);
        Document d = el.getOwnerDocument();
        assert (d != null);
        for (String key : ns.keySet()) {
            String uri = ns.get(key);
            Attr a = d.createAttributeNS(NS_URI_XMLNS, key.length() != 0 ? "xmlns:" + key : "xmlns");
            a.setValue(uri);
            el.setAttributeNodeNS(a);
        }
    }

    public static Document newDocument() {
        DocumentBuilder db = DOMUtils.getBuilder();
        return db.newDocument();
    }

    public static Document parse(InputStream inputStream) throws SAXException, IOException {
        return DOMUtils.parse(new InputSource(inputStream));
    }

    public static Document parse(InputSource inputSource) throws SAXException, IOException {
        DocumentBuilder db = DOMUtils.getBuilder();
        return db.parse(inputSource);
    }

    public static Document sourceToDOM(Source inputSource) throws IOException {
        try {
            StreamSource stream;
            Node node;
            InputSource sax;
            if (inputSource instanceof SAXSource && ((sax = ((SAXSource)inputSource).getInputSource()).getCharacterStream() != null || sax.getByteStream() != null)) {
                return DOMUtils.parse(((SAXSource)inputSource).getInputSource());
            }
            if (inputSource instanceof DOMSource && (node = ((DOMSource)inputSource).getNode()) != null) {
                return DOMUtils.toDOMDocument(node);
            }
            if (inputSource instanceof StreamSource && ((stream = (StreamSource)inputSource).getReader() != null || stream.getInputStream() != null)) {
                return DOMUtils.toDocumentFromStream((StreamSource)inputSource);
            }
            DOMResult domresult = new DOMResult(DOMUtils.newDocument());
            Transformer txer = DOMUtils.getTransformer();
            txer.transform(inputSource, domresult);
            return (Document)domresult.getNode();
        }
        catch (SAXException e) {
            DOMUtils.throwIOException(e);
        }
        catch (TransformerException e) {
            DOMUtils.throwIOException(e);
        }
        throw new IllegalArgumentException("Cannot parse XML source: " + inputSource.getClass());
    }

    public static boolean isEmptyElement(Element el) {
        NodeList nl = el.getChildNodes();
        int len = nl.getLength();
        block4: for (int i = 0; i < len; ++i) {
            switch (nl.item(i).getNodeType()) {
                case 3: 
                case 4: {
                    String s = nl.item(i).getNodeValue();
                    if (s == null || s.trim().length() <= 0) continue block4;
                    return false;
                }
                case 1: {
                    return false;
                }
            }
        }
        return true;
    }

    public static QName getNodeQName(Node el) {
        String localName = el.getLocalName();
        String namespaceUri = el.getNamespaceURI();
        if (localName == null) {
            String nodeName = el.getNodeName();
            int colonIndex = nodeName.indexOf(":");
            if (colonIndex > 0) {
                localName = nodeName.substring(0, colonIndex);
                namespaceUri = nodeName.substring(colonIndex + 1);
            } else {
                localName = nodeName;
                namespaceUri = null;
            }
        }
        return new QName(namespaceUri, localName);
    }

    public static QName getNodeQName(String qualifiedName) {
        int index = qualifiedName.indexOf(":");
        if (index >= 0) {
            return new QName(qualifiedName.substring(0, index), qualifiedName.substring(index + 1));
        }
        return new QName(qualifiedName);
    }

    public static void removeChildren(Node target) {
        while (target.hasChildNodes()) {
            target.removeChild(target.getFirstChild());
        }
    }

    public static void removeAttributes(Element target, boolean flag) {
        if (!target.hasAttributes()) {
            return;
        }
        String prefix = target.getPrefix();
        NamedNodeMap nnm = target.getAttributes();
        Attr toPutBack = null;
        if (flag) {
            toPutBack = prefix == null ? target.getAttributeNodeNS(NS_URI_XMLNS, "xmlns") : target.getAttributeNodeNS(NS_URI_XMLNS, "xmlns:" + prefix);
        }
        while (nnm.getLength() != 0) {
            target.removeAttributeNode((Attr)nnm.item(0));
        }
        if (toPutBack != null) {
            target.setAttributeNodeNS(toPutBack);
        }
    }

    public static Element findChildByName(Element parent, QName name) {
        return DOMUtils.findChildByName(parent, name, false);
    }

    public static Element findChildByName(Element parent, QName name, boolean recurse) {
        if (parent == null) {
            throw new IllegalArgumentException("null parent");
        }
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String nodeName;
            Node c = nl.item(i);
            if (c.getNodeType() != 1) continue;
            String string = nodeName = c.getLocalName() != null ? c.getLocalName() : c.getNodeName();
            if (!new QName(c.getNamespaceURI(), nodeName).equals(name)) continue;
            return (Element)c;
        }
        if (recurse) {
            NodeList cnl = parent.getChildNodes();
            for (int i = 0; i < cnl.getLength(); ++i) {
                Element result;
                Node c = cnl.item(i);
                if (c.getNodeType() != 1 || (result = DOMUtils.findChildByName((Element)c, name, recurse)) == null) continue;
                return result;
            }
        }
        return null;
    }

    public static Node findChildByType(Element elem, int type) {
        if (elem == null) {
            throw new NullPointerException("elem parameter must not be null!");
        }
        for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != type) continue;
            return n;
        }
        return null;
    }

    public static String getTextContent(Node node) {
        for (int m = 0; m < node.getChildNodes().getLength(); ++m) {
            String childText;
            Node child = node.getChildNodes().item(m);
            if (child.getNodeType() != 3 || (childText = child.getNodeValue().trim()).length() <= 0) continue;
            return childText;
        }
        return null;
    }

    public static Element getElementContent(Node node) {
        for (int m = 0; m < node.getChildNodes().getLength(); ++m) {
            Node child = node.getChildNodes().item(m);
            if (child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    public static void injectNamespaces(Element domElement, NSContext nscontext) {
        for (String uri : nscontext.getUriSet()) {
            String prefix = nscontext.getPrefix(uri);
            if (prefix == null || "".equals(prefix)) {
                domElement.setAttributeNS(NS_URI_XMLNS, "xmlns", uri);
                continue;
            }
            domElement.setAttributeNS(NS_URI_XMLNS, "xmlns:" + prefix, uri);
        }
    }

    public static void copyNSContext(Element source, Element dest) {
        Map<String, String> sourceNS = DOMUtils.getParentNamespaces(source);
        sourceNS.putAll(DOMUtils.getMyNamespaces(source));
        Map<String, String> destNS = DOMUtils.getParentNamespaces(dest);
        destNS.putAll(DOMUtils.getMyNamespaces(dest));
        for (String string : destNS.keySet()) {
            sourceNS.remove(string);
        }
        for (Map.Entry entry : sourceNS.entrySet()) {
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            if (prefix == null || "".equals(prefix)) {
                dest.setAttributeNS(NS_URI_XMLNS, "xmlns", uri);
                continue;
            }
            dest.setAttributeNS(NS_URI_XMLNS, "xmlns:" + prefix, uri);
        }
    }

    public static Document toDOMDocument(Node node) throws TransformerException {
        if (node instanceof Document) {
            return (Document)node;
        }
        if (node instanceof Element) {
            Element elem = (Element)node;
            if (elem.getOwnerDocument().getDocumentElement() == elem) {
                return elem.getOwnerDocument();
            }
            Document doc = DOMUtils.newDocument();
            doc.appendChild(doc.importNode(node, true));
            return doc;
        }
        throw new TransformerException("Unable to convert DOM node to a Document");
    }

    public static Document toDocumentFromStream(StreamSource source) throws IOException, SAXException {
        DocumentBuilder builder = DOMUtils.getBuilder();
        Document document = null;
        Reader reader = source.getReader();
        if (reader != null) {
            document = builder.parse(new InputSource(reader));
        } else {
            InputStream inputStream = source.getInputStream();
            if (inputStream != null) {
                InputSource inputsource = new InputSource(inputStream);
                inputsource.setSystemId(source.getSystemId());
                document = builder.parse(inputsource);
            } else {
                throw new IOException("No input stream or reader available");
            }
        }
        return document;
    }

    private static void throwIOException(Throwable t) throws IOException {
        IOException e = new IOException(t.getMessage());
        e.setStackTrace(t.getStackTrace());
        throw e;
    }

    public static Document parse(XMLStreamReader reader) throws XMLStreamException {
        Document doc = DOMUtils.newDocument();
        DOMUtils.parse(reader, doc, doc);
        return doc;
    }

    private static void parse(XMLStreamReader reader, Document doc, Node parent) throws XMLStreamException {
        int event = reader.getEventType();
        while (reader.hasNext()) {
            switch (event) {
                case 1: {
                    String prefix;
                    Element e = doc.createElementNS(reader.getNamespaceURI(), reader.getLocalName());
                    if (reader.getPrefix() != null && reader.getPrefix() != "") {
                        e.setPrefix(reader.getPrefix());
                    }
                    parent.appendChild(e);
                    for (int ns = 0; ns < reader.getNamespaceCount(); ++ns) {
                        String uri = reader.getNamespaceURI(ns);
                        prefix = reader.getNamespacePrefix(ns);
                        DOMUtils.declare(e, uri, prefix);
                    }
                    for (int att = 0; att < reader.getAttributeCount(); ++att) {
                        String name = reader.getAttributeLocalName(att);
                        prefix = reader.getAttributePrefix(att);
                        if (prefix != null && prefix.length() > 0) {
                            name = prefix + ":" + name;
                        }
                        Attr attr = doc.createAttributeNS(reader.getAttributeNamespace(att), name);
                        attr.setValue(reader.getAttributeValue(att));
                        e.setAttributeNode(attr);
                    }
                    if (reader.hasNext()) {
                        reader.next();
                        DOMUtils.parse(reader, doc, e);
                    }
                    if (!(parent instanceof Document)) break;
                    while (reader.hasNext()) {
                        reader.next();
                    }
                    return;
                }
                case 2: {
                    return;
                }
                case 4: {
                    if (parent == null) break;
                    parent.appendChild(doc.createTextNode(reader.getText()));
                    break;
                }
                case 5: {
                    if (parent == null) break;
                    parent.appendChild(doc.createComment(reader.getText()));
                    break;
                }
                case 12: {
                    parent.appendChild(doc.createCDATASection(reader.getText()));
                    break;
                }
                case 3: {
                    parent.appendChild(doc.createProcessingInstruction(reader.getPITarget(), reader.getPIData()));
                    break;
                }
                case 9: {
                    parent.appendChild(doc.createProcessingInstruction(reader.getPITarget(), reader.getPIData()));
                    break;
                }
                case 10: 
                case 13: {
                    break;
                }
            }
            if (!reader.hasNext()) continue;
            event = reader.next();
        }
    }

    private static void declare(Element node, String uri, String prefix) {
        if (prefix != null && prefix.length() > 0) {
            node.setAttributeNS(NS_URI_XMLNS, "xmlns:" + prefix, uri);
        } else if (uri != null) {
            node.setAttributeNS(NS_URI_XMLNS, "xmlns", uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Transformer getTransformer() {
        Transformer txer = __txers.get();
        if (txer == null) {
            TransformerFactory transformerFactory = _transformerFactory;
            synchronized (transformerFactory) {
                try {
                    txer = _transformerFactory.newTransformer();
                }
                catch (TransformerConfigurationException e) {
                    String errmsg = "Transformer configuration error!";
                    __log.fatal((Object)errmsg, (Throwable)e);
                    throw new Error(errmsg, e);
                }
            }
            __txers.set(txer);
        }
        return txer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentBuilder getBuilder() {
        DocumentBuilder builder = __builders.get();
        if (builder == null) {
            DocumentBuilderFactory documentBuilderFactory = __documentBuilderFactory;
            synchronized (documentBuilderFactory) {
                try {
                    builder = __documentBuilderFactory.newDocumentBuilder();
                    builder.setErrorHandler(new LoggingErrorHandler());
                }
                catch (ParserConfigurationException e) {
                    __log.error((Object)e);
                    throw new RuntimeException(e);
                }
            }
            __builders.set(builder);
        }
        return builder;
    }

    public static List<Element> findChildrenByName(Element parent, QName name) {
        if (parent == null) {
            throw new IllegalArgumentException("null parent");
        }
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        LinkedList<Element> ret = new LinkedList<Element>();
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String nodeName;
            Node c = nl.item(i);
            if (c.getNodeType() != 1) continue;
            String string = nodeName = c.getLocalName() != null ? c.getLocalName() : c.getNodeName();
            if (!new QName(c.getNamespaceURI(), nodeName).equals(name)) continue;
            ret.add((Element)c);
        }
        return ret;
    }

    public static List<Node> toList(Object nl) {
        if (nl == null) {
            return null;
        }
        if (nl instanceof List) {
            return (List)nl;
        }
        NodeList cnl = (NodeList)nl;
        ArrayList<Node> ll = new ArrayList<Node>();
        for (int m = 0; m < cnl.getLength(); ++m) {
            ll.add(cnl.item(m));
        }
        return ll;
    }

    public static Document getDocument(Node contextNode) {
        return contextNode == null ? DOMUtils.newDocument() : contextNode.getOwnerDocument();
    }

    public static String getQualifiedName(QName qName) {
        String prefix = qName.getPrefix();
        String localPart = qName.getLocalPart();
        return prefix == null || "".equals(prefix) ? localPart : prefix + ":" + localPart;
    }

    public static Node cloneNode(Document document, Node sourceNode) {
        int i;
        Node clonedNode = null;
        QName sourceQName = DOMUtils.getNodeQName(sourceNode);
        String nodeName = sourceQName.getLocalPart();
        String namespaceURI = sourceQName.getNamespaceURI();
        if (Namespaces.WSBPEL2_0_FINAL_EXEC.equals(namespaceURI)) {
            namespaceURI = null;
        }
        switch (sourceNode.getNodeType()) {
            case 2: {
                if (namespaceURI == null) {
                    clonedNode = document.createAttribute(nodeName);
                    break;
                }
                String prefix = ((Attr)sourceNode).lookupPrefix(namespaceURI);
                if (prefix == null && namespaceURI.equals(NS_URI_XMLNS)) {
                    prefix = "xmlns";
                }
                if (prefix != null && !"".equals(prefix)) {
                    nodeName = prefix + ":" + nodeName;
                }
                if (prefix != null) {
                    clonedNode = document.createAttributeNS(namespaceURI, nodeName);
                    break;
                }
                clonedNode = document.createAttribute(nodeName);
                break;
            }
            case 4: {
                clonedNode = document.createCDATASection(((CDATASection)sourceNode).getData());
                break;
            }
            case 8: {
                clonedNode = document.createComment(((Comment)sourceNode).getData());
                break;
            }
            case 11: {
                clonedNode = document.createDocumentFragment();
                break;
            }
            case 9: {
                clonedNode = document;
                break;
            }
            case 1: {
                String prefix;
                if (namespaceURI == null) {
                    clonedNode = document.createElement(nodeName);
                } else {
                    String string = prefix = namespaceURI.equals(Namespaces.XMLNS_URI) ? "xmlns" : ((Element)sourceNode).lookupPrefix(namespaceURI);
                    if (prefix != null && !"".equals(prefix)) {
                        nodeName = prefix + ":" + nodeName;
                        clonedNode = document.createElementNS(namespaceURI, nodeName);
                    } else {
                        clonedNode = document.createElement(nodeName);
                    }
                }
                NamedNodeMap attributes = ((Element)sourceNode).getAttributes();
                for (i = 0; i < attributes.getLength(); ++i) {
                    Attr attributeClone = (Attr)DOMUtils.cloneNode(document, attributes.item(i));
                    if (attributeClone.getNamespaceURI() == null) {
                        ((Element)clonedNode).setAttributeNode(attributeClone);
                        continue;
                    }
                    ((Element)clonedNode).setAttributeNodeNS(attributeClone);
                }
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                clonedNode = document.createEntityReference(nodeName);
                break;
            }
            case 12: {
                break;
            }
            case 7: {
                clonedNode = document.createProcessingInstruction(((ProcessingInstruction)sourceNode).getData(), nodeName);
                break;
            }
            case 3: {
                clonedNode = document.createTextNode(((Text)sourceNode).getData());
                break;
            }
        }
        NodeList sourceChildren = sourceNode.getChildNodes();
        if (sourceChildren != null) {
            for (i = 0; i < sourceChildren.getLength(); ++i) {
                Node sourceChild = sourceChildren.item(i);
                Node clonedChild = DOMUtils.cloneNode(document, sourceChild);
                clonedNode.appendChild(clonedChild);
                if (clonedChild.getNodeType() != 3 && clonedChild.getNodeType() != 4) continue;
                DOMUtils.parseEmbeddedPrefixes(sourceNode, clonedNode, clonedChild);
            }
        }
        return clonedNode;
    }

    private static void parseEmbeddedPrefixes(Node sourceNode, Node clonedNode, Node clonedChild) {
        Element clonedElement = null;
        if (clonedNode instanceof Attr) {
            clonedElement = ((Attr)clonedNode).getOwnerElement();
        } else if (clonedNode instanceof Element) {
            clonedElement = (Element)clonedNode;
        }
        if (clonedElement == null) {
            return;
        }
        String text = ((Text)clonedChild).getNodeValue();
        if (text != null && text.indexOf(":") > 0) {
            Name11Checker nameChecker = Name11Checker.getInstance();
            int colonIndex = text.indexOf(":");
            while (colonIndex != -1 && colonIndex < text.length()) {
                String uri;
                StringBuffer prefixString = new StringBuffer();
                for (int prefixIndex = colonIndex - 1; prefixIndex >= 0 && nameChecker.isNCNameChar((int)text.charAt(prefixIndex)); --prefixIndex) {
                    prefixString.append(text.charAt(prefixIndex));
                }
                prefixString.reverse();
                if (prefixString.length() > 0 && (uri = sourceNode.lookupNamespaceURI(prefixString.toString())) != null) {
                    clonedElement.setAttributeNS(NS_URI_XMLNS, "xmlns:" + prefixString, uri);
                }
                colonIndex = text.indexOf(":", colonIndex + 1);
            }
        }
    }

    public static Element stringToDOM(byte[] bytes) throws SAXException, IOException {
        return DOMUtils.stringToDOM(new String(bytes));
    }

    public static byte[] domToBytes(Element element) {
        String stringifiedElement = DOMUtils.domToString(element);
        return stringifiedElement != null ? stringifiedElement.getBytes() : null;
    }

    static {
        DOMUtils.initDocumentBuilderFactory();
    }
}

